/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.pda;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.html.HtmlFrame;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public class FrameRenderer
extends XhtmlRenderer {
    private PropertyKey _sourceKey;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(FrameRenderer.class);

    public FrameRenderer() {
        this(HtmlFrame.TYPE);
    }

    protected FrameRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._sourceKey = type.findKey("source");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected final void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        UIComponent parent = component.getParent();
        if (parent == null || !"org.apache.myfaces.trinidad.FrameBorderLayout".equals(parent.getFamily())) {
            _LOG.warning("FRAMES_MUST_INSIDE_FRAMEBORDERLAYOUTS");
        } else {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("a", component);
            this.renderId(context, component);
            String source = FrameRenderer.toResourceUri((FacesContext)context, (Object)bean.getProperty(this._sourceKey));
            String shortDesc = this.getShortDesc(component, bean);
            FrameRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"OraLink");
            this.renderEncodedActionURI(context, "href", source);
            if (shortDesc != null) {
                writer.writeText((Object)shortDesc, "shortDesc");
            } else if (source != null) {
                writer.writeText((Object)source, null);
            }
            writer.endElement("a");
        }
    }
}

