/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.html.HtmlCellFormat;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public class CellFormatRenderer
extends XhtmlRenderer {
    private PropertyKey _widthKey;
    private PropertyKey _heightKey;
    private PropertyKey _halignKey;
    private PropertyKey _valignKey;
    private PropertyKey _shortTextKey;
    private PropertyKey _columnSpanKey;
    private PropertyKey _rowSpanKey;
    private PropertyKey _wrappingDisabledKey;
    private PropertyKey _headersKey;
    private PropertyKey _headerKey;

    public CellFormatRenderer() {
        super(HtmlCellFormat.TYPE);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._widthKey = type.findKey("width");
        this._heightKey = type.findKey("height");
        this._halignKey = type.findKey("halign");
        this._valignKey = type.findKey("valign");
        this._shortTextKey = type.findKey("shortText");
        this._columnSpanKey = type.findKey("columnSpan");
        this._rowSpanKey = type.findKey("rowSpan");
        this._wrappingDisabledKey = type.findKey("wrappingDisabled");
        this._headersKey = type.findKey("headers");
        this._headerKey = type.findKey("header");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        int rowspan;
        ResponseWriter rw = context.getResponseWriter();
        String element = this.isHeader(component, bean) ? "th" : "td";
        rw.startElement(element, component);
        this.renderId(context, component);
        this.renderAllAttributes(context, rc, component, bean);
        CellFormatRenderer.renderHAlign(context, rc, this.getHalign(component, bean));
        rw.writeAttribute("valign", this.getValign(component, bean), "valign");
        rw.writeAttribute("abbr", this.getShortText(component, bean), "shortText");
        rw.writeAttribute("headers", this.getHeaders(component, bean), "headers");
        rw.writeAttribute("width", this.getWidth(component, bean), "width");
        rw.writeAttribute("height", this.getHeight(component, bean), "height");
        int colspan = this.getColumnSpan(component, bean);
        if (colspan > 1) {
            rw.writeAttribute("colspan", (Object)colspan, "columnSpan");
        }
        if ((rowspan = this.getRowSpan(component, bean)) > 1) {
            rw.writeAttribute("rowspan", (Object)rowspan, "rowSpan");
        }
        if (this.isWrappingDisabled(component, bean) && CellFormatRenderer.isDesktop((RenderingContext)rc)) {
            rw.writeAttribute("nowrap", (Object)Boolean.TRUE, "wrappingDisabled");
        }
        this.encodeAllChildren(context, component);
        rw.endElement(element);
    }

    protected Object getWidth(UIComponent component, FacesBean bean) {
        return bean.getProperty(this._widthKey);
    }

    protected Object getHeight(UIComponent component, FacesBean bean) {
        return bean.getProperty(this._heightKey);
    }

    protected Object getHalign(UIComponent component, FacesBean bean) {
        return bean.getProperty(this._halignKey);
    }

    protected Object getValign(UIComponent component, FacesBean bean) {
        return bean.getProperty(this._valignKey);
    }

    protected boolean isWrappingDisabled(UIComponent component, FacesBean bean) {
        return Boolean.TRUE.equals(bean.getProperty(this._wrappingDisabledKey));
    }

    protected Object getShortText(UIComponent component, FacesBean bean) {
        return bean.getProperty(this._shortTextKey);
    }

    protected int getColumnSpan(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._columnSpanKey);
        if (o == null) {
            return 1;
        }
        return CellFormatRenderer.toInt((Object)o);
    }

    protected int getRowSpan(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._rowSpanKey);
        if (o == null) {
            return 1;
        }
        return CellFormatRenderer.toInt((Object)o);
    }

    protected Object getHeaders(UIComponent component, FacesBean bean) {
        return bean.getProperty(this._headersKey);
    }

    protected boolean isHeader(UIComponent component, FacesBean bean) {
        return Boolean.TRUE.equals(bean.getProperty(this._headerKey));
    }
}

