/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.share.io.InputStreamProvider;
import org.apache.myfaces.trinidad.share.io.NameResolver;
import org.apache.myfaces.trinidadinternal.share.io.CachingInputStreamProvider;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.apache.myfaces.trinidadinternal.share.xml.XMLUtils;
import org.apache.myfaces.trinidadinternal.skin.AgentAtRuleMatcher;
import org.apache.myfaces.trinidadinternal.skin.SkinCSSParser;
import org.apache.myfaces.trinidadinternal.skin.SkinSelectorPropertiesNode;
import org.apache.myfaces.trinidadinternal.skin.SkinStyleSheetNode;
import org.apache.myfaces.trinidadinternal.skin.SkinStyleSheetParserUtils;
import org.apache.myfaces.trinidadinternal.style.util.NameUtils;
import org.apache.myfaces.trinidadinternal.style.xml.parse.PropertyNode;
import org.apache.myfaces.trinidadinternal.util.nls.LocaleUtils;

public class SkinCSSDocumentHandler {
    private static final String _AT_AGENT = "@agent";
    private static final String _AT_PLATFORM = "@platform";
    private static final String _AT_LOCALE = "@locale";
    private static final String _AT_ACC_PROFILE = "@accessibility-profile";
    private static final String _AT_MODE = "@mode";
    private static final String _AT_IMPORT = "@import";
    private static final String _AT_NAMESPACE = "@namespace";
    private static final String _AT_CHARSET = "@charset";
    private static final String _AT_FONT_FACE = "@font-face";
    private static final String _AT_PAGE = "@page";
    private static final String _AT_TOKEN = "_AT_TOKEN_";
    private static final String _AT = "@";
    private boolean _inStyleRule = false;
    private List<PropertyNode> _propertyNodeList = null;
    private List<CompleteSelectorNode> _completeSelectorNodeList = new ArrayList<CompleteSelectorNode>();
    private int[] _selectorPlatforms = null;
    private AgentAtRuleMatcher _agentAtRuleMatcher = null;
    private Set<Locale> _locales = null;
    private int _mode = 0;
    private String _clientRule;
    private LinkedList<Set<String>> _selectorAccPropertiesStack = new LinkedList();
    private Map<String, String> _namespaceMap = new HashMap<String, String>();
    private ParseContext _parseContext;
    private List<List<SkinStyleSheetNode>> _imports;
    private boolean _ignoreImports = false;
    private static final String _SHARE_NAMESPACE = "org.apache.myfaces.trinidadinternal.skin.SkinCSSDocumentHandler";
    private static final String _INCLUDE_STACK = "_includeStack";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SkinCSSDocumentHandler.class);

    public SkinCSSDocumentHandler(ParseContext pContext) {
        this._parseContext = pContext;
    }

    public List<SkinStyleSheetNode> getSkinStyleSheetNodes() {
        List<SkinStyleSheetNode> skinStyleSheetNodes = this._createSkinStyleSheetNodes(this._completeSelectorNodeList, this._namespaceMap);
        ArrayList<SkinStyleSheetNode> allSkinStyleSheetNodes = new ArrayList<SkinStyleSheetNode>();
        if (this._imports != null && !this._imports.isEmpty()) {
            for (List<SkinStyleSheetNode> nodeList : this._imports) {
                for (SkinStyleSheetNode node : nodeList) {
                    allSkinStyleSheetNodes.add(node);
                }
            }
        }
        allSkinStyleSheetNodes.addAll(skinStyleSheetNodes);
        return allSkinStyleSheetNodes;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void comment(String text) {
    }

    public void startSelector() {
        this._inStyleRule = true;
        this._ignoreImports = true;
        this._propertyNodeList = new ArrayList<PropertyNode>();
    }

    public void endSelector(List<String> selectors) {
        if (selectors == null) {
            return;
        }
        int selectorNum = selectors.size();
        for (int i = 0; i < selectorNum; ++i) {
            String selector = selectors.get(i);
            if (selector.startsWith(_AT_TOKEN)) {
                selector = selector.replace(_AT_TOKEN, _AT);
            }
            CompleteSelectorNode node = this._createCompleteSelectorNode(selector, this._propertyNodeList, this._locales, this._agentAtRuleMatcher, this._selectorPlatforms, this._getSelectorAccProperties(), this._mode, this._clientRule);
            this._completeSelectorNodeList.add(node);
        }
        this._inStyleRule = false;
        this._propertyNodeList = null;
    }

    public void property(String name, String value) {
        if (this._inStyleRule && this._propertyNodeList != null) {
            if (name == null || "".equals(name)) {
                _LOG.severe("ERR_PARSING_SKIN_CSS_FILE", new Object[]{name, value});
            } else {
                this._propertyNodeList.add(new PropertyNode(name, value));
            }
        }
    }

    public void atRule(String atRule) {
        boolean importRule = atRule.startsWith(_AT_IMPORT);
        boolean charsetRule = atRule.startsWith(_AT_CHARSET);
        if (atRule != null) {
            if (importRule) {
                if (this._ignoreImports) {
                    if (_LOG.isWarning()) {
                        _LOG.warning("AT_IMPORT_NOT_FIRST", (Object)atRule);
                    }
                } else {
                    this._parseImport(atRule);
                }
            } else if (atRule.startsWith(_AT_PAGE) || atRule.startsWith(_AT_FONT_FACE)) {
                this._parseClientSideSelector(atRule);
            } else if (atRule.startsWith(_AT_NAMESPACE)) {
                this._parseNamespace(this._namespaceMap, atRule);
            } else if (atRule.startsWith(_AT_AGENT)) {
                this._parseCustomAtRule(_AT_AGENT, atRule);
            } else if (atRule.startsWith(_AT_PLATFORM)) {
                this._parseCustomAtRule(_AT_PLATFORM, atRule);
            } else if (atRule.startsWith(_AT_LOCALE)) {
                this._parseCustomAtRule(_AT_LOCALE, atRule);
            } else if (atRule.startsWith(_AT_ACC_PROFILE)) {
                this._parseCustomAtRule(_AT_ACC_PROFILE, atRule);
            } else if (atRule.startsWith(_AT_MODE)) {
                this._parseCustomAtRule(_AT_MODE, atRule);
            } else if (atRule.startsWith(_AT) && !charsetRule) {
                this._parseCustomAtRule(null, atRule);
            }
            if (!importRule && !charsetRule) {
                this._ignoreImports = true;
            }
        }
    }

    private void _parseNamespace(Map<String, String> namespaceMap, String atRule) {
        String[] namespaceParts = atRule.split("\\s+");
        if (namespaceParts.length > 2) {
            String url = this._extractUrl(namespaceParts[2]);
            namespaceMap.put(namespaceParts[1], url);
        }
    }

    private String _extractUrl(String urlString) {
        if ((urlString = urlString.trim()).startsWith("url(")) {
            urlString = urlString.substring(4);
        }
        if (urlString.endsWith(");")) {
            urlString = urlString.substring(0, urlString.length() - 2);
        } else if (urlString.endsWith(";")) {
            urlString = urlString.substring(0, urlString.length() - 1);
        }
        urlString = SkinStyleSheetParserUtils.trimQuotes(urlString);
        return urlString;
    }

    private void _parseImport(String type) {
        String styleSheetName = this._extractUrl(type.substring(8));
        try {
            if (this._imports == null) {
                this._imports = new ArrayList<List<SkinStyleSheetNode>>();
            }
            this._imports.add(this._parseImportStyleSheetFile(this._parseContext, styleSheetName, List.class));
        }
        catch (IOException e) {
            if (_LOG.isSevere()) {
                _LOG.severe("CANNOT_LOAD_STYLESHEET", (Object)styleSheetName);
            }
            _LOG.severe((Throwable)e);
        }
        catch (ParseException e) {
            _LOG.severe((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SkinStyleSheetNode> _parseImportStyleSheetFile(ParseContext context, String sourceName, Class<?> expectedType) throws IOException, ParseException {
        NameResolver resolver = XMLUtils.getResolver(context);
        if (resolver == null) {
            if (_LOG.isWarning()) {
                _LOG.warning("Internal error: couldn't find NameResolver");
            }
            return Collections.emptyList();
        }
        InputStreamProvider importProvider = resolver.getProvider(sourceName);
        InputStreamProvider baseProvider = XMLUtils.getInputStreamProvider(context);
        if (baseProvider instanceof CachingInputStreamProvider) {
            ((CachingInputStreamProvider)baseProvider).addCacheDependency(importProvider);
        }
        ArrayList<Object> list = (ArrayList<Object>)context.getProperty(_SHARE_NAMESPACE, _INCLUDE_STACK);
        Object identifier = importProvider.getIdentifier();
        if (list != null && list.contains(identifier)) {
            throw new ParseException(_LOG.getMessage("CIRCULAR_INCLUDE_DETECTED", (Object)sourceName), 0);
        }
        ParseContext newContext = (ParseContext)context.clone();
        list = list == null ? new ArrayList<Object>() : new ArrayList(list);
        list.add(identifier);
        newContext.setProperty(_SHARE_NAMESPACE, _INCLUDE_STACK, list);
        InputStream stream = importProvider.openInputStream();
        try {
            XMLUtils.setResolver(newContext, resolver.getResolver(sourceName));
            XMLUtils.setInputStreamProvider(newContext, importProvider);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            SkinCSSParser parser = new SkinCSSParser();
            SkinCSSDocumentHandler documentHandler = new SkinCSSDocumentHandler(newContext);
            parser.parseCSSDocument(reader, documentHandler);
            List<SkinStyleSheetNode> importSkinSSNodeList = documentHandler.getSkinStyleSheetNodes();
            reader.close();
            List<SkinStyleSheetNode> list2 = importSkinSSNodeList;
            return list2;
        }
        finally {
            stream.close();
        }
    }

    private void _parseClientSideSelector(String atRule) {
        atRule = atRule.replace(_AT, _AT_TOKEN);
        SkinCSSParser parser = new SkinCSSParser();
        parser.parseCSSDocument(new StringReader(atRule), this);
    }

    private void _parseCustomAtRule(String type, String atRule) {
        String content = this._getAtRuleContent(atRule);
        if (content != null) {
            this._initAtRuleTargetTypes(type, atRule);
            SkinCSSParser parser = new SkinCSSParser();
            parser.parseCSSDocument(new StringReader(content), this);
            this._resetAtRuleTargetTypes(type);
        } else {
            _LOG.warning("UNSUPPORTED_AT_RULE", (Object)atRule);
        }
    }

    private void _resetAtRuleTargetTypes(String type) {
        if (type == null) {
            this._clientRule = null;
        } else if (_AT_AGENT.equals(type)) {
            this._agentAtRuleMatcher = null;
        } else if (_AT_PLATFORM.equals(type)) {
            this._selectorPlatforms = null;
        } else if (_AT_LOCALE.equals(type)) {
            this._locales = null;
        } else if (_AT_ACC_PROFILE.equals(type)) {
            assert (!this._selectorAccPropertiesStack.isEmpty());
            if (!this._selectorAccPropertiesStack.isEmpty()) {
                this._selectorAccPropertiesStack.removeLast();
            }
        } else if (_AT_MODE.equals(type)) {
            this._mode = 0;
        }
    }

    private CompleteSelectorNode _createCompleteSelectorNode(String selector, List<PropertyNode> propertyNodeList, Set<Locale> locales, AgentAtRuleMatcher agentMatcher, int[] selectorPlatforms, Set<String> selectorAccProperties, int mode, String clientRule) {
        int direction = 0;
        if (selector.endsWith(":rtl")) {
            int length = ":rtl".length();
            selector = selector.substring(0, selector.length() - length);
            direction = 2;
        } else if (selector.endsWith(":ltr")) {
            int length = ":ltr".length();
            selector = selector.substring(0, selector.length() - length);
            direction = 1;
        }
        return new CompleteSelectorNode(selector, propertyNodeList, locales, direction, agentMatcher, selectorPlatforms, selectorAccProperties, mode, clientRule);
    }

    private List<SkinStyleSheetNode> _createSkinStyleSheetNodes(List<CompleteSelectorNode> selectorList, Map<String, String> namespaceMap) {
        ArrayList<SkinStyleSheetNode> skinStyleSheetNodes = new ArrayList<SkinStyleSheetNode>();
        for (CompleteSelectorNode completeSelectorNode : selectorList) {
            int direction = completeSelectorNode.getDirection();
            AgentAtRuleMatcher agentMatcher = completeSelectorNode.getAgentMatcher();
            int[] platforms = completeSelectorNode.getPlatforms();
            Set<Locale> locales = completeSelectorNode.getLocales();
            Set<String> accProperties = completeSelectorNode.getAccessibilityProperties();
            int mode = completeSelectorNode.getMode();
            String clientRule = completeSelectorNode.getClientRule();
            boolean match = false;
            for (int i = skinStyleSheetNodes.size() - 1; i >= 0 && !match; --i) {
                SkinStyleSheetNode ssNode = (SkinStyleSheetNode)skinStyleSheetNodes.get(i);
                match = ssNode.matches(direction, agentMatcher, platforms, locales, accProperties, mode, clientRule);
                if (!match) continue;
                ssNode.add(completeSelectorNode.getSkinSelectorPropertiesNode());
            }
            if (match) continue;
            SkinStyleSheetNode ssNode = new SkinStyleSheetNode(namespaceMap, direction, locales, agentMatcher, platforms, accProperties, mode, clientRule);
            ssNode.add(completeSelectorNode.getSkinSelectorPropertiesNode());
            skinStyleSheetNodes.add(ssNode);
        }
        return skinStyleSheetNodes;
    }

    private void _initAtRuleTargetTypes(String type, String atRule) {
        int firstSpace = atRule.indexOf(32);
        int openBrace = atRule.indexOf(123);
        if (firstSpace != -1 && openBrace != -1) {
            String types = atRule.substring(firstSpace, openBrace);
            String[] typeArray = types.split(",");
            if (type == null) {
                this._clientRule = atRule.substring(0, openBrace);
            } else if (_AT_AGENT.equals(type)) {
                this._agentAtRuleMatcher = new AgentAtRuleMatcher(typeArray);
            } else if (_AT_PLATFORM.equals(type)) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (int i = 0; i < typeArray.length; ++i) {
                    int platformInt = NameUtils.getPlatform(typeArray[i].trim());
                    if (platformInt == 0) continue;
                    list.add(platformInt);
                }
                this._selectorPlatforms = this._getIntArray(list);
            } else if (_AT_LOCALE.equals(type)) {
                this._locales = new HashSet<Locale>();
                for (int i = 0; i < typeArray.length; ++i) {
                    Locale locale = LocaleUtils.getLocaleForIANAString(typeArray[i].replace('_', '-').trim());
                    this._locales.add(locale);
                }
            } else if (_AT_ACC_PROFILE.equals(type)) {
                Set<String> set = new HashSet<String>(typeArray.length * 2);
                for (int i = 0; i < typeArray.length; ++i) {
                    String accProp = typeArray[i].trim();
                    if (NameUtils.isAccessibilityPropertyName(accProp)) {
                        set.add(accProp);
                        continue;
                    }
                    _LOG.warning("INVALID_ACC_PROFILE", new Object[]{accProp});
                }
                if (!this._selectorAccPropertiesStack.isEmpty()) {
                    set = this._mergeAccProperties(this._selectorAccPropertiesStack.getLast(), set);
                }
                this._selectorAccPropertiesStack.add(set);
            } else if (_AT_MODE.equals(type)) {
                this._mode = NameUtils.getMode(typeArray[0].trim());
            }
        }
    }

    private int[] _getIntArray(List<Integer> integerList) {
        int count = integerList.size();
        if (count == 0) {
            return null;
        }
        int[] array = new int[count];
        for (int i = 0; i < count; ++i) {
            array[i] = integerList.get(i);
        }
        return array;
    }

    private String _getAtRuleContent(String atRule) {
        int openBraceIndex = atRule.indexOf(123);
        int endBraceIndex = atRule.lastIndexOf(125);
        if (endBraceIndex == -1) {
            endBraceIndex = atRule.length();
        }
        if (openBraceIndex == -1) {
            return null;
        }
        return atRule.substring(openBraceIndex + 1, endBraceIndex);
    }

    private Set<String> _getSelectorAccProperties() {
        return this._selectorAccPropertiesStack.isEmpty() ? null : this._selectorAccPropertiesStack.getLast();
    }

    private Set<String> _mergeAccProperties(Set<String> oldProperties, Set<String> newProperties) {
        if (oldProperties == null || oldProperties.isEmpty()) {
            return newProperties;
        }
        if (newProperties == null || newProperties.isEmpty()) {
            return new HashSet<String>(oldProperties);
        }
        int mergedSize = oldProperties.size() + newProperties.size();
        HashSet<String> mergedProperties = new HashSet<String>(mergedSize * 2);
        for (String oldProperty : oldProperties) {
            for (String newProperty : newProperties) {
                mergedProperties.add(oldProperty + "&" + newProperty);
            }
        }
        return mergedProperties;
    }

    private static class CompleteSelectorNode {
        private final SkinSelectorPropertiesNode _node;
        private final int _direction;
        private final AgentAtRuleMatcher _agentMatcher;
        private final int[] _platforms;
        private final Set<Locale> _locales;
        private final Set<String> _accProperties;
        private int _mode;
        private final String _clientRule;

        public CompleteSelectorNode(String selectorName, List<PropertyNode> propertyNodes, Set<Locale> locales, int direction, AgentAtRuleMatcher agentMatcher, int[] platforms, Set<String> accProperties, int mode, String clientRule) {
            this._node = new SkinSelectorPropertiesNode(selectorName, propertyNodes);
            this._direction = direction;
            this._agentMatcher = agentMatcher;
            this._platforms = CompleteSelectorNode._copyIntArray(platforms);
            this._locales = locales != null ? new HashSet<Locale>(locales) : Collections.emptySet();
            this._accProperties = accProperties != null ? new HashSet<String>(accProperties) : null;
            this._mode = mode;
            this._clientRule = clientRule;
        }

        public SkinSelectorPropertiesNode getSkinSelectorPropertiesNode() {
            return this._node;
        }

        public int getDirection() {
            return this._direction;
        }

        public AgentAtRuleMatcher getAgentMatcher() {
            return this._agentMatcher;
        }

        public int[] getPlatforms() {
            return this._platforms;
        }

        public Set<Locale> getLocales() {
            return this._locales;
        }

        public Set<String> getAccessibilityProperties() {
            return this._accProperties;
        }

        public int getMode() {
            return this._mode;
        }

        public String getClientRule() {
            return this._clientRule;
        }

        private static int[] _copyIntArray(int[] array) {
            if (array == null) {
                return null;
            }
            int[] copy = new int[array.length];
            System.arraycopy(array, 0, copy, 0, array.length);
            return copy;
        }
    }
}

