/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.change;

import java.io.Serializable;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.trinidad.change.ComponentChange;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

public class AttributeComponentChange
extends ComponentChange {
    private final String _attributeName;
    private final Object _attributeValue;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(AttributeComponentChange.class);
    private static final long serialVersionUID = 1L;

    public AttributeComponentChange(String attributeName, Object attributeValue) {
        if (attributeName == null || attributeName.length() == 0) {
            throw new IllegalArgumentException(_LOG.getMessage("CANNOT_CONSTRUCT_ATTRIBUTECHANGE_WITH_NULL_NAME"));
        }
        if (attributeValue != null && !(attributeValue instanceof Serializable)) {
            throw new IllegalArgumentException(_LOG.getMessage("UNSERIALIZABLE_VALUE", attributeValue));
        }
        this._attributeName = attributeName;
        this._attributeValue = attributeValue;
    }

    public String getAttributeName() {
        return this._attributeName;
    }

    public Object getAttributeValue() {
        return this._attributeValue;
    }

    @Override
    public void changeComponent(UIComponent uiComponent) {
        Map attributeMap = uiComponent.getAttributes();
        if (this._attributeValue instanceof ValueExpression) {
            uiComponent.setValueExpression(this._attributeName, (ValueExpression)this._attributeValue);
            attributeMap.remove(this._attributeName);
        } else if (this._attributeValue instanceof ValueBinding) {
            uiComponent.setValueBinding(this._attributeName, (ValueBinding)this._attributeValue);
            attributeMap.remove(this._attributeName);
        } else {
            attributeMap.put(this._attributeName, this._attributeValue);
        }
    }

    public String toString() {
        return super.toString() + "[attribute=" + this._attributeName + ",value=" + this._attributeValue + "]";
    }

    public int hashCode() {
        int hashCode = this._attributeName.hashCode();
        if (this._attributeValue != null) {
            hashCode += 37 * this._attributeValue.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeComponentChange)) {
            return false;
        }
        AttributeComponentChange other = (AttributeComponentChange)o;
        return this._attributeName.equals(other._attributeName) && (this._attributeValue == null ? other._attributeValue == null : this._attributeValue.equals(other._attributeValue));
    }
}

