/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.skin;

import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.trinidad.skin.SkinFeatures;
import org.apache.myfaces.trinidad.util.ToStringHelper;

public class SkinAddition
implements Comparable {
    private final String _styleSheetName;
    private final String _skinId;
    private final String _resourceBundleName;
    private final ValueExpression _translationSourceVE;
    private final ValueBinding _translationSourceVB;
    private final Map<String, String> _skinFeatures;

    @Deprecated
    public SkinAddition(String styleSheetName, String resourceBundleName) {
        this._styleSheetName = styleSheetName;
        this._resourceBundleName = resourceBundleName;
        this._translationSourceVE = null;
        this._translationSourceVB = null;
        this._skinFeatures = null;
        this._skinId = null;
    }

    @Deprecated
    public SkinAddition(String styleSheetName, ValueExpression translationSourceValueExpression) {
        this._styleSheetName = styleSheetName;
        this._resourceBundleName = null;
        this._translationSourceVE = translationSourceValueExpression;
        this._translationSourceVB = null;
        this._skinFeatures = null;
        this._skinId = null;
    }

    @Deprecated
    public SkinAddition(String styleSheetName) {
        this._styleSheetName = styleSheetName;
        this._resourceBundleName = null;
        this._translationSourceVE = null;
        this._translationSourceVB = null;
        this._skinFeatures = null;
        this._skinId = null;
    }

    @Deprecated
    public SkinAddition(String styleSheetName, String resourceBundleName, Map<String, String> features) {
        this._styleSheetName = styleSheetName;
        this._resourceBundleName = resourceBundleName;
        this._translationSourceVE = null;
        this._translationSourceVB = null;
        this._skinFeatures = features;
        this._skinId = null;
    }

    @Deprecated
    public SkinAddition(String styleSheetName, ValueExpression translationSourceValueExpression, Map<String, String> features) {
        this._styleSheetName = styleSheetName;
        this._resourceBundleName = null;
        this._translationSourceVE = translationSourceValueExpression;
        this._translationSourceVB = null;
        this._skinFeatures = features;
        this._skinId = null;
    }

    @Deprecated
    public SkinAddition(String styleSheetName, Map<String, String> features) {
        this._styleSheetName = styleSheetName;
        this._resourceBundleName = null;
        this._translationSourceVE = null;
        this._translationSourceVB = null;
        this._skinFeatures = features;
        this._skinId = null;
    }

    @Deprecated
    public SkinAddition(Map<String, String> features) {
        this._styleSheetName = null;
        this._resourceBundleName = null;
        this._translationSourceVE = null;
        this._translationSourceVB = null;
        this._skinFeatures = features;
        this._skinId = null;
    }

    @Deprecated
    public SkinAddition(String styleSheetName, ValueBinding translationSourceValueBinding) {
        this._styleSheetName = styleSheetName;
        this._resourceBundleName = null;
        this._translationSourceVE = null;
        this._translationSourceVB = translationSourceValueBinding;
        this._skinFeatures = null;
        this._skinId = null;
    }

    public String getSkinId() {
        return this._skinId;
    }

    public String getStyleSheetName() {
        return this._styleSheetName;
    }

    public String getResourceBundleName() {
        return this._resourceBundleName;
    }

    public String toString() {
        ToStringHelper helper = new ToStringHelper(this).append("styleSheetName", this.getStyleSheetName()).append("bundleName", this.getResourceBundleName());
        if (this._translationSourceVE != null) {
            helper.append("translationExpr", this._translationSourceVE.getExpressionString());
        }
        if (this._translationSourceVB != null) {
            helper.append("translationBindingExpr", this._translationSourceVB.getExpressionString());
        }
        return helper.toString();
    }

    public ValueExpression getTranslationSourceValueExpression() {
        return this._translationSourceVE;
    }

    @Deprecated
    public ValueBinding getTranslationSourceValueBinding() {
        return this._translationSourceVB;
    }

    public Map<String, String> getSkinFeatures() {
        return this._skinFeatures;
    }

    public int compareTo(Object t) {
        String comparedName = ((SkinAddition)t).getStyleSheetName();
        String thisName = this.getStyleSheetName();
        if (null == thisName) {
            if (null == comparedName) {
                return 0;
            }
            return -1;
        }
        if (null == comparedName) {
            return 1;
        }
        int result = thisName.compareTo(comparedName);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SkinAddition addition = (SkinAddition)o;
        if (this._resourceBundleName != null ? !this._resourceBundleName.equals(addition._resourceBundleName) : addition._resourceBundleName != null) {
            return false;
        }
        if (this._skinFeatures != null ? !this._skinFeatures.equals(addition._skinFeatures) : addition._skinFeatures != null) {
            return false;
        }
        if (this._skinId != null ? !this._skinId.equals(addition._skinId) : addition._skinId != null) {
            return false;
        }
        if (this._styleSheetName != null ? !this._styleSheetName.equals(addition._styleSheetName) : addition._styleSheetName != null) {
            return false;
        }
        return !(this._translationSourceVE != null ? !this._translationSourceVE.equals((Object)addition._translationSourceVE) : addition._translationSourceVE != null);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (null == this._styleSheetName ? 0 : this._styleSheetName.hashCode());
        result = 37 * result + (null == this._skinId ? 0 : this._skinId.hashCode());
        result = 37 * result + (null == this._resourceBundleName ? 0 : this._resourceBundleName.hashCode());
        result = 37 * result + (null == this._translationSourceVE ? 0 : this._translationSourceVE.hashCode());
        result = 37 * result + (null == this._skinFeatures ? 0 : this._skinFeatures.hashCode());
        return result;
    }

    private SkinAddition(Builder builder) {
        this._skinId = builder._skinId;
        this._styleSheetName = builder._styleSheetName;
        this._resourceBundleName = builder._resourceBundleName;
        this._translationSourceVE = builder._translationSource;
        this._skinFeatures = builder._skinFeatures.getFeatures();
        this._translationSourceVB = null;
    }

    public static class Builder {
        private String _styleSheetName;
        private String _skinId;
        private String _resourceBundleName;
        private ValueExpression _translationSource;
        private SkinFeatures _skinFeatures = new SkinFeatures();

        public Builder skinId(String skinId) {
            this._skinId = skinId;
            return this;
        }

        public Builder styleSheetName(String styleSheetName) {
            this._styleSheetName = styleSheetName;
            return this;
        }

        public Builder resourceBundleName(String resourceBundleName) {
            this._resourceBundleName = resourceBundleName;
            return this;
        }

        public Builder translationSource(ValueExpression translationSource) {
            this._translationSource = translationSource;
            return this;
        }

        public Builder features(SkinFeatures skinFeatures) {
            if (skinFeatures != null) {
                this._skinFeatures = skinFeatures;
            }
            return this;
        }

        public SkinAddition build() {
            return new SkinAddition(this);
        }
    }
}

