// WARNING: This file was automatically generated. Do not edit it directly,
//          or you will lose your changes.

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
*/
package org.apache.myfaces.trinidad.component;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitContextWrapper;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.event.DisclosureEvent;

/**
 *
 * showOne is the base abstraction for components that contains
 * a group of showDetails, but displays one of them.
 *
 * <h4>Events:</h4>
 * <table border="1" width="100%" cellpadding="3" summary="">
 * <tr bgcolor="#CCCCFF" class="TableHeadingColor">
 * <th align="left">Type</th>
 * <th align="left">Phases</th>
 * <th align="left">Description</th>
 * </tr>
 * <tr class="TableRowColor">
 * <td valign="top"><code>org.apache.myfaces.trinidad.event.AttributeChangeEvent</code></td>
 * <td valign="top" nowrap>Invoke<br>Application<br>Apply<br>Request<br>Values</td>
 * <td valign="top">Event delivered to describe an attribute change.  Attribute change events are not delivered for any programmatic change to a property.  They are only delivered when a renderer changes a property without the application's specific request.  An example of an attribute change event might include the width of a column that supported client-side resizing.</td>
 * </tr>
 * </table>
 */
public class UIXShowOne extends UIXComponentBase
{
  static public final FacesBean.Type TYPE = new FacesBean.Type(
    UIXComponentBase.TYPE);

  static public final String COMPONENT_FAMILY =
    "org.apache.myfaces.trinidad.ShowOne";
  static public final String COMPONENT_TYPE =
    "org.apache.myfaces.trinidad.ShowOne";

  /**
   * Construct an instance of the UIXShowOne.
   */
  public UIXShowOne()
  {
    super("org.apache.myfaces.trinidad.Tab");
  }
  
  @Override
  @SuppressWarnings("unchecked")
  public void queueEvent(FacesEvent e)
  {
    // Care only if it is a DisclosureEvent, and only if its source is one of
    // its immediate children, for... one could bubble up from one of its grand
    // children that could be a ShowDetail.
    FacesEvent unwrappedEvent = e;
    while (unwrappedEvent instanceof WrapperEvent) // e.g. DisclosureEvent in a tr:iterator
    {
      unwrappedEvent = ((WrapperEvent)unwrappedEvent).getEvent();
    }

    if (unwrappedEvent instanceof DisclosureEvent)
    {
      UIComponent parent = unwrappedEvent.getComponent().getParent();
      while (parent != null && parent instanceof FlattenedComponent)
      {
        parent = parent.getParent();
      }

      if (this == parent)
      {
        // Care only if the incoming event was from the to-be-disclosed showDetailItem.
        DisclosureEvent disclosureEvent = (DisclosureEvent)unwrappedEvent;
        if (disclosureEvent.isExpanded())
        {
          FacesContext context = FacesContext.getCurrentInstance();
          String disclosedClientId = disclosureEvent.getComponent().getClientId(context);

          // Visit all of the flattened children:
          try
          {
            UIXComponent.processFlattenedChildren(
              context,
              _undisclosureCallback,
              getChildren(),
              new UndisclosureCallbackState(e, disclosedClientId));
          }
          catch (IOException ioe)
          {
            // This exception is not expected since no IO is used in this visitor's implementation.
            ioe.printStackTrace();
          }
        }
      }
    }
    super.queueEvent(e);
  }

  @Override
  public boolean visitTree(
    VisitContext  visitContext,
    VisitCallback callback)
  {
    if (visitContext.getHints().contains(VisitHint.SKIP_UNRENDERED))
    {
      // Filter which children to be visited so that only one show detail
      // is visited for this show one component
      visitContext = new PartialVisitContext(visitContext);
    }
    return super.visitTree(visitContext, callback);
  }

  protected boolean isChildSelected(
    UIXShowDetail component)
  {
    return component.isDisclosed();
  }

  /**
   * State passed to the UndisclosureCallback.
   */
  private static class UndisclosureCallbackState
  {
    public UndisclosureCallbackState(
      FacesEvent facesEvent,
      String     clientIdBeingDisclosed)
    {
      this.facesEvent = facesEvent;
      this.clientIdBeingDisclosed = clientIdBeingDisclosed;
    }

    protected final FacesEvent facesEvent;
    protected final String clientIdBeingDisclosed;
  }

  /**
   * Visitor for each flattened child, using the information in the UndisclosureCallbackState.
   */
  private class UndisclosureCallback implements ComponentProcessor<UndisclosureCallbackState>
  {
    public void processComponent(
      FacesContext               facesContext,
      ComponentProcessingContext processContext,
      UIComponent                child,
      UndisclosureCallbackState  callbackState)
      throws IOException
    {
      String clientIdBeingDisclosed = callbackState.clientIdBeingDisclosed;

      // Search for the other item(s) to undisclose (make sure to skip the clientIdBeingDisclosed):
      String childClientId = child.getClientId(facesContext);
      if (!clientIdBeingDisclosed.equals(childClientId))
      {
        UIXShowDetail toBeUnDisclosedChild = (UIXShowDetail)child;
        if (toBeUnDisclosedChild.isDisclosed())
        {
          // Override the phaseId that would be already set on this event
          // (coming off of the to-be-disclosed showDetailItem), because the
          // phase-id should actually be determined by the 'immediate' attribute
          // on the to-be-undisclosed showDetailItem
          if (toBeUnDisclosedChild.isImmediate())
          {
            callbackState.facesEvent.setPhaseId(PhaseId.ANY_PHASE);
          }
          else
          {
            callbackState.facesEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
          }

          // Now queue the event for the to-be-undisclosed showDetailItem
          // Note that this is always delivered earlier than the one that is
          // already queued for to-be-disclosed showDetailItem.
          (new DisclosureEvent(toBeUnDisclosedChild, false)).queue();
        }
      }
    }
  }

  private class PartialVisitContext
    extends VisitContextWrapper
  {
    PartialVisitContext(VisitContext wrapped)
    {
      _wrapped = wrapped;
    }

    public VisitContext getWrapped()
    {
      return _wrapped;
    }

    @Override
    public VisitResult invokeVisitCallback(
      UIComponent   component,
      VisitCallback visitCallback)
    {
      if (component instanceof UIXShowDetail)
      {
        UIXShowDetail showDetail = (UIXShowDetail)component;
        if (_isShowDetailForCurrentComponent(showDetail))
        {
          if (_foundItemToRender || !isChildSelected(showDetail))
          {
            // We already visited the one to be shown
            return VisitResult.REJECT;
          }
          else
          {
            _foundItemToRender = true;
          }
        }
      }

      return super.invokeVisitCallback(component, visitCallback);
    }

    private boolean _isShowDetailForCurrentComponent(
      UIXShowDetail showDetail)
    {
      for (UIComponent parent = showDetail.getParent(); parent != null; parent = parent.getParent())
      {
        if (parent == UIXShowOne.this)
        {
          return true;
        }

        if (parent instanceof FlattenedComponent &&
          ((FlattenedComponent)parent).isFlatteningChildren(getFacesContext()))
        {
          continue;
        }

        // The first-non flattened component is not the show one, do not filter it
        return false;
      }

      return false;
    }

    private boolean      _foundItemToRender;
    private VisitContext _wrapped;
  }

  private final UndisclosureCallback _undisclosureCallback = new UndisclosureCallback();

  @Override
  public String getFamily()
  {
    return COMPONENT_FAMILY;
  }

  @Override
  protected FacesBean.Type getBeanType()
  {
    return TYPE;
  }

  /**
   * Construct an instance of the UIXShowOne.
   */
  protected UIXShowOne(
    String rendererType
    )
  {
    super(rendererType);
  }

  static
  {
    TYPE.lockAndRegister("org.apache.myfaces.trinidad.ShowOne","org.apache.myfaces.trinidad.Tab");
  }
}
