/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.commons.resourcehandler.webapp.config.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.faces.webapp.FacesServlet;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;

import org.apache.myfaces.commons.resourcehandler.webapp.config.WebRegistration;
import org.apache.myfaces.commons.resourcehandler.webapp.config.element.impl.FilterRegistrationWrapper;
import org.apache.myfaces.commons.resourcehandler.webapp.config.element.impl.ServletRegistrationWrapper;

/**
 * 
 * @author Leonardo Uribe
 *
 */
final class _Servlet30Utils
{
    
    public static WebRegistration getWebRegistrationFromServlet30Api(ServletContext servletContext)
    {
        WebRegistrationImpl provider = new WebRegistrationImpl();
        Map<String, ? extends ServletRegistration> servletRegistrations = servletContext.getServletRegistrations();
        Map<String, ? extends FilterRegistration> filterRegistrations = servletContext.getFilterRegistrations();
        if (servletRegistrations != null &&  !servletRegistrations.isEmpty())
        {
            for (Map.Entry<String, ? extends ServletRegistration> entry : servletRegistrations.entrySet())
            {
                provider.getServletRegistrations().put(entry.getKey(), 
                        (org.apache.myfaces.commons.resourcehandler.webapp.config.element.ServletRegistration)
                        new ServletRegistrationWrapper(entry.getValue()));
            }
        }
        if (filterRegistrations != null && !filterRegistrations.isEmpty())
        {
            for (Map.Entry<String, ? extends FilterRegistration> entry : filterRegistrations.entrySet())
            {
                provider.getFilterRegistrations().put(entry.getKey(), new FilterRegistrationWrapper(entry.getValue()));
            }
        }
        return provider;
    }

    public static String[] getFacesServletPrefixMappings(ServletContext servletContext)
    {
       Map<String, ? extends ServletRegistration> registrations = servletContext.getServletRegistrations(); 
       List<String> prefixMappings = null;
       if (registrations != null)
       {
           for (Map.Entry<String, ? extends ServletRegistration> entry : registrations.entrySet())
           {
               ServletRegistration registration = entry.getValue();
               
               if (FacesServlet.class.getName().equals(registration.getClassName()))
               {
                   for (String urlPattern :entry.getValue().getMappings())
                   {
                       //look for prefix mapping
                       String prefix;
                       String extension = urlPattern != null && urlPattern.startsWith("*.") ? urlPattern.substring(urlPattern
                               .indexOf('.')) : null;
                       if (extension == null)
                       {
                           int index = urlPattern.indexOf("/*");
                           if (index != -1)
                           {
                               prefix = urlPattern.substring(0, urlPattern.indexOf("/*"));
                           }
                           else
                           {
                               prefix = urlPattern;
                           }
                       }
                       else
                       {
                           prefix = null;
                       }
                       
                       if (prefix != null)
                       {
                           if (prefixMappings == null)
                           {
                               prefixMappings = new ArrayList<String>();
                           }
                           prefixMappings.add(prefix);
                       }
                   }
               }
           }
       }
       return prefixMappings == null ? new String[]{} : prefixMappings.toArray(new String[prefixMappings.size()]); 
    }

}
