"use strict";
/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const mocha_1 = require("mocha");
const chai_1 = require("chai");
const StandardInits_1 = require("../frameworkBase/_ext/shared/StandardInits");
var defaultMyFaces = StandardInits_1.StandardInits.defaultMyFaces;
/**
 * Adds test s for the newly introduced onload handling
 */
(0, mocha_1.describe)('Tests on the xhr core when it starts to call the request', function () {
    beforeEach(() => __awaiter(this, void 0, void 0, function* () {
        return;
    }));
    (0, mocha_1.it)("must be present", function () {
        return __awaiter(this, void 0, void 0, function* () {
            yield defaultMyFaces();
            (0, chai_1.expect)(myfaces === null || myfaces === void 0 ? void 0 : myfaces.onDomReady).to.exist;
            return true;
        });
    });
    (0, mocha_1.it)("must be called on onDocumentReady", function (done) {
        return __awaiter(this, void 0, void 0, function* () {
            let called = false;
            const onDomCalled = () => {
                (0, chai_1.expect)(true).to.true;
                done();
            };
            myfaces === null || myfaces === void 0 ? void 0 : myfaces.onDomReady(onDomCalled);
            yield defaultMyFaces();
        });
    });
});
//# sourceMappingURL=OnLoadSpec.js.map