import { Config } from "mona-dish";
import { EventData } from "./EventData";
export declare enum ErrorType {
    SERVER_ERROR = "serverError",
    HTTP_ERROR = "httpError",
    CLIENT_ERROR = "clientErrror",
    TIMEOUT = "timeout"
}
/**
 * the spec has a problem of having the error
 * object somewhat underspecified, there is no clear
 * description of the required contents.
 * I want to streamline it with mojarra here
 * hence we are going to move
 * everything into the same attributes,
 * I will add deprecated myfaces backwards compatibility attributes as well
 */
export declare class ErrorData extends EventData implements IErrorData {
    type: string;
    source: HTMLElement;
    sourceId: string;
    errorName: string;
    errorMessage: string;
    responseText: string;
    responseXML: any;
    status: string;
    typeDetails: ErrorType;
    serverErrorName: string;
    serverErrorMessage: string;
    message: string;
    constructor(source: string, errorName: string, errorMessage: string, responseText?: string, responseXML?: any, responseCode?: string, status?: string, type?: ErrorType);
    static fromClient(e: Error): ErrorData;
    static fromHttpConnection(source: any, name: string, message: string, responseText: any, responseCode: number, status?: string): ErrorData;
    static fromGeneric(context: Config, errorCode: number, errorType?: ErrorType): ErrorData;
    private static getMsg;
    static fromServerError(context: Config): ErrorData;
}
