/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * we need a probe to test our asynchronous behavior
 * the asynchronous behavior needs to be in an asynchronous runnable
 */
import { IAsyncRunnable } from "../../impl/util/AsyncRunnable";
import { IValueHolder } from "mona-dish";
export declare class ProbeClass implements IAsyncRunnable<Promise<any>>, IValueHolder<Promise<any>> {
    private $timeout;
    private resolveIt;
    value: Promise<any>;
    fCatch: (data: any) => any;
    fThen: (data: any) => any;
    fFinally: () => any;
    thenPerformed: boolean;
    catchPerformed: boolean;
    finallyPerformed: boolean;
    constructor($timeout: Function, resolveIt?: boolean);
    catch(func: (data: any) => any): IAsyncRunnable<boolean>;
    finally(func: () => void): IAsyncRunnable<boolean>;
    start(): void;
    cancel(): void;
    then(func: (data: any) => any): IAsyncRunnable<boolean>;
}
