"use strict";
/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const mocha_1 = require("mocha");
const StandardInits_1 = require("../frameworkBase/_ext/shared/StandardInits");
const sinon = __importStar(require("sinon"));
const XmlResponses_1 = require("../frameworkBase/_ext/shared/XmlResponses");
const chai_1 = require("chai");
const mona_dish_1 = require("mona-dish");
var shadowDomMyFaces = StandardInits_1.StandardInits.shadowDomMyFaces;
sinon.reset();
(0, mocha_1.describe)('shadow dom testsuite', () => {
    beforeEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            let waitForResult = shadowDomMyFaces();
            return waitForResult.then((close) => {
                this.xhr = sinon.useFakeXMLHttpRequest();
                this.requests = [];
                this.respond = (response) => {
                    let xhrReq = this.requests.shift();
                    xhrReq.responsetype = "text/xml";
                    xhrReq.respond(200, { 'Content-Type': 'text/xml' }, response);
                    return xhrReq;
                };
                this.xhr.onCreate = (xhr) => {
                    this.requests.push(xhr);
                };
                global.XMLHttpRequest = this.xhr;
                window.XMLHttpRequest = this.xhr;
                this.closeIt = () => {
                    global.XMLHttpRequest = window.XMLHttpRequest = this.xhr.restore();
                    Implementation.reset();
                    close();
                };
            });
        });
    });
    afterEach(function () {
        this.closeIt();
    });
    it("shadow dom behavior tested", function () {
        //const addRequestToQueue = sinon.stub(Impl.queueHandler, "addRequestToQueue");
        (0, chai_1.expect)(mona_dish_1.DomQuery.querySelectorAll("#shadowDomArea").length).to.eq(1);
        (0, chai_1.expect)(mona_dish_1.DomQuery.querySelectorAll("* /shadow/ #shadowContent").length).to.eq(1);
        mona_dish_1.DomQuery.byId("blarg:input_1", true).addEventListener("click", (event) => {
            window.faces.ajax.request(event.target, event, { render: 'shadowContent', execute: '@this' });
        }).click();
        this.respond(XmlResponses_1.XmlResponses.SHADOW_DOM_UPDATE);
        //check if element is updated
        (0, chai_1.expect)(mona_dish_1.DomQuery.byId("shadowContent", true).innerHtml).to.eq("after update");
        /*shadow dom in place now lets do an update on the element*/
    });
    it("shadow dom updated triggered from outside", function () {
        //const addRequestToQueue = sinon.stub(Impl.queueHandler, "addRequestToQueue");
        (0, chai_1.expect)(mona_dish_1.DomQuery.querySelectorAll("#shadowDomArea").length).to.eq(1);
        (0, chai_1.expect)(mona_dish_1.DomQuery.querySelectorAll("* /shadow/ #shadowContent").length).to.eq(1);
        mona_dish_1.DomQuery.byId("input_3", true).addEventListener("click", (event) => {
            window.faces.ajax.request(event.target, event, { render: 'shadowContent', execute: '@this' });
        }).click();
        this.respond(XmlResponses_1.XmlResponses.SHADOW_DOM_UPDATE);
        //check if element is updated
        (0, chai_1.expect)(mona_dish_1.DomQuery.byId("shadowContent", true).innerHtml).to.eq("after update");
        /*shadow dom in place now lets do an update on the element*/
    });
});
//# sourceMappingURL=ShadowDomTest.spec.js.map