/*!
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * various helpers to deal with associative
 * arrays. If someone feels uncomfortable using
 * The config system, this is similar!
 */
import { IValueHolder } from "./Monad";
/**
 * uses the known pattern from config
 * assign(target, key1, key2, key3).value = value;
 * @param target
 * @param keys
 */
export declare function assign<T>(target: {
    [key: string]: any;
}, ...accessPath: string[]): IValueHolder<T>;
export declare function append<T>(target: {
    [key: string]: any;
}, ...accessPath: string[]): IValueHolder<T>;
/**
 * uses the known pattern from config
 * assign(target, key1, key2, key3).value = value;
 * @param target
 * @param keys
 */
export declare function assignIf<T>(condition: boolean, target: {
    [key: string]: any;
}, ...accessPath: string[]): IValueHolder<T>;
/**
 * uses the known pattern from config
 * assign(target, key1, key2, key3).value = value;
 * @param target
 * @param keys
 */
export declare function appendIf<T>(condition: boolean, target: {
    [key: string]: any;
}, ...accessPath: string[]): IValueHolder<T>;
export declare function resolve<T>(target: any, ...accessPath: string[]): T | null;
/**
 * builds up a path, only done if no data is present!
 * @param target
 * @param accessPath
 * @returns the last assignable entry
 */
export declare function buildPath(target: any, ...accessPath: string[]): {
    target: any;
    key: any;
};
export declare function deepCopy(fromAssoc: {
    [key: string]: any;
}): {
    [key: string]: any;
};
/**
 * simple left to right merge
 *
 * @param assocArrays
 */
export declare function simpleShallowMerge(...assocArrays: any[]): {
    [key: string]: any;
};
/**
 * Shallow merge as in config, but on raw associative arrays
 *
 * @param overwrite overwrite existing keys, if they exist with their subtrees
 * @param withAppend if a key exist append the values or drop them
 * Combination overwrite withappend filters doubles out of merged arrays
 * @param assocArrays array of assoc arres reduced right to left
 */
export declare function shallowMerge(overwrite?: boolean, withAppend?: boolean, ...assocArrays: any[]): {
    [key: string]: any;
};
export declare function deepEqual(obj1: any, obj2: any): any;
