/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.extensions.cdi.core.api.config;

import java.io.Serializable;

/**
 * This interface is just for internal use.
 * It should ensure that refactorings don't lead to different method-names for the same purpose.
 * Furthermore, it allows to easily find all artifacts which allow generic attributes.
 */
public interface AttributeAware extends Serializable
{
    /**
     * Sets an attribute
     * @param name name of the attribute
     * @param value value of the attribute (null values aren't allowed)
     * @return true if it was possible to set the value
     */
    boolean setAttribute(String name, Object value);

    /**
     * Sets or updates an attribute
     * @param name name of the attribute
     * @param value value of the attribute
     * @param forceOverride flag which indicates if it is permitted to override an existing value
     * @return true if it was possible to set the value
     */
    boolean setAttribute(String name, Object value, boolean forceOverride);

    /**
     * Returns true if there is a value for the given name
     * @param name name of the argument in question
     * @return true if there is a value for the given name, false otherwise
     */
    boolean containsAttribute(String name);

    /**
     * Exposes the value for the given name
     * @param name name of the attribute
     * @param targetType type of the attribute
     * @param <T> current type
     * @return value of the attribute, or null if there is no attribute with the given name
     */
    <T> T getAttribute(String name, Class<T> targetType);
}
