/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.portlet.faces.util.config;

import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesConfigurationProcessor {
    private static final String FACES_CONFIG_METAINF_PATH = "META-INF/faces-config.xml";
    private static final String FACES_CONFIG_WEBINF_PATH = "/WEB-INF/faces-config.xml";
    private List<String> mExcludedAttributes = null;
    private Map<String, String> mPublicParameterMappings = null;
    private String mWriteBehindRenderResponseWrapper = null;
    private String mWriteBehindResourceResponseWrapper = null;

    public FacesConfigurationProcessor(PortletContext context) {
        if (context != null) {
            this.scanForFacesMappings(context);
        }
    }

    public List<String> getExcludedAttributes() {
        return this.mExcludedAttributes;
    }

    public Map<String, String> getPublicParameterMappings() {
        return this.mPublicParameterMappings;
    }

    public String getWriteBehindRenderResponseWrapperClassName() {
        return this.mWriteBehindRenderResponseWrapper;
    }

    public String getWriteBehindResourceResponseWrapperClassName() {
        return this.mWriteBehindResourceResponseWrapper;
    }

    private void scanForFacesMappings(PortletContext context) {
        SAXParserFactory factory = this.getSAXFactory();
        try {
            SAXParser parser = factory.newSAXParser();
            FacesConfigXmlHandler handler = null;
            ClassLoader cl = this.getCurrentClassLoader(context);
            Enumeration<URL> items = cl.getResources(FACES_CONFIG_METAINF_PATH);
            while (items.hasMoreElements()) {
                URL nextElement = items.nextElement();
                if (handler == null) {
                    handler = new FacesConfigXmlHandler();
                } else {
                    handler.reset();
                }
                parser.parse(nextElement.openStream(), (DefaultHandler)handler);
            }
            InputStream configStream = context.getResourceAsStream(FACES_CONFIG_WEBINF_PATH);
            if (configStream != null) {
                parser.parse(configStream, (DefaultHandler)handler);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ClassLoader getCurrentClassLoader(Object fallbackClass) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return loader;
    }

    private SAXParserFactory getSAXFactory() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        return factory;
    }

    private class FacesConfigXmlHandler
    extends DefaultHandler {
        private static final String APPLICATION_ELEMENT = "application";
        private static final String APP_EXTENSION_ELEMENT = "application-extension";
        private static final String EXCLUDED_ATTRIBUTES_ELEMENT = "excluded-attributes";
        private static final String EXCLUDED_ATTRIBUTE_ELEMENT = "excluded-attribute";
        private static final String PUBLIC_PARAMETER_MAPPINGS_ELEMENT = "public-parameter-mappings";
        private static final String PUBLIC_PARAMETER_MAPPING_ELEMENT = "public-parameter-mapping";
        private static final String PARAMETER_ELEMENT = "parameter";
        private static final String MODEL_EL_ELEMENT = "model-el";
        private static final String WRITE_BEHIND_RESPONSE_WRAPPERS_ELEMENT = "write-behind-response-wrappers";
        private static final String RENDER_RESPONSE_WRAPPER_CLASS_ELEMENT = "render-response-wrapper-class";
        private static final String RESOURCE_RESPONSE_WRAPPER_CLASS_ELEMENT = "resource-response-wrapper-class";
        private boolean mInApplicationElement = false;
        private boolean mInApplicationExtensionElement = false;
        private boolean mInExcludedAttributesElement = false;
        private boolean mInPublicParameterMappings = false;
        private boolean mInPublicParameterMapping = false;
        private boolean mInParameter = false;
        private boolean mInModelEL = false;
        private boolean mInWriteBehindResponseWrappers = false;
        private StringBuilder mContent;
        private String mContent1;
        private String mContent2;

        private FacesConfigXmlHandler() {
        }

        public void reset() {
            this.mInModelEL = false;
            this.mInParameter = false;
            this.mInPublicParameterMapping = false;
            this.mInPublicParameterMappings = false;
            this.mInExcludedAttributesElement = false;
            this.mInApplicationExtensionElement = false;
            this.mInApplicationElement = false;
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            return new InputSource(new StringReader(""));
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (APPLICATION_ELEMENT.equals(localName)) {
                this.mInApplicationElement = true;
            } else if (APP_EXTENSION_ELEMENT.equals(localName)) {
                this.mInApplicationExtensionElement = true;
            } else if (EXCLUDED_ATTRIBUTES_ELEMENT.equals(localName)) {
                this.mInExcludedAttributesElement = true;
            } else if (PUBLIC_PARAMETER_MAPPINGS_ELEMENT.equals(localName)) {
                this.mInPublicParameterMappings = true;
            } else if (PUBLIC_PARAMETER_MAPPING_ELEMENT.equals(localName)) {
                this.mInPublicParameterMapping = true;
            } else if (PARAMETER_ELEMENT.equals(localName) || MODEL_EL_ELEMENT.equals(localName)) {
                if (this.mInApplicationElement && this.mInApplicationExtensionElement && this.mInPublicParameterMappings && this.mInPublicParameterMapping) {
                    this.mContent = new StringBuilder();
                }
            } else if (EXCLUDED_ATTRIBUTE_ELEMENT.equals(localName)) {
                if (this.mInApplicationElement && this.mInApplicationExtensionElement && this.mInExcludedAttributesElement) {
                    this.mContent = new StringBuilder();
                }
            } else if (WRITE_BEHIND_RESPONSE_WRAPPERS_ELEMENT.equals(localName)) {
                this.mInWriteBehindResponseWrappers = true;
            } else if ((RENDER_RESPONSE_WRAPPER_CLASS_ELEMENT.equals(localName) || RESOURCE_RESPONSE_WRAPPER_CLASS_ELEMENT.equals(localName)) && this.mInApplicationElement && this.mInApplicationExtensionElement && this.mInWriteBehindResponseWrappers) {
                this.mContent = new StringBuilder();
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.mContent != null) {
                this.mContent.append(ch, start, length);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (APPLICATION_ELEMENT.equals(localName)) {
                this.mInApplicationElement = false;
            } else if (APP_EXTENSION_ELEMENT.equals(localName)) {
                this.mInApplicationExtensionElement = false;
            } else if (EXCLUDED_ATTRIBUTES_ELEMENT.equals(localName)) {
                this.mInExcludedAttributesElement = false;
            } else if (EXCLUDED_ATTRIBUTE_ELEMENT.equals(localName) && this.mContent != null && this.mContent.length() > 0) {
                String excludedAttribute = this.mContent.toString().trim();
                if (FacesConfigurationProcessor.this.mExcludedAttributes == null) {
                    FacesConfigurationProcessor.this.mExcludedAttributes = new ArrayList(5);
                }
                if (!FacesConfigurationProcessor.this.mExcludedAttributes.contains(excludedAttribute)) {
                    FacesConfigurationProcessor.this.mExcludedAttributes.add(excludedAttribute);
                }
            } else if (PUBLIC_PARAMETER_MAPPINGS_ELEMENT.equals(localName)) {
                this.mInPublicParameterMappings = false;
            } else if (PUBLIC_PARAMETER_MAPPING_ELEMENT.equals(localName)) {
                if (this.mContent1 != null && this.mContent2 != null) {
                    if (FacesConfigurationProcessor.this.mPublicParameterMappings == null) {
                        FacesConfigurationProcessor.this.mPublicParameterMappings = new HashMap(5);
                    }
                    if (!FacesConfigurationProcessor.this.mPublicParameterMappings.containsKey(this.mContent1)) {
                        FacesConfigurationProcessor.this.mPublicParameterMappings.put(this.mContent1, this.mContent2);
                    }
                }
                this.mContent2 = null;
                this.mContent1 = null;
                this.mInPublicParameterMapping = false;
            } else if (PARAMETER_ELEMENT.equals(localName) && this.mContent != null && this.mContent.length() > 0) {
                this.mContent1 = this.mContent.toString().trim();
            } else if (MODEL_EL_ELEMENT.equals(localName) && this.mContent != null && this.mContent.length() > 0) {
                this.mContent2 = this.mContent.toString().trim();
            } else if (WRITE_BEHIND_RESPONSE_WRAPPERS_ELEMENT.equals(localName)) {
                this.mInWriteBehindResponseWrappers = false;
            } else if (RENDER_RESPONSE_WRAPPER_CLASS_ELEMENT.equals(localName) && this.mContent != null && this.mContent.length() > 0) {
                FacesConfigurationProcessor.this.mWriteBehindRenderResponseWrapper = this.mContent.toString().trim();
            } else if (RESOURCE_RESPONSE_WRAPPER_CLASS_ELEMENT.equals(localName) && this.mContent != null && this.mContent.length() > 0) {
                FacesConfigurationProcessor.this.mWriteBehindResourceResponseWrapper = this.mContent.toString().trim();
            }
            this.mContent = null;
        }
    }
}

