/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.progress.spi;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.progress.spi.Controller;
import org.netbeans.modules.progress.spi.ExtractedProgressUIWorker;
import org.netbeans.modules.progress.spi.InternalHandle;
import org.netbeans.modules.progress.spi.ProgressUIWorkerProvider;
import org.netbeans.modules.progress.spi.SwingController;
import org.netbeans.progress.module.TrivialProgressUIWorkerProvider;
import org.netbeans.progress.module.UIInternalHandleAccessor;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;

public final class UIInternalHandle
extends InternalHandle {
    private static final Logger LOG = Logger.getLogger(UIInternalHandle.class.getName());
    private ActionListener viewAction;
    private ExtractedProgressUIWorker component;
    private boolean customPlaced1 = false;
    private boolean customPlaced2 = false;
    private boolean customPlaced3 = false;
    private ProgressHandle handle;

    public UIInternalHandle(String displayName, Cancellable cancel, boolean userInitiated, Action view) {
        super(displayName, cancel, userInitiated);
        this.viewAction = view;
    }

    @Override
    public boolean isAllowCancel() {
        return super.isAllowCancel() && !this.isCustomPlaced();
    }

    @Override
    public boolean isAllowView() {
        return this.viewAction != null && !this.isCustomPlaced();
    }

    @Override
    public boolean isCustomPlaced() {
        return this.component != null;
    }

    @Override
    public void requestView() {
        if (!this.isAllowView()) {
            return;
        }
        this.viewAction.actionPerformed(new ActionEvent(this.viewAction, 1001, "performView"));
    }

    @Override
    public boolean requestAction(String actionCommand, Action al) {
        if (actionCommand != "performView") {
            return false;
        }
        this.viewAction = al;
        return true;
    }

    private void createExtractedWorker() {
        if (this.component == null) {
            ProgressUIWorkerProvider prov = Lookup.getDefault().lookup(ProgressUIWorkerProvider.class);
            if (prov == null) {
                LOG.log(Level.CONFIG, "Using fallback trivial progress implementation");
                prov = new TrivialProgressUIWorkerProvider();
            }
            this.component = prov.extractProgressWorker(this);
            this.setController(new SwingController(this.component));
        }
    }

    public synchronized JComponent extractComponent() {
        if (this.customPlaced1) {
            throw new IllegalStateException("Cannot retrieve progress component multiple times");
        }
        if (this.getState() != 0) {
            throw new IllegalStateException("You can request custom placement of progress component only before starting the task");
        }
        this.customPlaced1 = true;
        this.createExtractedWorker();
        return this.component.getProgressComponent();
    }

    public synchronized JLabel extractDetailLabel() {
        if (this.customPlaced2) {
            throw new IllegalStateException("Cannot retrieve progress detail label component multiple times");
        }
        if (this.getState() != 0) {
            throw new IllegalStateException("You can request custom placement of progress component only before starting the task");
        }
        this.customPlaced2 = true;
        this.createExtractedWorker();
        return this.component.getDetailLabelComponent();
    }

    public synchronized JLabel extractMainLabel() {
        if (this.customPlaced3) {
            throw new IllegalStateException("Cannot retrieve progress main label component multiple times");
        }
        if (this.getState() != 0) {
            throw new IllegalStateException("You can request custom placement of progress component only before starting the task");
        }
        this.customPlaced3 = true;
        this.createExtractedWorker();
        return this.component.getMainLabelComponent();
    }

    static {
        UIInternalHandleAccessor.setInstance(new UIInternalHandleAccessor(){

            @Override
            public void setController(InternalHandle h, Controller c) {
                h.setController(c);
            }

            @Override
            public void markCustomPlaced(InternalHandle h) {
                h.markCustomPlaced();
            }
        });
    }
}

