/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.spi.project.libraries.LibraryImplementation3;
import org.openide.util.Parameters;

public final class DefaultLibraryImplementation
implements LibraryImplementation3 {
    private String description;
    private Map<String, List<URL>> contents;
    private String name;
    private String libraryType;
    private String localizingBundle;
    private String displayName;
    private List<PropertyChangeListener> listeners;
    private volatile Map<String, String> properties = Collections.emptyMap();

    public DefaultLibraryImplementation(@NonNull String libraryType, @NonNull String[] volumeTypes) {
        Parameters.notNull("libraryType", libraryType);
        Parameters.notNull("volumeTypes", volumeTypes);
        this.libraryType = libraryType;
        this.contents = new HashMap<String, List<URL>>();
        for (String vtype : volumeTypes) {
            Parameters.notNull("volumeTypes", vtype);
            this.contents.put(vtype, Collections.emptyList());
        }
    }

    @Override
    public String getType() {
        return this.libraryType;
    }

    @Override
    public void setName(String name) throws UnsupportedOperationException {
        String oldName = this.name;
        this.name = name;
        this.firePropertyChange("name", oldName, this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<URL> getContent(String contentType) throws IllegalArgumentException {
        List<URL> content = this.contents.get(contentType);
        if (content == null) {
            throw new IllegalArgumentException(MessageFormat.format("Volume: {0} is not support by this library. The only acceptable values are: {1}", contentType, this.contents.keySet()));
        }
        return Collections.unmodifiableList(content);
    }

    @Override
    public void setContent(String contentType, List<URL> path) throws IllegalArgumentException {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        if (!this.contents.keySet().contains(contentType)) {
            throw new IllegalArgumentException(MessageFormat.format("Volume: {0} is not support by this library. The only acceptable values are: {1}", contentType, this.contents.keySet()));
        }
        this.contents.put(contentType, new ArrayList<URL>(path));
        this.firePropertyChange("content", null, null);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String text) {
        String oldDesc = this.description;
        this.description = text;
        this.firePropertyChange("description", oldDesc, this.description);
    }

    @Override
    public String getLocalizingBundle() {
        return this.localizingBundle;
    }

    @Override
    public void setLocalizingBundle(String resourceName) {
        this.localizingBundle = resourceName;
    }

    @Override
    @CheckForNull
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(@NullAllowed String displayName) {
        String oldDisplayName = this.displayName;
        this.displayName = displayName;
        this.firePropertyChange("displayName", oldDisplayName, this.displayName);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<PropertyChangeListener>();
        }
        this.listeners.add(l);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    public String toString() {
        return "DefaultLibraryImplementation[" + this.name + "]";
    }

    public boolean equals(Object other) {
        if (other instanceof DefaultLibraryImplementation) {
            DefaultLibraryImplementation otherLib = (DefaultLibraryImplementation)other;
            return (this.name == null ? otherLib.name == null : this.name.equals(otherLib.name)) && (this.libraryType == null ? otherLib.libraryType == null : this.libraryType.equals(otherLib.libraryType));
        }
        return false;
    }

    public int hashCode() {
        int hash = 31;
        hash = hash * 17 + (this.name == null ? 0 : this.name.hashCode());
        hash = hash * 17 + (this.libraryType == null ? 0 : this.libraryType.hashCode());
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChange(String propName, Object oldValue, Object newValue) {
        ArrayList<PropertyChangeListener> ls;
        DefaultLibraryImplementation defaultLibraryImplementation = this;
        synchronized (defaultLibraryImplementation) {
            if (this.listeners == null) {
                return;
            }
            ls = new ArrayList<PropertyChangeListener>(this.listeners);
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, propName, oldValue, newValue);
        for (PropertyChangeListener l : ls) {
            l.propertyChange(event);
        }
    }

    @Override
    @NonNull
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(@NonNull Map<String, String> props) {
        Parameters.notNull("props", props);
        Map<String, String> oldProps = this.properties;
        this.properties = new HashMap<String, String>(props);
        this.firePropertyChange("properties", oldProps, this.properties);
    }
}

