/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.jumpto.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.parsing.lucene.support.Queries;
import org.netbeans.spi.jumpto.support.NameMatcher;
import org.netbeans.spi.jumpto.type.SearchType;
import org.openide.util.Parameters;

public final class NameMatcherFactory {
    private static final Map<Character, String> RE_SPECIALS;

    private NameMatcherFactory() {
    }

    @NonNull
    public static NameMatcher createNameMatcher(@NonNull String text, @NonNull SearchType type) throws IllegalArgumentException {
        return NameMatcherFactory.createNameMatcher(text, type, Collections.emptyMap());
    }

    @NonNull
    public static NameMatcher createNameMatcher(@NonNull String text, @NonNull SearchType type, @NonNull Map<String, Object> options) throws IllegalArgumentException {
        Parameters.notNull("text", text);
        Parameters.notNull("type", (Object)type);
        Parameters.notNull("options", options);
        try {
            switch (type) {
                case EXACT_NAME: {
                    return new ExactNameMatcher(text);
                }
                case CASE_INSENSITIVE_EXACT_NAME: {
                    return new CaseInsensitiveExactNameMatcher(text);
                }
                case PREFIX: {
                    return new PrefixNameMatcher(text);
                }
                case REGEXP: {
                    return new RegExpNameMatcher(NameMatcherFactory.wildcardsToRegexp(text, true), true);
                }
                case CASE_INSENSITIVE_REGEXP: {
                    return new RegExpNameMatcher(NameMatcherFactory.wildcardsToRegexp(text, true), false);
                }
                case CASE_INSENSITIVE_PREFIX: {
                    return new CaseInsensitivePrefixNameMatcher(text);
                }
                case CAMEL_CASE: {
                    return new CamelCaseNameMatcher(text, true, options);
                }
                case CASE_INSENSITIVE_CAMEL_CASE: {
                    return new CamelCaseNameMatcher(text, false, options);
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)type));
        }
        catch (PatternSyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static String wildcardsToRegexp(String pattern, boolean prefix) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            String r = RE_SPECIALS.get(Character.valueOf(c));
            if (r != null) {
                res.append(r);
                continue;
            }
            res.append(c);
        }
        if (prefix) {
            res.append(".*");
        }
        return res.toString();
    }

    @CheckForNull
    private static <T> T getOption(@NonNull Map<String, Object> options, @NonNull String key, @NonNull Class<T> clz) {
        Object val = options.get(key);
        return clz.isInstance(val) ? (T)clz.cast(val) : null;
    }

    static {
        HashMap<Character, String> m = new HashMap<Character, String>();
        m.put(Character.valueOf('{'), "\\{");
        m.put(Character.valueOf('}'), "\\}");
        m.put(Character.valueOf('['), "\\[");
        m.put(Character.valueOf(']'), "\\]");
        m.put(Character.valueOf('('), "\\(");
        m.put(Character.valueOf(')'), "\\)");
        m.put(Character.valueOf('\\'), "\\\\");
        m.put(Character.valueOf('.'), "\\.");
        m.put(Character.valueOf('+'), "\\+");
        m.put(Character.valueOf('*'), ".*");
        m.put(Character.valueOf('?'), ".");
        RE_SPECIALS = Collections.unmodifiableMap(m);
    }

    private static final class CamelCaseNameMatcher
    implements NameMatcher {
        private final Pattern pattern;

        public CamelCaseNameMatcher(@NonNull String name, boolean caseSensitive, @NonNull Map<String, Object> options) {
            if (name.length() == 0) {
                throw new IllegalArgumentException();
            }
            this.pattern = Pattern.compile(Queries.createCamelCaseRegExp(name, (String)NameMatcherFactory.getOption(options, "camelCaseSeparator", String.class), (String)NameMatcherFactory.getOption(options, "camelCasePart", String.class), caseSensitive), caseSensitive ? 0 : 2);
        }

        @Override
        public final boolean accept(String name) {
            return name != null && this.pattern.matcher(name).matches();
        }
    }

    private static final class RegExpNameMatcher
    implements NameMatcher {
        private final Pattern pattern;

        public RegExpNameMatcher(String patternText, boolean caseSensitive) {
            this.pattern = Pattern.compile(patternText, caseSensitive ? 0 : 2);
        }

        @Override
        public final boolean accept(String name) {
            return name != null && this.pattern.matcher(name).matches();
        }
    }

    private static final class CaseInsensitivePrefixNameMatcher
    extends BaseNameMatcher {
        public CaseInsensitivePrefixNameMatcher(String patternText) {
            super(patternText.toLowerCase());
        }

        @Override
        public final boolean accept(String name) {
            return name != null && name.toLowerCase().startsWith(this.patternText);
        }
    }

    private static final class PrefixNameMatcher
    extends BaseNameMatcher {
        public PrefixNameMatcher(String patternText) {
            super(patternText);
        }

        @Override
        public final boolean accept(String name) {
            return name != null && name.startsWith(this.patternText);
        }
    }

    private static final class CaseInsensitiveExactNameMatcher
    extends BaseNameMatcher {
        public CaseInsensitiveExactNameMatcher(String patternText) {
            super(patternText);
        }

        @Override
        public final boolean accept(String name) {
            return this.patternText.equalsIgnoreCase(name);
        }
    }

    private static final class ExactNameMatcher
    extends BaseNameMatcher {
        public ExactNameMatcher(String patternText) {
            super(patternText);
        }

        @Override
        public final boolean accept(String name) {
            return this.patternText.equals(name);
        }
    }

    private static abstract class BaseNameMatcher
    implements NameMatcher {
        protected final String patternText;

        protected BaseNameMatcher(String patternText) {
            this.patternText = patternText;
        }
    }
}

