/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parameter;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.nifi.parameter.AbstractParameterParser;
import org.apache.nifi.parameter.ParameterToken;
import org.apache.nifi.parameter.ParameterTokenList;
import org.apache.nifi.parameter.StandardParameterTokenList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionLanguageAgnosticParameterParser
extends AbstractParameterParser {
    private static final Logger logger = LoggerFactory.getLogger(ExpressionLanguageAgnosticParameterParser.class);

    @Override
    public ParameterTokenList parseTokens(String input) {
        if (input == null || input.isEmpty()) {
            return new StandardParameterTokenList(input, Collections.emptyList());
        }
        ArrayList<ParameterToken> references = new ArrayList<ParameterToken>();
        int sequentialStartTags = 0;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '#': {
                    ++sequentialStartTags;
                    break;
                }
                case '{': {
                    ParameterToken token;
                    if (sequentialStartTags <= 0 || (token = this.parseParameterToken(input, i, sequentialStartTags, references)) == null) break;
                    i = token.getEndOffset();
                    break;
                }
            }
            if (c == '#') continue;
            sequentialStartTags = 0;
        }
        return new StandardParameterTokenList(input, references);
    }
}

