/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.provenance.StandardQueryResult;
import org.apache.nifi.provenance.search.Query;
import org.apache.nifi.provenance.search.QuerySubmission;

public class AsyncQuerySubmission
implements QuerySubmission {
    public static final int TTL = (int)TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS);
    private final Date submissionTime = new Date();
    private final Query query;
    private volatile boolean canceled = false;
    private final StandardQueryResult queryResult;
    private final String submitterId;
    private final List<Future<?>> queryExecutions = new ArrayList();

    public AsyncQuerySubmission(Query query, int numSteps, String submitterId) {
        this.query = query;
        this.submitterId = submitterId;
        this.queryResult = new StandardQueryResult(query, numSteps);
    }

    public String getSubmitterIdentity() {
        return this.submitterId;
    }

    public Date getSubmissionTime() {
        return this.submissionTime;
    }

    public String getQueryIdentifier() {
        return this.query.getIdentifier();
    }

    public void cancel() {
        this.canceled = true;
        for (Future<?> queryExecution : this.queryExecutions) {
            queryExecution.cancel(true);
        }
        this.queryResult.cancel();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public Query getQuery() {
        return this.query;
    }

    public StandardQueryResult getResult() {
        return this.queryResult;
    }

    public void addQueryExecution(Future<?> execution) {
        this.queryExecutions.add(execution);
    }
}

