/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.io.socket.multicast;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MulticastSocket;
import org.apache.nifi.io.socket.multicast.MulticastConfiguration;
import org.apache.nifi.logging.NiFiLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MulticastUtils {
    private static final Logger logger = new NiFiLog(LoggerFactory.getLogger(MulticastUtils.class));

    public static MulticastSocket createMulticastSocket(MulticastConfiguration config) throws IOException {
        return MulticastUtils.createMulticastSocket(0, config);
    }

    public static MulticastSocket createMulticastSocket(int port, MulticastConfiguration config) throws IOException {
        if (config == null) {
            throw new IllegalArgumentException("Configuration may not be null.");
        }
        MulticastSocket socket = port <= 0 ? new MulticastSocket() : new MulticastSocket(port);
        socket.setTimeToLive(config.getTtl().getTtl());
        if (config.getSocketTimeout() != null) {
            socket.setSoTimeout(config.getSocketTimeout());
        }
        if (config.getReuseAddress() != null) {
            socket.setReuseAddress(config.getReuseAddress());
        }
        if (config.getReceiveBufferSize() != null) {
            socket.setReceiveBufferSize(config.getReceiveBufferSize());
        }
        if (config.getSendBufferSize() != null) {
            socket.setSendBufferSize(config.getSendBufferSize());
        }
        if (config.getTrafficClass() != null) {
            socket.setTrafficClass(config.getTrafficClass());
        }
        if (config.getLoopbackMode() != null) {
            socket.setLoopbackMode(config.getLoopbackMode());
        }
        return socket;
    }

    public static void closeQuietly(MulticastSocket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.close();
        }
        catch (Exception ex) {
            logger.debug("Failed to close multicast socket due to: " + ex, (Throwable)ex);
        }
    }

    public static void closeQuietly(MulticastSocket socket, InetAddress groupAddress) {
        if (socket == null) {
            return;
        }
        try {
            socket.leaveGroup(groupAddress);
        }
        catch (Exception ex) {
            logger.debug("Failed to leave multicast group due to: " + ex, (Throwable)ex);
        }
        try {
            socket.close();
        }
        catch (Exception ex) {
            logger.debug("Failed to close multicast socket due to: " + ex, (Throwable)ex);
        }
    }
}

