/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import java.util.Objects;

public class ProtectedPropertyContext {
    private static final String DEFAULT_CONTEXT = "default";
    private final String propertyName;
    private final String contextName;

    public static ProtectedPropertyContext contextFor(String propertyName, String contextName) {
        return new ProtectedPropertyContext(propertyName, contextName);
    }

    public static ProtectedPropertyContext defaultContext(String propertyName) {
        return new ProtectedPropertyContext(propertyName, DEFAULT_CONTEXT);
    }

    private ProtectedPropertyContext(String propertyName, String contextName) {
        this.propertyName = Objects.requireNonNull(propertyName);
        this.contextName = contextName == null ? DEFAULT_CONTEXT : contextName;
    }

    public String getContextKey() {
        return String.format("%s/%s", this.contextName, this.propertyName);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getContextName() {
        return this.contextName;
    }
}

