/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.diagnostics.bootstrap.tasks;

import java.util.ArrayList;
import java.util.Comparator;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.diagnostics.DiagnosticTask;
import org.apache.nifi.diagnostics.DiagnosticsDumpElement;
import org.apache.nifi.diagnostics.StandardDiagnosticsDumpElement;
import org.apache.nifi.nar.ExtensionManager;

public class NarsDiagnosticTask
implements DiagnosticTask {
    private final ExtensionManager extensionManager;

    public NarsDiagnosticTask(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    public DiagnosticsDumpElement captureDump(boolean verbose) {
        ArrayList<String> nars = new ArrayList<String>();
        for (Bundle bundle : this.extensionManager.getAllBundles()) {
            nars.add(bundle.getBundleDetails().getCoordinate().toString());
        }
        nars.sort(Comparator.naturalOrder());
        return new StandardDiagnosticsDumpElement("NARs Available", nars);
    }
}

