/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.service;

import java.util.List;
import java.util.Set;
import org.apache.nifi.extension.ExtensionFilterParams;
import org.apache.nifi.extension.manifest.ProvidedServiceAPI;
import org.apache.nifi.registry.db.entity.BucketEntity;
import org.apache.nifi.registry.db.entity.BucketItemEntity;
import org.apache.nifi.registry.db.entity.BundleEntity;
import org.apache.nifi.registry.db.entity.BundleVersionDependencyEntity;
import org.apache.nifi.registry.db.entity.BundleVersionEntity;
import org.apache.nifi.registry.db.entity.ExtensionAdditionalDetailsEntity;
import org.apache.nifi.registry.db.entity.ExtensionEntity;
import org.apache.nifi.registry.db.entity.FlowEntity;
import org.apache.nifi.registry.db.entity.FlowSnapshotEntity;
import org.apache.nifi.registry.db.entity.TagCountEntity;
import org.apache.nifi.registry.extension.bundle.BundleFilterParams;
import org.apache.nifi.registry.extension.bundle.BundleVersionFilterParams;

public interface MetadataService {
    public BucketEntity createBucket(BucketEntity var1);

    public BucketEntity getBucketById(String var1);

    public List<BucketEntity> getBucketsByName(String var1);

    public BucketEntity updateBucket(BucketEntity var1);

    public void deleteBucket(BucketEntity var1);

    public List<BucketEntity> getBuckets(Set<String> var1);

    public List<BucketEntity> getAllBuckets();

    public List<BucketItemEntity> getBucketItems(String var1);

    public List<BucketItemEntity> getBucketItems(Set<String> var1);

    public FlowEntity createFlow(FlowEntity var1);

    public FlowEntity getFlowById(String var1);

    public FlowEntity getFlowByIdWithSnapshotCounts(String var1);

    public List<FlowEntity> getFlowsByName(String var1);

    public List<FlowEntity> getFlowsByName(String var1, String var2);

    public List<FlowEntity> getFlowsByBucket(String var1);

    public FlowEntity updateFlow(FlowEntity var1);

    public void deleteFlow(FlowEntity var1);

    public FlowSnapshotEntity createFlowSnapshot(FlowSnapshotEntity var1);

    public FlowSnapshotEntity getFlowSnapshot(String var1, Integer var2);

    public FlowSnapshotEntity getLatestSnapshot(String var1);

    public List<FlowSnapshotEntity> getSnapshots(String var1);

    public void deleteFlowSnapshot(FlowSnapshotEntity var1);

    public BundleEntity createBundle(BundleEntity var1);

    public BundleEntity getBundle(String var1);

    public BundleEntity getBundle(String var1, String var2, String var3);

    public List<BundleEntity> getBundles(Set<String> var1, BundleFilterParams var2);

    public List<BundleEntity> getBundlesByBucket(String var1);

    public List<BundleEntity> getBundlesByBucketAndGroup(String var1, String var2);

    public void deleteBundle(BundleEntity var1);

    public void deleteBundle(String var1);

    public BundleVersionEntity createBundleVersion(BundleVersionEntity var1);

    public BundleVersionEntity getBundleVersion(String var1, String var2);

    public BundleVersionEntity getBundleVersion(String var1, String var2, String var3, String var4);

    public List<BundleVersionEntity> getBundleVersions(Set<String> var1, BundleVersionFilterParams var2);

    public List<BundleVersionEntity> getBundleVersions(String var1);

    public List<BundleVersionEntity> getBundleVersions(String var1, String var2, String var3);

    public List<BundleVersionEntity> getBundleVersionsGlobal(String var1, String var2, String var3);

    public void deleteBundleVersion(BundleVersionEntity var1);

    public void deleteBundleVersion(String var1);

    public BundleVersionDependencyEntity createDependency(BundleVersionDependencyEntity var1);

    public List<BundleVersionDependencyEntity> getDependenciesForBundleVersion(String var1);

    public ExtensionEntity createExtension(ExtensionEntity var1);

    public ExtensionEntity getExtensionById(String var1);

    public ExtensionEntity getExtensionByName(String var1, String var2);

    public ExtensionAdditionalDetailsEntity getExtensionAdditionalDetails(String var1, String var2);

    public List<ExtensionEntity> getExtensions(Set<String> var1, ExtensionFilterParams var2);

    public List<ExtensionEntity> getExtensionsByProvidedServiceApi(Set<String> var1, ProvidedServiceAPI var2);

    public List<ExtensionEntity> getExtensionsByBundleVersionId(String var1);

    public List<TagCountEntity> getAllExtensionTags();

    public void deleteExtension(ExtensionEntity var1);

    public Set<String> getBucketFields();

    public Set<String> getBucketItemFields();

    public Set<String> getFlowFields();
}

