/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.snowflake;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.snowflake.SnowflakeDatabase;
import org.flywaydb.core.internal.database.snowflake.SnowflakeTable;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.RowMapper;
import org.flywaydb.core.internal.util.Pair;

public class SnowflakeSchema
extends Schema<SnowflakeDatabase, SnowflakeTable> {
    private static final Log LOG = LogFactory.getLog(SnowflakeSchema.class);

    SnowflakeSchema(JdbcTemplate jdbcTemplate, SnowflakeDatabase database, String name) {
        super(jdbcTemplate, database, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        List<Boolean> results = this.jdbcTemplate.query("SHOW SCHEMAS LIKE '" + this.name + "'", rs -> true, new Object[0]);
        return !results.isEmpty();
    }

    @Override
    protected boolean doEmpty() throws SQLException {
        int objectCount = this.getObjectCount("TABLE") + this.getObjectCount("VIEW") + this.getObjectCount("SEQUENCE");
        return objectCount == 0;
    }

    private int getObjectCount(String objectType) throws SQLException {
        return this.jdbcTemplate.query("SHOW " + objectType + "S IN SCHEMA " + ((SnowflakeDatabase)this.database).quote(this.name), rs -> 1, new Object[0]).size();
    }

    @Override
    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA " + ((SnowflakeDatabase)this.database).quote(this.name), new Object[0]);
    }

    @Override
    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP SCHEMA " + ((SnowflakeDatabase)this.database).quote(this.name), new Object[0]);
    }

    @Override
    protected void doClean() throws SQLException {
        for (String string : this.generateDropStatements("VIEW")) {
            this.jdbcTemplate.execute(string, new Object[0]);
        }
        for (String string : this.generateDropStatements("TABLE")) {
            this.jdbcTemplate.execute(string, new Object[0]);
        }
        for (String string : this.generateDropStatements("SEQUENCE")) {
            this.jdbcTemplate.execute(string, new Object[0]);
        }
        for (Pair pair : this.generateDropStatementsWithArgs("USER FUNCTIONS", "FUNCTION")) {
            try {
                this.jdbcTemplate.execute((String)pair.getRight(), new Object[0]);
            }
            catch (SQLException sqlException) {
                LOG.warn("Unable to drop User Function " + (String)pair.getLeft() + ": " + sqlException.getMessage());
            }
        }
        for (Pair pair : this.generateDropStatementsWithArgs("PROCEDURES", "PROCEDURE")) {
            try {
                this.jdbcTemplate.execute((String)pair.getRight(), new Object[0]);
            }
            catch (SQLException sqlException) {
                LOG.warn("Unable to drop Procedure " + (String)pair.getLeft() + ": " + sqlException.getMessage());
            }
        }
    }

    protected SnowflakeTable[] doAllTables() throws SQLException {
        List<SnowflakeTable> tables = this.jdbcTemplate.query("SHOW TABLES IN SCHEMA " + ((SnowflakeDatabase)this.database).quote(this.name), new RowMapper<SnowflakeTable>(){

            @Override
            public SnowflakeTable mapRow(ResultSet rs) throws SQLException {
                String tableName = rs.getString("name");
                return (SnowflakeTable)SnowflakeSchema.this.getTable(tableName);
            }
        }, new Object[0]);
        return tables.toArray(new SnowflakeTable[0]);
    }

    @Override
    public Table getTable(String tableName) {
        return new SnowflakeTable(this.jdbcTemplate, (SnowflakeDatabase)this.database, this, tableName);
    }

    private List<String> generateDropStatements(String objectType) throws SQLException {
        return this.jdbcTemplate.query("SHOW " + objectType + "S IN SCHEMA " + ((SnowflakeDatabase)this.database).quote(this.name), rs -> {
            String tableName = rs.getString("name");
            return "DROP " + objectType + " " + ((SnowflakeDatabase)this.database).quote(this.name) + "." + ((SnowflakeDatabase)this.database).quote(tableName);
        }, new Object[0]);
    }

    private List<Pair<String, String>> generateDropStatementsWithArgs(String showObjectType, String dropObjectType) throws SQLException {
        return this.jdbcTemplate.query("SHOW " + showObjectType + " IN SCHEMA " + ((SnowflakeDatabase)this.database).quote(this.name), rs -> {
            String nameAndArgsList = rs.getString("arguments");
            int indexOfEndOfArgs = nameAndArgsList.indexOf(") RETURN ");
            String functionName = nameAndArgsList.substring(0, indexOfEndOfArgs + 1);
            return Pair.of(functionName, "DROP " + dropObjectType + " " + this.name + "." + functionName);
        }, new Object[0]);
    }
}

