/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.ToLongFunction;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiagnosticUtils {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosticUtils.class);

    private DiagnosticUtils() {
    }

    public static Path getOldestFile(String diagnosticDirectoryPath) throws IOException {
        Optional<Path> oldestFile;
        Comparator<Path> lastModifiedComparator = Comparator.comparingLong(p -> p.toFile().lastModified());
        try (Stream<Path> paths = Files.walk(Paths.get(diagnosticDirectoryPath, new String[0]), new FileVisitOption[0]);){
            oldestFile = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).min(lastModifiedComparator);
        }
        return oldestFile.orElseThrow(() -> new RuntimeException(String.format("Could not find oldest file in diagnostic directory: %s", diagnosticDirectoryPath)));
    }

    public static boolean isFileCountExceeded(String diagnosticDirectoryPath, int maxFileCount) {
        String[] fileNames = new File(diagnosticDirectoryPath).list();
        if (fileNames == null) {
            logger.error("The diagnostic directory path provided is either invalid or not permitted to be listed.");
            return false;
        }
        return fileNames.length >= maxFileCount;
    }

    public static boolean isSizeExceeded(String diagnosticDirectoryPath, long maxSizeInBytes) {
        return DiagnosticUtils.getDirectorySize(Paths.get(diagnosticDirectoryPath, new String[0])) >= maxSizeInBytes;
    }

    public static boolean createDiagnosticDirectory(String diagnosticDirectoryPath) {
        File file = new File(diagnosticDirectoryPath);
        return file.mkdir();
    }

    private static long getDirectorySize(Path path) {
        long size = 0L;
        try (Stream<Path> walk = Files.walk(path, new FileVisitOption[0]);){
            size = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).mapToLong(DiagnosticUtils.getFileSizeByPathFunction()).sum();
        }
        catch (IOException e) {
            logger.error("Directory [{}] size calculation failed", (Object)path, (Object)e);
        }
        return size;
    }

    private static ToLongFunction<Path> getFileSizeByPathFunction() {
        return path -> {
            try {
                return Files.size(path);
            }
            catch (IOException e) {
                logger.error("Failed to get size of file {}", path, (Object)e);
                return 0L;
            }
        };
    }
}

