/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client.nifi.impl;

import java.io.IOException;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import org.apache.nifi.registry.client.impl.request.BearerTokenRequestConfig;
import org.apache.nifi.toolkit.cli.impl.client.nifi.AccessClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.impl.AbstractJerseyClient;
import org.apache.nifi.util.StringUtils;

public class JerseyAccessClient
extends AbstractJerseyClient
implements AccessClient {
    private final WebTarget accessTarget;

    public JerseyAccessClient(WebTarget baseTarget) {
        super(null);
        this.accessTarget = baseTarget.path("/access");
    }

    @Override
    public String getToken(String username, String password) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("Username is required");
        }
        if (StringUtils.isBlank((String)password)) {
            throw new IllegalArgumentException("Password is required");
        }
        return this.executeAction("Error performing login", () -> {
            WebTarget target = this.accessTarget.path("token");
            Form form = new Form();
            form.param("username", username);
            form.param("password", password);
            return (String)this.getRequestBuilder(target).post(Entity.form((Form)form), String.class);
        });
    }

    @Override
    public String getTokenFromKerberosTicket() throws NiFiClientException, IOException {
        return this.executeAction("Error performing kerberos login", () -> {
            WebTarget target = this.accessTarget.path("kerberos");
            return (String)this.getRequestBuilder(target).post(Entity.text(null), String.class);
        });
    }

    @Override
    public void logout(String token) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((String)token)) {
            throw new IllegalArgumentException("Token is required");
        }
        this.executeAction("Error performing logout", () -> {
            WebTarget target = this.accessTarget.path("logout");
            Invocation.Builder requestBuilder = this.getRequestBuilder(target);
            BearerTokenRequestConfig tokenConfig = new BearerTokenRequestConfig(token);
            Map bearerHeaders = tokenConfig.getHeaders();
            bearerHeaders.entrySet().stream().forEach(e -> requestBuilder.header((String)e.getKey(), e.getValue()));
            requestBuilder.delete();
            return null;
        });
    }
}

