/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.nifi.toolkit.cli.api.Command;
import org.apache.nifi.toolkit.cli.api.CommandGroup;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.AbstractCommandGroup;
import org.apache.nifi.toolkit.cli.impl.command.composite.DemoCommandGroup;
import org.apache.nifi.toolkit.cli.impl.command.misc.Exit;
import org.apache.nifi.toolkit.cli.impl.command.misc.Help;
import org.apache.nifi.toolkit.cli.impl.command.nifi.NiFiCommandGroup;
import org.apache.nifi.toolkit.cli.impl.command.registry.NiFiRegistryCommandGroup;
import org.apache.nifi.toolkit.cli.impl.command.session.SessionCommandGroup;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;

public class CommandFactory {
    public static Map<String, Command> createTopLevelCommands(Context context) {
        ArrayList<Command<VoidResult>> commandList = new ArrayList<Command<VoidResult>>();
        commandList.add(new Help());
        commandList.add(new Exit());
        TreeMap commandMap = new TreeMap();
        commandList.stream().forEach(cmd -> {
            cmd.initialize(context);
            commandMap.put(cmd.getName(), cmd);
        });
        return Collections.unmodifiableMap(commandMap);
    }

    public static Map<String, CommandGroup> createCommandGroups(Context context) {
        ArrayList<AbstractCommandGroup> groups = new ArrayList<AbstractCommandGroup>();
        groups.add(new NiFiRegistryCommandGroup());
        groups.add(new NiFiCommandGroup());
        groups.add(new DemoCommandGroup());
        groups.add(new SessionCommandGroup());
        TreeMap groupMap = new TreeMap();
        groups.stream().forEach(g -> {
            g.initialize(context);
            groupMap.put(g.getName(), g);
        });
        return Collections.unmodifiableMap(groupMap);
    }
}

