/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.access;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;

public class LogoutAccessToken
extends AbstractNiFiCommand<VoidResult> {
    public LogoutAccessToken() {
        super("logout-access-token", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Performs a logout for the given access token";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.BEARER_TOKEN.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String bearerToken = this.getRequiredArg(properties, CommandOption.BEARER_TOKEN);
        client.getAccessClient().logout(bearerToken);
        return VoidResult.getInstance();
    }
}

