/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.logout;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.util.StringUtils;
import org.apache.nifi.web.security.logout.LogoutRequest;
import org.apache.nifi.web.security.util.CacheKey;

public class LogoutRequestManager {
    private final Cache<CacheKey, LogoutRequest> requestLookup;

    public LogoutRequestManager() {
        this(60, TimeUnit.SECONDS);
    }

    public LogoutRequestManager(int cacheExpiration, TimeUnit units) {
        this.requestLookup = Caffeine.newBuilder().expireAfterWrite((long)cacheExpiration, units).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(LogoutRequest logoutRequest) {
        if (logoutRequest == null) {
            throw new IllegalArgumentException("Logout Request is required");
        }
        CacheKey requestIdentifierKey = new CacheKey(logoutRequest.getRequestIdentifier());
        Cache<CacheKey, LogoutRequest> cache = this.requestLookup;
        synchronized (cache) {
            LogoutRequest existingRequest = (LogoutRequest)this.requestLookup.getIfPresent((Object)requestIdentifierKey);
            if (existingRequest != null) {
                throw new IllegalStateException("An existing logout request is already in progress");
            }
            this.requestLookup.put((Object)requestIdentifierKey, (Object)logoutRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogoutRequest get(String requestIdentifier) {
        if (StringUtils.isBlank((String)requestIdentifier)) {
            throw new IllegalArgumentException("Request identifier is required");
        }
        CacheKey requestIdentifierKey = new CacheKey(requestIdentifier);
        Cache<CacheKey, LogoutRequest> cache = this.requestLookup;
        synchronized (cache) {
            LogoutRequest logoutRequest = (LogoutRequest)this.requestLookup.getIfPresent((Object)requestIdentifierKey);
            return logoutRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogoutRequest complete(String requestIdentifier) {
        if (StringUtils.isBlank((String)requestIdentifier)) {
            throw new IllegalArgumentException("Request identifier is required");
        }
        CacheKey requestIdentifierKey = new CacheKey(requestIdentifier);
        Cache<CacheKey, LogoutRequest> cache = this.requestLookup;
        synchronized (cache) {
            LogoutRequest logoutRequest = (LogoutRequest)this.requestLookup.getIfPresent((Object)requestIdentifierKey);
            if (logoutRequest != null) {
                this.requestLookup.invalidate((Object)requestIdentifierKey);
            }
            return logoutRequest;
        }
    }
}

