/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.x509;

import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.authentication.AuthenticationResponse;
import org.apache.nifi.web.security.x509.X509CertificateValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.authentication.preauth.x509.X509PrincipalExtractor;

public class X509IdentityProvider {
    private static final Logger logger = LoggerFactory.getLogger(X509IdentityProvider.class);
    private final String issuer = this.getClass().getSimpleName();
    private X509CertificateValidator certificateValidator;
    private X509PrincipalExtractor principalExtractor;

    public AuthenticationResponse authenticate(X509Certificate[] certificates) throws IllegalArgumentException {
        if (certificates == null || certificates.length == 0) {
            throw new IllegalArgumentException("The specified request does not contain a client certificate.");
        }
        Object certificatePrincipal = this.principalExtractor.extractPrincipal(certificates[0]);
        String principal = certificatePrincipal.toString();
        try {
            this.certificateValidator.validateClientCertificate(certificates);
        }
        catch (CertificateExpiredException cee) {
            String message = String.format("Client certificate for (%s) is expired.", principal);
            logger.info(message, (Throwable)cee);
            if (logger.isDebugEnabled()) {
                logger.debug("", (Throwable)cee);
            }
            throw new IllegalArgumentException(message, cee);
        }
        catch (CertificateNotYetValidException cnyve) {
            String message = String.format("Client certificate for (%s) is not yet valid.", principal);
            logger.info(message, (Throwable)cnyve);
            if (logger.isDebugEnabled()) {
                logger.debug("", (Throwable)cnyve);
            }
            throw new IllegalArgumentException(message, cnyve);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            if (logger.isDebugEnabled()) {
                logger.debug("", (Throwable)e);
            }
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return new AuthenticationResponse(principal, principal, TimeUnit.MILLISECONDS.convert(12L, TimeUnit.HOURS), this.issuer);
    }

    public void setCertificateValidator(X509CertificateValidator certificateValidator) {
        this.certificateValidator = certificateValidator;
    }

    public void setPrincipalExtractor(X509PrincipalExtractor principalExtractor) {
        this.principalExtractor = principalExtractor;
    }
}

