/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import groovy.io.GroovyPrintWriter;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.xml.XmlSlurper;
import groovy.xml.XmlUtil;
import groovy.xml.slurpersupport.GPathResult;
import groovy.xml.slurpersupport.NodeChild;
import java.beans.Transient;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.KeyException;
import java.security.Security;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.codec.binary.Hex;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.encrypt.PropertyEncryptorFactory;
import org.apache.nifi.flow.encryptor.FlowEncryptor;
import org.apache.nifi.flow.encryptor.StandardFlowEncryptor;
import org.apache.nifi.properties.ApplicationPropertiesProtector;
import org.apache.nifi.properties.BootstrapProperties;
import org.apache.nifi.properties.NiFiPropertiesLoader;
import org.apache.nifi.properties.ProtectedNiFiProperties;
import org.apache.nifi.properties.ProtectedPropertyContext;
import org.apache.nifi.properties.SensitivePropertyProtectionException;
import org.apache.nifi.properties.SensitivePropertyProvider;
import org.apache.nifi.properties.SensitivePropertyProviderFactory;
import org.apache.nifi.properties.StandardSensitivePropertyProviderFactory;
import org.apache.nifi.properties.scheme.ProtectionScheme;
import org.apache.nifi.properties.scheme.StandardProtectionScheme;
import org.apache.nifi.properties.scheme.StandardProtectionSchemeResolver;
import org.apache.nifi.toolkit.tls.commandLine.CommandLineParseException;
import org.apache.nifi.toolkit.tls.commandLine.ExitCode;
import org.apache.nifi.util.NiFiBootstrapUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.console.TextDevice;
import org.apache.nifi.util.console.TextDevices;
import org.bouncycastle.crypto.generators.SCrypt;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ConfigEncryptionTool
implements GroovyObject {
    private static final Logger logger;
    public String bootstrapConfPath;
    public String niFiPropertiesPath;
    public String outputNiFiPropertiesPath;
    public String loginIdentityProvidersPath;
    public String outputLoginIdentityProvidersPath;
    public String authorizersPath;
    public String outputAuthorizersPath;
    public static Object flowXmlPath;
    public String outputFlowXmlPath;
    private static final ProtectionScheme DEFAULT_PROTECTION_SCHEME;
    private ProtectionScheme protectionScheme;
    private ProtectionScheme migrationProtectionScheme;
    private String keyHex;
    private String migrationKeyHex;
    private String password;
    private String migrationPassword;
    private String flowPropertiesPassword;
    private String existingFlowPropertiesPassword;
    private String newFlowAlgorithm;
    private String newFlowProvider;
    private NiFiProperties niFiProperties;
    private String loginIdentityProviders;
    private String authorizers;
    private InputStream flowXmlInputStream;
    private boolean usingPassword;
    private boolean usingPasswordMigration;
    private boolean migration;
    private boolean isVerbose;
    private boolean handlingNiFiProperties;
    private boolean handlingLoginIdentityProviders;
    private boolean handlingAuthorizers;
    private boolean handlingFlowXml;
    private boolean ignorePropertiesFiles;
    private boolean translatingCli;
    private static final String HELP_ARG = "help";
    private static final String VERBOSE_ARG = "verbose";
    private static final String BOOTSTRAP_CONF_ARG = "bootstrapConf";
    private static final String NIFI_PROPERTIES_ARG = "niFiProperties";
    private static final String OUTPUT_NIFI_PROPERTIES_ARG = "outputNiFiProperties";
    private static final String LOGIN_IDENTITY_PROVIDERS_ARG = "loginIdentityProviders";
    private static final String OUTPUT_LOGIN_IDENTITY_PROVIDERS_ARG = "outputLoginIdentityProviders";
    private static final String AUTHORIZERS_ARG = "authorizers";
    private static final String OUTPUT_AUTHORIZERS_ARG = "outputAuthorizers";
    private static final String FLOW_XML_ARG = "flowXml";
    private static final String OUTPUT_FLOW_XML_ARG = "outputFlowXml";
    private static final String KEY_ARG = "key";
    private static final String PROTECTION_SCHEME_ARG = "protectionScheme";
    private static final String PASSWORD_ARG = "password";
    private static final String KEY_MIGRATION_ARG = "oldKey";
    private static final String PASSWORD_MIGRATION_ARG = "oldPassword";
    private static final String PROTECTION_SCHEME_MIGRATION_ARG = "oldProtectionScheme";
    private static final String USE_KEY_ARG = "useRawKey";
    private static final String MIGRATION_ARG = "migrate";
    private static final String PROPS_KEY_ARG = "propsKey";
    private static final String DO_NOT_ENCRYPT_NIFI_PROPERTIES_ARG = "encryptFlowXmlOnly";
    private static final String NEW_FLOW_ALGORITHM_ARG = "newFlowAlgorithm";
    private static final String NEW_FLOW_PROVIDER_ARG = "newFlowProvider";
    private static final String TRANSLATE_CLI_ARG = "translateCli";
    private static final StandardProtectionSchemeResolver PROTECTION_SCHEME_RESOLVER;
    private static final String PROTECTION_SCHEME_DESC;
    private static Options staticOptions;
    private static final String DEFAULT_NIFI_SENSITIVE_PROPS_KEY = "nififtw!";
    private static final int MIN_PASSWORD_LENGTH = 12;
    private static final int SCRYPT_N = 65536;
    private static final int SCRYPT_R = 8;
    private static final int SCRYPT_P = 1;
    private static final String BOOTSTRAP_KEY_COMMENT = "# Root key in hexadecimal format for encrypted sensitive configuration values";
    private static final String BOOTSTRAP_KEY_PREFIX = "nifi.bootstrap.sensitive.key=";
    private static final String JAVA_HOME = "JAVA_HOME";
    private static final String NIFI_TOOLKIT_HOME = "NIFI_TOOLKIT_HOME";
    private static final String SEP;
    private static final String FOOTER;
    private static final String DEFAULT_DESCRIPTION = "This tool reads from a nifi.properties and/or login-identity-providers.xml file with plain sensitive configuration values, prompts the user for a root key, and encrypts each value. It will replace the plain value with the protected value in the same file (or write to a new file if specified). It can also be used to migrate already-encrypted values in those files or in flow.xml.gz to be encrypted with a new key.";
    private static final String LDAP_PROVIDER_CLASS = "org.apache.nifi.ldap.LdapProvider";
    private static final String LDAP_PROVIDER_REGEX = "(?s)<provider>(?:(?!<provider>).)*?<class>\\s*org\\.apache\\.nifi\\.ldap\\.LdapProvider.*?</provider>";
    private static final String LDAP_USER_GROUP_PROVIDER_CLASS = "org.apache.nifi.ldap.tenants.LdapUserGroupProvider";
    private static final String LDAP_USER_GROUP_PROVIDER_REGEX = "(?s)<userGroupProvider>(?:(?!<userGroupProvider>).)*?<class>\\s*org\\.apache\\.nifi\\.ldap\\.tenants\\.LdapUserGroupProvider.*?</userGroupProvider>";
    private static final String AZURE_USER_GROUP_PROVIDER_CLASS = "org.apache.nifi.authorization.azure.AzureGraphUserGroupProvider";
    private static final String AZURE_USER_GROUP_PROVIDER_REGEX = "(?s)<userGroupProvider>(?:(?!<userGroupProvider>).)*?<class>\\s*org\\.apache\\.nifi\\.authorization\\.azure\\.AzureGraphUserGroupProvider.*?</userGroupProvider>";
    private static final String XML_DECLARATION_REGEX = "<\\?xml version=\"1.0\" encoding=\"UTF-8\"\\?>";
    private static final String WRAPPED_FLOW_XML_CIPHER_TEXT_REGEX = "enc\\{[a-fA-F0-9]+?\\}";
    private static final String DEFAULT_FLOW_ALGORITHM = "PBEWITHMD5AND256BITAES-CBC-OPENSSL";
    private static final Map<String, String> PROPERTY_KEY_MAP;
    private final Options options;
    private final String header;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;
    private static /* synthetic */ Class $class$org$apache$nifi$properties$ProtectedNiFiProperties;

    public ConfigEncryptionTool() {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        this(ShortTypeHandling.castToString((Object)callSiteArray[0].callGetProperty(ConfigEncryptionTool.class)));
    }

    public ConfigEncryptionTool(String description) {
        MetaClass metaClass;
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        boolean bl7;
        boolean bl8;
        boolean bl9;
        boolean bl10;
        ProtectionScheme protectionScheme;
        ProtectionScheme protectionScheme2;
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        this.protectionScheme = protectionScheme2 = DEFAULT_PROTECTION_SCHEME;
        this.migrationProtectionScheme = protectionScheme = DEFAULT_PROTECTION_SCHEME;
        this.usingPassword = bl10 = true;
        this.usingPasswordMigration = bl9 = true;
        this.migration = bl8 = false;
        this.isVerbose = bl7 = false;
        this.handlingNiFiProperties = bl6 = false;
        this.handlingLoginIdentityProviders = bl5 = false;
        this.handlingAuthorizers = bl4 = false;
        this.handlingFlowXml = bl3 = false;
        this.ignorePropertiesFiles = bl2 = false;
        this.translatingCli = bl = false;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        if (BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[1].callStatic(ConfigEncryptionTool.class, (Object)description);
            this.header = ShortTypeHandling.castToString((Object)object);
        } else {
            String string;
            this.header = string = ConfigEncryptionTool.buildHeader(description);
        }
        if (BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[2].callStatic(ConfigEncryptionTool.class);
            this.options = (Options)ScriptBytecodeAdapter.castToType((Object)object, Options.class);
        } else {
            Options options;
            this.options = options = ConfigEncryptionTool.getCliOptions();
        }
    }

    private static String buildHeader(String description) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{SEP, description, callSiteArray[3].call((Object)SEP, (Object)2)}, new String[]{"", "", "", ""}));
    }

    private static String buildFooter() {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{SEP, callSiteArray[4].call(System.class, (Object)JAVA_HOME), SEP, callSiteArray[5].call(System.class, (Object)NIFI_TOOLKIT_HOME)}, new String[]{"", "Java home: ", "", "NiFi Toolkit home: ", ""}));
    }

    public static Options buildOptions() {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        Options options = (Options)ScriptBytecodeAdapter.castToType((Object)callSiteArray[6].callConstructor(Options.class), Options.class);
        callSiteArray[7].call((Object)options, callSiteArray[8].call(callSiteArray[9].call(callSiteArray[10].call(callSiteArray[11].call(callSiteArray[12].call(Option.class, (Object)"h"), (Object)HELP_ARG), (Object)false), (Object)"Show usage information (this message)")));
        callSiteArray[13].call((Object)options, callSiteArray[14].call(callSiteArray[15].call(callSiteArray[16].call(callSiteArray[17].call(callSiteArray[18].call(Option.class, (Object)"v"), (Object)VERBOSE_ARG), (Object)false), (Object)"Sets verbose mode (default false)")));
        callSiteArray[19].call((Object)options, callSiteArray[20].call(callSiteArray[21].call(callSiteArray[22].call(callSiteArray[23].call(callSiteArray[24].call(callSiteArray[25].call(Option.class, (Object)"n"), (Object)NIFI_PROPERTIES_ARG), (Object)true), (Object)"file"), (Object)"The nifi.properties file containing unprotected config values (will be overwritten unless -o is specified)")));
        callSiteArray[26].call((Object)options, callSiteArray[27].call(callSiteArray[28].call(callSiteArray[29].call(callSiteArray[30].call(callSiteArray[31].call(callSiteArray[32].call(Option.class, (Object)"o"), (Object)OUTPUT_NIFI_PROPERTIES_ARG), (Object)true), (Object)"file"), (Object)"The destination nifi.properties file containing protected config values (will not modify input nifi.properties)")));
        callSiteArray[33].call((Object)options, callSiteArray[34].call(callSiteArray[35].call(callSiteArray[36].call(callSiteArray[37].call(callSiteArray[38].call(callSiteArray[39].call(Option.class, (Object)"l"), (Object)LOGIN_IDENTITY_PROVIDERS_ARG), (Object)true), (Object)"file"), (Object)"The login-identity-providers.xml file containing unprotected config values (will be overwritten unless -i is specified)")));
        callSiteArray[40].call((Object)options, callSiteArray[41].call(callSiteArray[42].call(callSiteArray[43].call(callSiteArray[44].call(callSiteArray[45].call(callSiteArray[46].call(Option.class, (Object)"i"), (Object)OUTPUT_LOGIN_IDENTITY_PROVIDERS_ARG), (Object)true), (Object)"file"), (Object)"The destination login-identity-providers.xml file containing protected config values (will not modify input login-identity-providers.xml)")));
        callSiteArray[47].call((Object)options, callSiteArray[48].call(callSiteArray[49].call(callSiteArray[50].call(callSiteArray[51].call(callSiteArray[52].call(callSiteArray[53].call(Option.class, (Object)"a"), (Object)AUTHORIZERS_ARG), (Object)true), (Object)"file"), (Object)"The authorizers.xml file containing unprotected config values (will be overwritten unless -u is specified)")));
        callSiteArray[54].call((Object)options, callSiteArray[55].call(callSiteArray[56].call(callSiteArray[57].call(callSiteArray[58].call(callSiteArray[59].call(callSiteArray[60].call(Option.class, (Object)"u"), (Object)OUTPUT_AUTHORIZERS_ARG), (Object)true), (Object)"file"), (Object)"The destination authorizers.xml file containing protected config values (will not modify input authorizers.xml)")));
        callSiteArray[61].call((Object)options, callSiteArray[62].call(callSiteArray[63].call(callSiteArray[64].call(callSiteArray[65].call(callSiteArray[66].call(callSiteArray[67].call(Option.class, (Object)"f"), (Object)FLOW_XML_ARG), (Object)true), (Object)"file"), (Object)"The flow.xml.gz file currently protected with old password (will be overwritten unless -g is specified)")));
        callSiteArray[68].call((Object)options, callSiteArray[69].call(callSiteArray[70].call(callSiteArray[71].call(callSiteArray[72].call(callSiteArray[73].call(callSiteArray[74].call(Option.class, (Object)"g"), (Object)OUTPUT_FLOW_XML_ARG), (Object)true), (Object)"file"), (Object)"The destination flow.xml.gz file containing protected config values (will not modify input flow.xml.gz)")));
        callSiteArray[75].call((Object)options, callSiteArray[76].call(callSiteArray[77].call(callSiteArray[78].call(callSiteArray[79].call(callSiteArray[80].call(callSiteArray[81].call(Option.class, (Object)"b"), (Object)BOOTSTRAP_CONF_ARG), (Object)true), (Object)"file"), (Object)"The bootstrap.conf file to persist root key and to optionally provide any configuration for the protection scheme.")));
        callSiteArray[82].call((Object)options, callSiteArray[83].call(callSiteArray[84].call(callSiteArray[85].call(callSiteArray[86].call(callSiteArray[87].call(callSiteArray[88].call(Option.class, (Object)"S"), (Object)PROTECTION_SCHEME_ARG), (Object)true), (Object)PROTECTION_SCHEME_ARG), (Object)PROTECTION_SCHEME_DESC)));
        callSiteArray[89].call((Object)options, callSiteArray[90].call(callSiteArray[91].call(callSiteArray[92].call(callSiteArray[93].call(callSiteArray[94].call(callSiteArray[95].call(Option.class, (Object)"k"), (Object)KEY_ARG), (Object)true), (Object)"keyhex"), (Object)"The raw hexadecimal key to use to encrypt the sensitive properties")));
        callSiteArray[96].call((Object)options, callSiteArray[97].call(callSiteArray[98].call(callSiteArray[99].call(callSiteArray[100].call(callSiteArray[101].call(callSiteArray[102].call(Option.class, (Object)"e"), (Object)KEY_MIGRATION_ARG), (Object)true), (Object)"keyhex"), (Object)"The old raw hexadecimal key to use during key migration")));
        callSiteArray[103].call((Object)options, callSiteArray[104].call(callSiteArray[105].call(callSiteArray[106].call(callSiteArray[107].call(callSiteArray[108].call(callSiteArray[109].call(Option.class, (Object)"H"), (Object)PROTECTION_SCHEME_MIGRATION_ARG), (Object)true), (Object)PROTECTION_SCHEME_ARG), (Object)"The old protection scheme to use during encryption migration (see --protectionScheme for possible values). Default is AES_GCM")));
        callSiteArray[110].call((Object)options, callSiteArray[111].call(callSiteArray[112].call(callSiteArray[113].call(callSiteArray[114].call(callSiteArray[115].call(callSiteArray[116].call(Option.class, (Object)"p"), (Object)PASSWORD_ARG), (Object)true), (Object)PASSWORD_ARG), (Object)"The password from which to derive the key to use to encrypt the sensitive properties")));
        callSiteArray[117].call((Object)options, callSiteArray[118].call(callSiteArray[119].call(callSiteArray[120].call(callSiteArray[121].call(callSiteArray[122].call(callSiteArray[123].call(Option.class, (Object)"w"), (Object)PASSWORD_MIGRATION_ARG), (Object)true), (Object)PASSWORD_ARG), (Object)"The old password from which to derive the key during migration")));
        callSiteArray[124].call((Object)options, callSiteArray[125].call(callSiteArray[126].call(callSiteArray[127].call(callSiteArray[128].call(callSiteArray[129].call(Option.class, (Object)"r"), (Object)USE_KEY_ARG), (Object)false), (Object)"If provided, the secure console will prompt for the raw key value in hexadecimal form")));
        callSiteArray[130].call((Object)options, callSiteArray[131].call(callSiteArray[132].call(callSiteArray[133].call(callSiteArray[134].call(callSiteArray[135].call(Option.class, (Object)"m"), (Object)MIGRATION_ARG), (Object)false), (Object)"If provided, the nifi.properties and/or login-identity-providers.xml sensitive properties will be re-encrypted with the new scheme")));
        callSiteArray[136].call((Object)options, callSiteArray[137].call(callSiteArray[138].call(callSiteArray[139].call(callSiteArray[140].call(callSiteArray[141].call(Option.class, (Object)"x"), (Object)DO_NOT_ENCRYPT_NIFI_PROPERTIES_ARG), (Object)false), (Object)"If provided, the properties in flow.xml.gz will be re-encrypted with a new key but the nifi.properties and/or login-identity-providers.xml files will not be modified")));
        callSiteArray[142].call((Object)options, callSiteArray[143].call(callSiteArray[144].call(callSiteArray[145].call(callSiteArray[146].call(callSiteArray[147].call(callSiteArray[148].call(Option.class, (Object)"s"), (Object)PROPS_KEY_ARG), (Object)true), (Object)"password|keyhex"), (Object)"The password or key to use to encrypt the sensitive processor properties in flow.xml.gz")));
        callSiteArray[149].call((Object)options, callSiteArray[150].call(callSiteArray[151].call(callSiteArray[152].call(callSiteArray[153].call(callSiteArray[154].call(callSiteArray[155].call(Option.class, (Object)"A"), (Object)NEW_FLOW_ALGORITHM_ARG), (Object)true), (Object)"algorithm"), (Object)"The algorithm to use to encrypt the sensitive processor properties in flow.xml.gz")));
        callSiteArray[156].call((Object)options, callSiteArray[157].call(callSiteArray[158].call(callSiteArray[159].call(callSiteArray[160].call(callSiteArray[161].call(callSiteArray[162].call(Option.class, (Object)"P"), (Object)NEW_FLOW_PROVIDER_ARG), (Object)true), (Object)"algorithm"), (Object)"The security provider to use to encrypt the sensitive processor properties in flow.xml.gz")));
        callSiteArray[163].call((Object)options, callSiteArray[164].call(callSiteArray[165].call(callSiteArray[166].call(callSiteArray[167].call(callSiteArray[168].call(Option.class, (Object)"c"), (Object)TRANSLATE_CLI_ARG), (Object)false), (Object)"Translates the nifi.properties file to a format suitable for the NiFi CLI tool")));
        return options;
    }

    public static Options getCliOptions() {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)staticOptions)) {
                Object object = callSiteArray[169].callStatic(ConfigEncryptionTool.class);
                staticOptions = (Options)ScriptBytecodeAdapter.castToType((Object)object, Options.class);
            }
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)staticOptions)) {
            Options options;
            staticOptions = options = ConfigEncryptionTool.buildOptions();
        }
        return staticOptions;
    }

    public void printUsage(String errorMessage) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)errorMessage)) {
            callSiteArray[170].call(callSiteArray[171].callGetProperty(System.class), (Object)errorMessage);
            callSiteArray[172].call(callSiteArray[173].callGetProperty(System.class));
        }
        HelpFormatter helpFormatter = (HelpFormatter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[174].callConstructor(HelpFormatter.class), HelpFormatter.class);
        callSiteArray[175].call((Object)helpFormatter, (Object)160);
        callSiteArray[176].call((Object)helpFormatter, null);
        callSiteArray[177].call((Object)helpFormatter, ArrayUtil.createArray((Object)callSiteArray[178].call(ConfigEncryptionTool.class), (Object)this.header, (Object)this.options, (Object)FOOTER, (Object)true));
    }

    protected void printUsageAndThrow(String errorMessage, ExitCode exitCode) throws CommandLineParseException {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[179].callCurrent((GroovyObject)this, (Object)errorMessage);
        } else {
            this.printUsage(errorMessage);
        }
        throw (Throwable)callSiteArray[180].callConstructor(CommandLineParseException.class, (Object)errorMessage, (Object)exitCode);
    }

    /*
     * Unable to fully structure code
     */
    protected CommandLine parse(String ... args) throws CommandLineParseException {
        var2_2 = ConfigEncryptionTool.$getCallSiteArray();
        parser = (CommandLineParser)ScriptBytecodeAdapter.castToType((Object)var2_2[181].callConstructor(DefaultParser.class), CommandLineParser.class);
        commandLine = null;
        var5_5 = var2_2[182].call((Object)parser, (Object)this.options, (Object)args);
        commandLine = (CommandLine)ScriptBytecodeAdapter.castToType((Object)var5_5, CommandLine.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)var2_2[183].call((Object)commandLine, (Object)ConfigEncryptionTool.HELP_ARG))) {
            var2_2[184].callCurrent((GroovyObject)this, null, var2_2[185].callGetProperty(ExitCode.class));
        }
        var6_6 = var2_2[186].call((Object)commandLine, (Object)ConfigEncryptionTool.VERBOSE_ARG);
        this.isVerbose = DefaultTypeTransformation.booleanUnbox((Object)var6_6);
        if (DefaultTypeTransformation.booleanUnbox((Object)var2_2[187].call((Object)commandLine, (Object)ConfigEncryptionTool.TRANSLATE_CLI_ARG))) {
            this.translatingCli = var7_7 = true;
            if (DefaultTypeTransformation.booleanUnbox((Object)var2_2[188].callCurrent((GroovyObject)this, (Object)commandLine, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{ConfigEncryptionTool.TRANSLATE_CLI_ARG, ConfigEncryptionTool.BOOTSTRAP_CONF_ARG, ConfigEncryptionTool.NIFI_PROPERTIES_ARG})))) {
                var2_2[189].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{ConfigEncryptionTool.TRANSLATE_CLI_ARG}, new String[]{"When '-c'/'--", "' is specified, only '-h', '-v', and '-n'/'-b' with the relevant files are allowed"}), var2_2[190].callGetProperty(ExitCode.class));
            }
        }
        var8_8 = var2_2[191].call((Object)commandLine, (Object)ConfigEncryptionTool.BOOTSTRAP_CONF_ARG);
        this.bootstrapConfPath = ShortTypeHandling.castToString((Object)var8_8);
        if (DefaultTypeTransformation.booleanUnbox((Object)var2_2[192].call((Object)commandLine, (Object)ConfigEncryptionTool.NIFI_PROPERTIES_ARG))) {
            ignoreFlagPresent = DefaultTypeTransformation.booleanUnbox((Object)var2_2[193].call((Object)commandLine, (Object)ConfigEncryptionTool.DO_NOT_ENCRYPT_NIFI_PROPERTIES_ARG));
            if (!BytecodeInterface8.isOrigZ() || ConfigEncryptionTool.__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (this.isVerbose != false && ignoreFlagPresent == false != false) {
                    var2_2[194].call((Object)ConfigEncryptionTool.logger, (Object)"Handling encryption of nifi.properties");
                }
            } else if (this.isVerbose != false && ignoreFlagPresent == false != false) {
                var2_2[195].call((Object)ConfigEncryptionTool.logger, (Object)"Handling encryption of nifi.properties");
            }
            var10_10 = var2_2[196].call((Object)commandLine, (Object)ConfigEncryptionTool.NIFI_PROPERTIES_ARG);
            this.niFiPropertiesPath = ShortTypeHandling.castToString((Object)var10_10);
            var11_11 = var2_2[197].call((Object)commandLine, (Object)ConfigEncryptionTool.OUTPUT_NIFI_PROPERTIES_ARG, (Object)this.niFiPropertiesPath);
            this.outputNiFiPropertiesPath = ShortTypeHandling.castToString((Object)var11_11);
            this.handlingNiFiProperties = var12_12 = ignoreFlagPresent == false;
            if (ScriptBytecodeAdapter.compareEqual((Object)this.niFiPropertiesPath, (Object)this.outputNiFiPropertiesPath)) {
                var2_2[198].call((Object)ConfigEncryptionTool.logger, (Object)new GStringImpl(new Object[]{this.outputNiFiPropertiesPath}, new String[]{"The source nifi.properties and destination nifi.properties are identical [", "] so the original will be overwritten"}));
            }
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)var2_2[199].call((Object)commandLine, (Object)ConfigEncryptionTool.PROTECTION_SCHEME_ARG))) {
            var13_13 = var2_2[200].call((Object)ConfigEncryptionTool.PROTECTION_SCHEME_RESOLVER, var2_2[201].call((Object)commandLine, (Object)ConfigEncryptionTool.PROTECTION_SCHEME_ARG));
            this.protectionScheme = (ProtectionScheme)ScriptBytecodeAdapter.castToType((Object)var13_13, ProtectionScheme.class);
        }
        if (!this.translatingCli) ** GOTO lbl62
        if (DefaultTypeTransformation.booleanUnbox((Object)this.niFiPropertiesPath) == false) {
            var2_2[202].callCurrent((GroovyObject)this, (Object)"When '-c'/'--translateCli' is specified, '-n'/'--niFiProperties' is required (and '-b'/'--bootstrapConf' is required if the properties are encrypted)", var2_2[203].callGetProperty(ExitCode.class));
        }
        var14_14 = commandLine;
        try {
            return var14_14;
lbl62:
            // 1 sources

            if (DefaultTypeTransformation.booleanUnbox((Object)var2_2[204].call((Object)commandLine, (Object)ConfigEncryptionTool.DO_NOT_ENCRYPT_NIFI_PROPERTIES_ARG))) {
                this.handlingNiFiProperties = var15_15 = false;
                this.handlingLoginIdentityProviders = var16_16 = false;
                this.handlingAuthorizers = var17_17 = false;
                this.ignorePropertiesFiles = var18_18 = true;
            } else {
                if (DefaultTypeTransformation.booleanUnbox((Object)var2_2[205].call((Object)commandLine, (Object)ConfigEncryptionTool.LOGIN_IDENTITY_PROVIDERS_ARG))) {
                    if (this.isVerbose) {
                        var2_2[206].call((Object)ConfigEncryptionTool.logger, (Object)"Handling encryption of login-identity-providers.xml");
                    }
                    var19_19 = var2_2[207].call((Object)commandLine, (Object)ConfigEncryptionTool.LOGIN_IDENTITY_PROVIDERS_ARG);
                    this.loginIdentityProvidersPath = ShortTypeHandling.castToString((Object)var19_19);
                    var20_20 = var2_2[208].call((Object)commandLine, (Object)ConfigEncryptionTool.OUTPUT_LOGIN_IDENTITY_PROVIDERS_ARG, (Object)this.loginIdentityProvidersPath);
                    this.outputLoginIdentityProvidersPath = ShortTypeHandling.castToString((Object)var20_20);
                    this.handlingLoginIdentityProviders = var21_21 = true;
                    if (ScriptBytecodeAdapter.compareEqual((Object)this.loginIdentityProvidersPath, (Object)this.outputLoginIdentityProvidersPath)) {
                        var2_2[209].call((Object)ConfigEncryptionTool.logger, (Object)new GStringImpl(new Object[]{this.outputLoginIdentityProvidersPath}, new String[]{"The source login-identity-providers.xml and destination login-identity-providers.xml are identical [", "] so the original will be overwritten"}));
                    }
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)var2_2[210].call((Object)commandLine, (Object)ConfigEncryptionTool.AUTHORIZERS_ARG))) {
                    if (this.isVerbose) {
                        var2_2[211].call((Object)ConfigEncryptionTool.logger, (Object)"Handling encryption of authorizers.xml");
                    }
                    var22_22 = var2_2[212].call((Object)commandLine, (Object)ConfigEncryptionTool.AUTHORIZERS_ARG);
                    this.authorizersPath = ShortTypeHandling.castToString((Object)var22_22);
                    var23_23 = var2_2[213].call((Object)commandLine, (Object)ConfigEncryptionTool.OUTPUT_AUTHORIZERS_ARG, (Object)this.authorizersPath);
                    this.outputAuthorizersPath = ShortTypeHandling.castToString((Object)var23_23);
                    this.handlingAuthorizers = var24_24 = true;
                    if (ScriptBytecodeAdapter.compareEqual((Object)this.authorizersPath, (Object)this.outputAuthorizersPath)) {
                        var2_2[214].call((Object)ConfigEncryptionTool.logger, (Object)new GStringImpl(new Object[]{this.outputAuthorizersPath}, new String[]{"The source authorizers.xml and destination authorizers.xml are identical [", "] so the original will be overwritten"}));
                    }
                }
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)var2_2[215].call((Object)commandLine, (Object)ConfigEncryptionTool.FLOW_XML_ARG))) {
                if (this.isVerbose) {
                    var2_2[216].call((Object)ConfigEncryptionTool.logger, (Object)"Handling encryption of flow.xml.gz");
                }
                ConfigEncryptionTool.flowXmlPath = var25_25 = var2_2[217].call((Object)commandLine, (Object)ConfigEncryptionTool.FLOW_XML_ARG);
                var26_26 = var2_2[218].call((Object)commandLine, (Object)ConfigEncryptionTool.OUTPUT_FLOW_XML_ARG, ConfigEncryptionTool.flowXmlPath);
                this.outputFlowXmlPath = ShortTypeHandling.castToString((Object)var26_26);
                this.handlingFlowXml = var27_27 = true;
                var28_28 = var2_2[219].call((Object)commandLine, (Object)ConfigEncryptionTool.NEW_FLOW_ALGORITHM_ARG);
                this.newFlowAlgorithm = ShortTypeHandling.castToString((Object)var28_28);
                var29_29 = var2_2[220].call((Object)commandLine, (Object)ConfigEncryptionTool.NEW_FLOW_PROVIDER_ARG);
                this.newFlowProvider = ShortTypeHandling.castToString((Object)var29_29);
                if (ScriptBytecodeAdapter.compareEqual((Object)ConfigEncryptionTool.flowXmlPath, (Object)this.outputFlowXmlPath)) {
                    var2_2[221].call((Object)ConfigEncryptionTool.logger, (Object)new GStringImpl(new Object[]{this.outputFlowXmlPath}, new String[]{"The source flow.xml.gz and destination flow.xml.gz are identical [", "] so the original will be overwritten"}));
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)var2_2[222].call((Object)commandLine, (Object)ConfigEncryptionTool.NIFI_PROPERTIES_ARG)) == false) {
                    var2_2[223].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{ConfigEncryptionTool.NIFI_PROPERTIES_ARG}, new String[]{"In order to migrate a flow.xml.gz, a nifi.properties file must also be specified via '-n'/'--", "'."}), var2_2[224].callGetProperty(ExitCode.class));
                }
            }
            if (this.isVerbose) {
                var2_2[225].call((Object)ConfigEncryptionTool.logger, (Object)new GStringImpl(new Object[]{this.bootstrapConfPath}, new String[]{"       bootstrap.conf:               ", ""}));
                var2_2[226].call((Object)ConfigEncryptionTool.logger, (Object)new GStringImpl(new Object[]{this.niFiPropertiesPath}, new String[]{"(src)  nifi.properties:              ", ""}));
                var2_2[227].call((Object)ConfigEncryptionTool.logger, (Object)new GStringImpl(new Object[]{this.outputNiFiPropertiesPath}, new String[]{"(dest) nifi.properties:              ", ""}));
                var2_2[228].call((Object)ConfigEncryptionTool.logger, (Object)new GStringImpl(new Object[]{this.loginIdentityProvidersPath}, new String[]{"(src)  login-identity-providers.xml: ", ""}));
                var2_2[229].call((Object)ConfigEncryptionTool.logger, (Object)new GStringImpl(new Object[]{this.outputLoginIdentityProvidersPath}, new String[]{"(dest) login-identity-providers.xml: ", ""}));
                var2_2[230].call((Object)ConfigEncryptionTool.logger, (Object)new GStringImpl(new Object[]{this.authorizersPath}, new String[]{"(src)  authorizers.xml:              ", ""}));
                var2_2[231].call((Object)ConfigEncryptionTool.logger, (Object)new GStringImpl(new Object[]{this.outputAuthorizersPath}, new String[]{"(dest) authorizers.xml:              ", ""}));
                var2_2[232].call((Object)ConfigEncryptionTool.logger, (Object)new GStringImpl(new Object[]{ConfigEncryptionTool.flowXmlPath}, new String[]{"(src)  flow.xml.gz:                  ", ""}));
                var2_2[233].call((Object)ConfigEncryptionTool.logger, (Object)new GStringImpl(new Object[]{this.outputFlowXmlPath}, new String[]{"(dest) flow.xml.gz:                  ", ""}));
            }
            if (!BytecodeInterface8.isOrigZ() || ConfigEncryptionTool.__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (((DefaultTypeTransformation.booleanUnbox((Object)var2_2[234].call((Object)commandLine, (Object)ConfigEncryptionTool.NIFI_PROPERTIES_ARG)) == false != false && DefaultTypeTransformation.booleanUnbox((Object)var2_2[235].call((Object)commandLine, (Object)ConfigEncryptionTool.LOGIN_IDENTITY_PROVIDERS_ARG)) == false != false) != false && DefaultTypeTransformation.booleanUnbox((Object)var2_2[236].call((Object)commandLine, (Object)ConfigEncryptionTool.AUTHORIZERS_ARG)) == false != false) != false && DefaultTypeTransformation.booleanUnbox((Object)var2_2[237].call((Object)commandLine, (Object)ConfigEncryptionTool.DO_NOT_ENCRYPT_NIFI_PROPERTIES_ARG)) == false != false) {
                    var2_2[238].callCurrent((GroovyObject)this, var2_2[239].call(var2_2[240].call(var2_2[241].call(var2_2[242].call(var2_2[243].call((Object)"One or more of [", (Object)new GStringImpl(new Object[]{ConfigEncryptionTool.NIFI_PROPERTIES_ARG}, new String[]{"'-n'/'--", "', "})), (Object)new GStringImpl(new Object[]{ConfigEncryptionTool.LOGIN_IDENTITY_PROVIDERS_ARG}, new String[]{"'-l'/'--", "', "})), (Object)new GStringImpl(new Object[]{ConfigEncryptionTool.AUTHORIZERS_ARG}, new String[]{"'-a'/'--", "'"})), (Object)"] must be provided unless "), (Object)new GStringImpl(new Object[]{ConfigEncryptionTool.DO_NOT_ENCRYPT_NIFI_PROPERTIES_ARG}, new String[]{"'-x'/--'", "' is specified"})), var2_2[244].callGetProperty(ExitCode.class));
                }
            } else if (((DefaultTypeTransformation.booleanUnbox((Object)var2_2[245].call((Object)commandLine, (Object)ConfigEncryptionTool.NIFI_PROPERTIES_ARG)) == false != false && DefaultTypeTransformation.booleanUnbox((Object)var2_2[246].call((Object)commandLine, (Object)ConfigEncryptionTool.LOGIN_IDENTITY_PROVIDERS_ARG)) == false != false) != false && DefaultTypeTransformation.booleanUnbox((Object)var2_2[247].call((Object)commandLine, (Object)ConfigEncryptionTool.AUTHORIZERS_ARG)) == false != false) != false && DefaultTypeTransformation.booleanUnbox((Object)var2_2[248].call((Object)commandLine, (Object)ConfigEncryptionTool.DO_NOT_ENCRYPT_NIFI_PROPERTIES_ARG)) == false != false) {
                var2_2[249].callCurrent((GroovyObject)this, var2_2[250].call(var2_2[251].call(var2_2[252].call(var2_2[253].call(var2_2[254].call((Object)"One or more of [", (Object)new GStringImpl(new Object[]{ConfigEncryptionTool.NIFI_PROPERTIES_ARG}, new String[]{"'-n'/'--", "', "})), (Object)new GStringImpl(new Object[]{ConfigEncryptionTool.LOGIN_IDENTITY_PROVIDERS_ARG}, new String[]{"'-l'/'--", "', "})), (Object)new GStringImpl(new Object[]{ConfigEncryptionTool.AUTHORIZERS_ARG}, new String[]{"'-a'/'--", "'"})), (Object)"] must be provided unless "), (Object)new GStringImpl(new Object[]{ConfigEncryptionTool.DO_NOT_ENCRYPT_NIFI_PROPERTIES_ARG}, new String[]{"'-x'/--'", "' is specified"})), var2_2[255].callGetProperty(ExitCode.class));
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)var2_2[256].call((Object)commandLine, (Object)ConfigEncryptionTool.MIGRATION_ARG))) {
                this.migration = var30_30 = true;
                if (this.isVerbose) {
                    var2_2[257].call((Object)ConfigEncryptionTool.logger, (Object)"Key migration mode activated");
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)var2_2[258].call((Object)commandLine, (Object)ConfigEncryptionTool.PROTECTION_SCHEME_MIGRATION_ARG))) {
                    var31_31 = var2_2[259].call((Object)ConfigEncryptionTool.PROTECTION_SCHEME_RESOLVER, var2_2[260].call((Object)commandLine, (Object)ConfigEncryptionTool.PROTECTION_SCHEME_MIGRATION_ARG));
                    this.migrationProtectionScheme = (ProtectionScheme)ScriptBytecodeAdapter.castToType((Object)var31_31, ProtectionScheme.class);
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)var2_2[261].call((Object)commandLine, (Object)ConfigEncryptionTool.PASSWORD_MIGRATION_ARG))) {
                    this.usingPasswordMigration = var32_32 = true;
                    if (DefaultTypeTransformation.booleanUnbox((Object)var2_2[262].call((Object)commandLine, (Object)ConfigEncryptionTool.KEY_MIGRATION_ARG))) {
                        var2_2[263].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{ConfigEncryptionTool.PASSWORD_MIGRATION_ARG, ConfigEncryptionTool.KEY_MIGRATION_ARG}, new String[]{"Only one of '-w'/'--", "' and '-e'/'--", "' can be used"}), var2_2[264].callGetProperty(ExitCode.class));
                    } else {
                        var33_33 = var2_2[265].call((Object)commandLine, (Object)ConfigEncryptionTool.PASSWORD_MIGRATION_ARG);
                        this.migrationPassword = ShortTypeHandling.castToString((Object)var33_33);
                    }
                } else {
                    var34_34 = var2_2[266].call((Object)commandLine, (Object)ConfigEncryptionTool.KEY_MIGRATION_ARG);
                    this.migrationKeyHex = ShortTypeHandling.castToString((Object)var34_34);
                    this.usingPasswordMigration = var35_35 = DefaultTypeTransformation.booleanUnbox((Object)this.migrationKeyHex) == false;
                }
            } else if (DefaultTypeTransformation.booleanUnbox((Object)var2_2[267].call((Object)commandLine, (Object)ConfigEncryptionTool.PASSWORD_MIGRATION_ARG)) != false || DefaultTypeTransformation.booleanUnbox((Object)var2_2[268].call((Object)commandLine, (Object)ConfigEncryptionTool.KEY_MIGRATION_ARG)) != false) {
                var2_2[269].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{ConfigEncryptionTool.PASSWORD_MIGRATION_ARG, ConfigEncryptionTool.KEY_MIGRATION_ARG, ConfigEncryptionTool.MIGRATION_ARG}, new String[]{"'-w'/'--", "' and '-e'/'--", "' are ignored unless '-m'/'--", "' is enabled"}), var2_2[270].callGetProperty(ExitCode.class));
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)var2_2[271].call((Object)commandLine, (Object)ConfigEncryptionTool.PASSWORD_ARG))) {
                this.usingPassword = var36_36 = true;
                if (DefaultTypeTransformation.booleanUnbox((Object)var2_2[272].call((Object)commandLine, (Object)ConfigEncryptionTool.KEY_ARG))) {
                    var2_2[273].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{ConfigEncryptionTool.PASSWORD_ARG, ConfigEncryptionTool.KEY_ARG}, new String[]{"Only one of '-p'/'--", "' and '-k'/'--", "' can be used"}), var2_2[274].callGetProperty(ExitCode.class));
                } else {
                    var37_37 = var2_2[275].call((Object)commandLine, (Object)ConfigEncryptionTool.PASSWORD_ARG);
                    this.password = ShortTypeHandling.castToString((Object)var37_37);
                }
            } else {
                var38_38 = var2_2[276].call((Object)commandLine, (Object)ConfigEncryptionTool.KEY_ARG);
                this.keyHex = ShortTypeHandling.castToString((Object)var38_38);
                this.usingPassword = var39_39 = DefaultTypeTransformation.booleanUnbox((Object)this.keyHex) == false;
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)var2_2[277].call((Object)commandLine, (Object)ConfigEncryptionTool.USE_KEY_ARG))) {
                if (DefaultTypeTransformation.booleanUnbox((Object)this.keyHex) != false || DefaultTypeTransformation.booleanUnbox((Object)this.password) != false) {
                    var2_2[278].call((Object)ConfigEncryptionTool.logger, (Object)new GStringImpl(new Object[]{ConfigEncryptionTool.USE_KEY_ARG}, new String[]{"If the key or password is provided in the arguments, '-r'/'--", "' is ignored"}));
                } else {
                    this.usingPassword = var40_40 = false;
                }
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)var2_2[279].call((Object)commandLine, (Object)ConfigEncryptionTool.PROPS_KEY_ARG))) {
                var41_41 = var2_2[280].call((Object)commandLine, (Object)ConfigEncryptionTool.PROPS_KEY_ARG);
                this.flowPropertiesPassword = ShortTypeHandling.castToString((Object)var41_41);
            }
        }
        catch (ParseException e) {
            if (this.isVerbose) {
                var2_2[281].call((Object)ConfigEncryptionTool.logger, (Object)"Encountered an error", (Object)e);
            }
            var2_2[282].callCurrent((GroovyObject)this, var2_2[283].call(var2_2[284].call((Object)"Error parsing command line. (", var2_2[285].call((Object)e)), (Object)")"), var2_2[286].callGetProperty(ExitCode.class));
        }
        return commandLine;
    }

    public boolean commandLineHasActionFlags(CommandLine commandLine, List<String> acceptableOptionStrings) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        List ALWAYS_ACCEPTABLE_OPTIONS = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[287].callStatic(ConfigEncryptionTool.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{HELP_ARG, VERBOSE_ARG})), List.class);
        List acceptableOptions = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[288].callStatic(ConfigEncryptionTool.class, acceptableOptionStrings), List.class);
        List invalidOptions = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[289].call(callSiteArray[290].callGetProperty((Object)commandLine), callSiteArray[291].call((Object)acceptableOptions, (Object)ALWAYS_ACCEPTABLE_OPTIONS)), List.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)invalidOptions)) {
            if (this.isVerbose) {
                callSiteArray[292].call((Object)logger, (Object)new GStringImpl(new Object[]{invalidOptions}, new String[]{"In this mode, the following options are invalid: ", ""}));
            }
            return true;
        }
        return false;
    }

    public static List<Option> resolveOptions(List<String> strings) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        public final class _resolveOptions_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _resolveOptions_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _resolveOptions_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String opt) {
                Reference opt2 = new Reference((Object)opt);
                CallSite[] callSiteArray = _resolveOptions_closure1.$getCallSiteArray();
                public final class _closure23
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference opt;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure23(Object _outerInstance, Object _thisObject, Reference opt) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure23.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.opt = reference = opt;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure23.$getCallSiteArray();
                        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)this.opt.get()) || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[1].callGetProperty(it), (Object)this.opt.get());
                        }
                        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].callGetProperty(it), (Object)this.opt.get()) || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[3].callGetProperty(it), (Object)this.opt.get());
                    }

                    @Generated
                    public String getOpt() {
                        CallSite[] callSiteArray = _closure23.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.opt.get());
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure23.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure23.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "opt";
                        stringArray[1] = "longOpt";
                        stringArray[2] = "opt";
                        stringArray[3] = "longOpt";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[4];
                        _closure23.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure23.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure23.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[0].call(callSiteArray[1].callGetProperty(callSiteArray[2].callCurrent((GroovyObject)this)), (Object)new _closure23((Object)this, this.getThisObject(), opt2));
            }

            @Generated
            public Object call(String opt) {
                Reference opt2 = new Reference((Object)opt);
                CallSite[] callSiteArray = _resolveOptions_closure1.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[3].callCurrent((GroovyObject)this, (Object)((String)opt2.get()));
                }
                return this.doCall((String)opt2.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _resolveOptions_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "find";
                stringArray[1] = "options";
                stringArray[2] = "getCliOptions";
                stringArray[3] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _resolveOptions_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_resolveOptions_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _resolveOptions_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[293].callSafe(strings, (Object)new _resolveOptions_closure1(ConfigEncryptionTool.class, ConfigEncryptionTool.class)), List.class);
    }

    private String getKeyInternal(TextDevice device, String keyHex, String password, boolean usingPassword) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (usingPassword) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)password)) {
                if (this.isVerbose) {
                    callSiteArray[294].call((Object)logger, (Object)"Reading password from secure console");
                }
                Object object = callSiteArray[295].callStatic(ConfigEncryptionTool.class, (Object)device);
                password = ShortTypeHandling.castToString((Object)object);
            }
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[296].callStatic(ConfigEncryptionTool.class, (Object)password);
                keyHex = ShortTypeHandling.castToString((Object)object);
            } else {
                String string;
                keyHex = string = ConfigEncryptionTool.deriveKeyFromPassword(password);
            }
            Object var9_9 = null;
            password = ShortTypeHandling.castToString(var9_9);
            return keyHex;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)keyHex)) {
            if (this.isVerbose) {
                callSiteArray[297].call((Object)logger, (Object)"Reading hex key from secure console");
            }
            Object object = callSiteArray[298].callStatic(ConfigEncryptionTool.class, (Object)device);
            keyHex = ShortTypeHandling.castToString((Object)object);
        }
        return keyHex;
    }

    private String getKey(TextDevice textDevice) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[299].callCurrent((GroovyObject)this, (Object)textDevice, (Object)this.keyHex, (Object)this.password, (Object)this.usingPassword));
    }

    private String getMigrationKey() {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[300].callCurrent((GroovyObject)this, callSiteArray[301].call(TextDevices.class), (Object)this.migrationKeyHex, (Object)this.migrationPassword, (Object)this.usingPasswordMigration));
    }

    private static String getFlowPassword(TextDevice textDevice) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[302].callStatic(ConfigEncryptionTool.class, (Object)textDevice));
    }

    private static String readKeyFromConsole(TextDevice textDevice) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        callSiteArray[303].call((Object)textDevice, (Object)"Enter the root key in hexadecimal format (spaces acceptable): ");
        return ShortTypeHandling.castToString((Object)callSiteArray[304].callConstructor(String.class, callSiteArray[305].call((Object)textDevice)));
    }

    private static String readPasswordFromConsole(TextDevice textDevice) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        callSiteArray[306].call((Object)textDevice, (Object)"Enter the password: ");
        return ShortTypeHandling.castToString((Object)callSiteArray[307].callConstructor(String.class, callSiteArray[308].call((Object)textDevice)));
    }

    private static String parseKey(String rawKey) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        String hexKey = ShortTypeHandling.castToString((Object)callSiteArray[309].call((Object)rawKey, (Object)"[^0-9a-fA-F]", (Object)""));
        return ShortTypeHandling.castToString((Object)callSiteArray[310].call((Object)hexKey));
    }

    public static List<Integer> getValidKeyLengths() {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[311].call(Cipher.class, (Object)"AES"), (Object)128) ? ScriptBytecodeAdapter.createList((Object[])new Object[]{128, 192, 256}) : ScriptBytecodeAdapter.createList((Object[])new Object[]{128});
    }

    private static NiFiPropertiesLoader getNiFiPropertiesLoader(String keyHex) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return (NiFiPropertiesLoader)ScriptBytecodeAdapter.castToType((Object)(ScriptBytecodeAdapter.compareEqual((Object)keyHex, null) ? callSiteArray[312].callConstructor(NiFiPropertiesLoader.class) : callSiteArray[313].call(NiFiPropertiesLoader.class, (Object)keyHex)), NiFiPropertiesLoader.class);
    }

    /*
     * Unable to fully structure code
     */
    private NiFiProperties loadNiFiProperties(String existingKeyHex) throws IOException {
        var2_2 = ConfigEncryptionTool.$getCallSiteArray();
        niFiPropertiesFile = null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.niFiPropertiesPath)) ** GOTO lbl-1000
        var4_4 = var2_2[315].callConstructor(File.class, (Object)this.niFiPropertiesPath);
        niFiPropertiesFile = (File)ScriptBytecodeAdapter.castToType((Object)var4_4, File.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)var2_2[314].call(var4_4))) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        if (v0) {
            properties = null;
            if (ConfigEncryptionTool.__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                var6_6 = var2_2[316].call(var2_2[317].callStatic(ConfigEncryptionTool.class, (Object)existingKeyHex), (Object)niFiPropertiesFile);
                properties = (NiFiProperties)ScriptBytecodeAdapter.castToType((Object)var6_6, NiFiProperties.class);
            } else {
                var7_7 = var2_2[318].call((Object)ConfigEncryptionTool.getNiFiPropertiesLoader(existingKeyHex), (Object)niFiPropertiesFile);
                properties = (NiFiProperties)ScriptBytecodeAdapter.castToType((Object)var7_7, NiFiProperties.class);
            }
            var2_2[319].call((Object)ConfigEncryptionTool.logger, (Object)new GStringImpl(new Object[]{var2_2[320].call((Object)properties)}, new String[]{"Loaded NiFiProperties instance with ", " properties"}));
            var8_8 = properties;
            try {
                return var8_8;
            }
            catch (RuntimeException e) {
                if (this.isVerbose) {
                    var2_2[321].call((Object)ConfigEncryptionTool.logger, (Object)"Encountered an error", (Object)e);
                }
                throw (Throwable)var2_2[322].callConstructor(IOException.class, (Object)new GStringImpl(new Object[]{this.niFiPropertiesPath}, new String[]{"Cannot load NiFiProperties from [", "]"}), (Object)e);
            }
        }
        return (NiFiProperties)ScriptBytecodeAdapter.castToType((Object)var2_2[323].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{this.niFiPropertiesPath}, new String[]{"Cannot load NiFiProperties from [", "]"}), var2_2[324].callGetProperty(ExitCode.class)), NiFiProperties.class);
    }

    /*
     * Unable to fully structure code
     */
    private String loadLoginIdentityProviders(String existingKeyHex) throws IOException {
        var2_2 = ConfigEncryptionTool.$getCallSiteArray();
        loginIdentityProvidersFile = null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.loginIdentityProvidersPath)) ** GOTO lbl-1000
        var4_4 = var2_2[326].callConstructor(File.class, (Object)this.loginIdentityProvidersPath);
        loginIdentityProvidersFile = (File)ScriptBytecodeAdapter.castToType((Object)var4_4, File.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)var2_2[325].call(var4_4))) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        if (v0) {
            lines = (List)ScriptBytecodeAdapter.castToType((Object)var2_2[327].call(loginIdentityProvidersFile), List.class);
            xmlContent = ShortTypeHandling.castToString((Object)var2_2[328].call((Object)lines, (Object)"\n"));
            var2_2[329].call((Object)ConfigEncryptionTool.logger, (Object)new GStringImpl(new Object[]{var2_2[330].call((Object)lines)}, new String[]{"Loaded login identity providers content (", " lines)"}));
            decryptedXmlContent = null;
            if (ConfigEncryptionTool.__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                var8_8 = var2_2[331].callCurrent((GroovyObject)this, (Object)xmlContent, (Object)existingKeyHex);
                decryptedXmlContent = ShortTypeHandling.castToString((Object)var8_8);
            } else {
                decryptedXmlContent = var9_9 = this.decryptLoginIdentityProviders(xmlContent, existingKeyHex);
            }
            var10_10 = decryptedXmlContent;
            try {
                return var10_10;
            }
            catch (RuntimeException e) {
                if (this.isVerbose) {
                    var2_2[332].call((Object)ConfigEncryptionTool.logger, (Object)"Encountered an error", (Object)e);
                }
                throw (Throwable)var2_2[333].callConstructor(IOException.class, (Object)new GStringImpl(new Object[]{this.loginIdentityProvidersPath}, new String[]{"Cannot load login identity providers from [", "]"}), (Object)e);
            }
        }
        return ShortTypeHandling.castToString((Object)var2_2[334].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{this.loginIdentityProvidersPath}, new String[]{"Cannot load login identity providers from [", "]"}), var2_2[335].callGetProperty(ExitCode.class)));
    }

    /*
     * Unable to fully structure code
     */
    private String loadAuthorizers(String existingKeyHex) throws IOException {
        var2_2 = ConfigEncryptionTool.$getCallSiteArray();
        authorizersFile = null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.authorizersPath)) ** GOTO lbl-1000
        var4_4 = var2_2[337].callConstructor(File.class, (Object)this.authorizersPath);
        authorizersFile = (File)ScriptBytecodeAdapter.castToType((Object)var4_4, File.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)var2_2[336].call(var4_4))) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        if (v0) {
            lines = (List)ScriptBytecodeAdapter.castToType((Object)var2_2[338].call(authorizersFile), List.class);
            xmlContent = ShortTypeHandling.castToString((Object)var2_2[339].call((Object)lines, (Object)"\n"));
            var2_2[340].call((Object)ConfigEncryptionTool.logger, (Object)new GStringImpl(new Object[]{var2_2[341].call((Object)lines)}, new String[]{"Loaded authorizers content (", " lines)"}));
            decryptedXmlContent = null;
            if (ConfigEncryptionTool.__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                var8_8 = var2_2[342].callCurrent((GroovyObject)this, (Object)xmlContent, (Object)existingKeyHex);
                decryptedXmlContent = ShortTypeHandling.castToString((Object)var8_8);
            } else {
                decryptedXmlContent = var9_9 = this.decryptAuthorizers(xmlContent, existingKeyHex);
            }
            var10_10 = decryptedXmlContent;
            try {
                return var10_10;
            }
            catch (RuntimeException e) {
                if (this.isVerbose) {
                    var2_2[343].call((Object)ConfigEncryptionTool.logger, (Object)"Encountered an error", (Object)e);
                }
                throw (Throwable)var2_2[344].callConstructor(IOException.class, (Object)new GStringImpl(new Object[]{this.authorizersPath}, new String[]{"Cannot load authorizers from [", "]"}), (Object)e);
            }
        }
        return ShortTypeHandling.castToString((Object)var2_2[345].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{this.authorizersPath}, new String[]{"Cannot load authorizers from [", "]"}), var2_2[346].callGetProperty(ExitCode.class)));
    }

    /*
     * Loose catch block
     */
    private InputStream loadFlowXml(String filePath) throws IOException {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)filePath) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[347].call(callSiteArray[348].callConstructor(File.class, (Object)filePath)))) {
            InputStream inputStream = (InputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[349].callConstructor(GZIPInputStream.class, callSiteArray[350].callConstructor(FileInputStream.class, (Object)filePath)), InputStream.class);
            try {
                return inputStream;
            }
            catch (ZipException e) {
                callSiteArray[351].call((Object)logger, (Object)"GZIP Compression not found: {}", callSiteArray[352].call((Object)e));
                InputStream inputStream2 = (InputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[353].callConstructor(FileInputStream.class, (Object)filePath), InputStream.class);
                return inputStream2;
            }
            catch (RuntimeException e2) {
                if (this.isVerbose) {
                    callSiteArray[354].call((Object)logger, (Object)"Encountered an error", (Object)e2);
                }
                throw (Throwable)callSiteArray[355].callConstructor(IOException.class, (Object)new GStringImpl(new Object[]{filePath}, new String[]{"Cannot load flow from [", "]"}), (Object)e2);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        return (InputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[356].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{filePath}, new String[]{"Cannot load flow from [", "]"}), callSiteArray[357].callGetProperty(ExitCode.class)), InputStream.class);
    }

    private InputStream migrateFlowXmlContent(InputStream flowXmlContent, String existingFlowPassword, String newFlowPassword, String existingAlgorithm, String newAlgorithm) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        File tempFlowXmlFile = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[358].callConstructor(File.class, callSiteArray[359].call(callSiteArray[360].callStatic(ConfigEncryptionTool.class, (Object)this.outputFlowXmlPath)));
            tempFlowXmlFile = (File)ScriptBytecodeAdapter.castToType((Object)object, File.class);
        } else {
            Object object = callSiteArray[361].callConstructor(File.class, callSiteArray[362].call((Object)ConfigEncryptionTool.getTemporaryFlowXmlFile(this.outputFlowXmlPath)));
            tempFlowXmlFile = (File)ScriptBytecodeAdapter.castToType((Object)object, File.class);
        }
        OutputStream flowOutputStream = (OutputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[363].callStatic(ConfigEncryptionTool.class, (Object)tempFlowXmlFile, (Object)(flowXmlContent instanceof GZIPInputStream)), OutputStream.class);
        NiFiProperties inputProperties = (NiFiProperties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[364].call(NiFiProperties.class, (Object)"", (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{callSiteArray[365].callGetProperty(NiFiProperties.class), existingFlowPassword, callSiteArray[366].callGetProperty(NiFiProperties.class), existingAlgorithm})), NiFiProperties.class);
        NiFiProperties outputProperties = (NiFiProperties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[367].call(NiFiProperties.class, (Object)"", (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{callSiteArray[368].callGetProperty(NiFiProperties.class), newFlowPassword, callSiteArray[369].callGetProperty(NiFiProperties.class), newAlgorithm})), NiFiProperties.class);
        PropertyEncryptor inputEncryptor = (PropertyEncryptor)ScriptBytecodeAdapter.castToType((Object)callSiteArray[370].call(PropertyEncryptorFactory.class, (Object)inputProperties), PropertyEncryptor.class);
        PropertyEncryptor outputEncryptor = (PropertyEncryptor)ScriptBytecodeAdapter.castToType((Object)callSiteArray[371].call(PropertyEncryptorFactory.class, (Object)outputProperties), PropertyEncryptor.class);
        FlowEncryptor flowEncryptor = (FlowEncryptor)ScriptBytecodeAdapter.castToType((Object)callSiteArray[372].callConstructor(StandardFlowEncryptor.class), FlowEncryptor.class);
        callSiteArray[373].call((Object)flowEncryptor, (Object)flowXmlContent, (Object)flowOutputStream, (Object)inputEncryptor, (Object)outputEncryptor);
        callSiteArray[374].call(Files.class, callSiteArray[375].call((Object)tempFlowXmlFile), callSiteArray[376].call(Paths.class, (Object)this.outputFlowXmlPath), callSiteArray[377].callGetProperty(StandardCopyOption.class));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (InputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[378].callCurrent((GroovyObject)this, (Object)this.outputFlowXmlPath), InputStream.class);
        }
        return this.loadFlowXml(this.outputFlowXmlPath);
    }

    private static OutputStream getFlowOutputStream(File outputFlowXmlPath, boolean isFileGZipped) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        OutputStream flowOutputStream = (OutputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[379].callConstructor(FileOutputStream.class, (Object)outputFlowXmlPath), OutputStream.class);
        if (isFileGZipped) {
            Object object = callSiteArray[380].callConstructor(GZIPOutputStream.class, (Object)flowOutputStream);
            flowOutputStream = (OutputStream)ScriptBytecodeAdapter.castToType((Object)object, OutputStream.class);
        }
        return flowOutputStream;
    }

    private static Path getTemporaryFlowXmlFile(String originalOutputFlowXmlPath) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        String outputFilename = ShortTypeHandling.castToString((Object)callSiteArray[381].call(callSiteArray[382].call(callSiteArray[383].call(Paths.class, (Object)originalOutputFlowXmlPath))));
        String migratedFileName = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{outputFilename}, new String[]{"migrated-", ""}));
        return (Path)ScriptBytecodeAdapter.castToType((Object)callSiteArray[384].call(callSiteArray[385].call(Paths.class, (Object)originalOutputFlowXmlPath), (Object)migratedFileName), Path.class);
    }

    private SensitivePropertyProviderFactory getSensitivePropertyProviderFactory(String keyHex) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (SensitivePropertyProviderFactory)ScriptBytecodeAdapter.castToType((Object)callSiteArray[386].call(StandardSensitivePropertyProviderFactory.class, (Object)keyHex, callSiteArray[387].callStatic(ConfigEncryptionTool.class, (Object)this.bootstrapConfPath)), SensitivePropertyProviderFactory.class);
        }
        return (SensitivePropertyProviderFactory)ScriptBytecodeAdapter.castToType((Object)callSiteArray[388].call(StandardSensitivePropertyProviderFactory.class, (Object)keyHex, ConfigEncryptionTool.getBootstrapSupplier(this.bootstrapConfPath)), SensitivePropertyProviderFactory.class);
    }

    /*
     * Unable to fully structure code
     */
    public String decryptLoginIdentityProviders(String encryptedXml, String existingKeyHex) {
        var3_3 = ConfigEncryptionTool.$getCallSiteArray();
        providerFactory = new Reference(null);
        if (ConfigEncryptionTool.__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            var5_5 = var3_3[389].callCurrent((GroovyObject)this, (Object)existingKeyHex);
            providerFactory.set((Object)((SensitivePropertyProviderFactory)ScriptBytecodeAdapter.castToType((Object)var5_5, SensitivePropertyProviderFactory.class)));
        } else {
            var6_6 = this.getSensitivePropertyProviderFactory(existingKeyHex);
            providerFactory.set((Object)var6_6);
        }
        doc = null;
        doc = ConfigEncryptionTool.__$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (var8_8 = var3_3[390].call(var3_3[391].callStatic(ConfigEncryptionTool.class), (Object)encryptedXml)) : (var9_9 = var3_3[392].call((Object)ConfigEncryptionTool.getXmlSlurper(), (Object)encryptedXml));
        provider = var3_3[393].call(var3_3[394].callGetProperty(doc), (Object)new _decryptLoginIdentityProviders_closure2(this, this));
        groupIdentifier = new Reference((Object)ShortTypeHandling.castToString((Object)var3_3[395].call(var3_3[396].callGetProperty(provider))));
        passwords = var3_3[397].call(var3_3[398].callGetProperty(provider), (Object)new _decryptLoginIdentityProviders_closure3(this, this));
        if (!DefaultTypeTransformation.booleanUnbox((Object)var3_3[399].call(passwords))) ** GOTO lbl30
        if (this.isVerbose) {
            var3_3[400].call((Object)ConfigEncryptionTool.logger, (Object)"No encrypted password property elements found in login-identity-providers.xml");
        }
        var13_13 = encryptedXml;
        return var13_13;
lbl30:
        // 1 sources

        var3_3[401].call(passwords, (Object)new _decryptLoginIdentityProviders_closure4(this, this, providerFactory, groupIdentifier));
        updatedXml = ShortTypeHandling.castToString((Object)var3_3[402].call(XmlUtil.class, doc));
        var3_3[403].call((Object)ConfigEncryptionTool.logger, (Object)new GStringImpl(new Object[]{updatedXml}, new String[]{"Updated XML content: ", ""}));
        var15_15 = updatedXml;
        try {
            return var15_15;
        }
        catch (Exception e) {
            if (this.isVerbose) {
                var3_3[404].call((Object)ConfigEncryptionTool.logger, (Object)"Processing XML failed", (Object)e);
            }
            var17_17 = ShortTypeHandling.castToString((Object)var3_3[405].callCurrent((GroovyObject)this, (Object)"Cannot decrypt login identity providers XML content", var3_3[406].callGetProperty(ExitCode.class)));
            return var17_17;
        }
    }

    /*
     * Unable to fully structure code
     */
    public String decryptAuthorizers(String encryptedXml, String existingKeyHex) {
        var3_3 = ConfigEncryptionTool.$getCallSiteArray();
        providerFactory = new Reference(null);
        if (ConfigEncryptionTool.__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            var5_5 = var3_3[407].callCurrent((GroovyObject)this, (Object)existingKeyHex);
            providerFactory.set((Object)((SensitivePropertyProviderFactory)ScriptBytecodeAdapter.castToType((Object)var5_5, SensitivePropertyProviderFactory.class)));
        } else {
            var6_6 = this.getSensitivePropertyProviderFactory(existingKeyHex);
            providerFactory.set((Object)var6_6);
        }
        filename = "authorizers.xml";
        doc = null;
        doc = ConfigEncryptionTool.__$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (var9_9 = var3_3[408].call(var3_3[409].callStatic(ConfigEncryptionTool.class), (Object)encryptedXml)) : (var10_10 = var3_3[410].call((Object)ConfigEncryptionTool.getXmlSlurper(), (Object)encryptedXml));
        userGroupProvider = var3_3[411].call(var3_3[412].callGetProperty(doc), (Object)new _decryptAuthorizers_closure5(this, this));
        groupIdentifier = new Reference((Object)ShortTypeHandling.castToString((Object)var3_3[413].call(var3_3[414].callGetProperty(userGroupProvider))));
        passwords = var3_3[415].call(var3_3[416].callGetProperty(userGroupProvider), (Object)new _decryptAuthorizers_closure6(this, this));
        if (!DefaultTypeTransformation.booleanUnbox((Object)var3_3[417].call(passwords))) ** GOTO lbl32
        if (this.isVerbose) {
            var3_3[418].call((Object)ConfigEncryptionTool.logger, (Object)new GStringImpl(new Object[]{filename}, new String[]{"No encrypted password property elements found in ", ""}));
        }
        var14_14 = encryptedXml;
        return var14_14;
lbl32:
        // 1 sources

        var3_3[419].call(passwords, (Object)new _decryptAuthorizers_closure7(this, this, providerFactory, groupIdentifier));
        updatedXml = ShortTypeHandling.castToString((Object)var3_3[420].call(XmlUtil.class, doc));
        if (this.isVerbose) {
            var3_3[421].call((Object)ConfigEncryptionTool.logger, (Object)new GStringImpl(new Object[]{updatedXml}, new String[]{"Updated XML content: ", ""}));
        }
        var16_16 = updatedXml;
        try {
            return var16_16;
        }
        catch (Exception e) {
            if (this.isVerbose) {
                var3_3[422].call((Object)ConfigEncryptionTool.logger, (Object)"Processor Authorizers failed", (Object)e);
            }
            var18_18 = ShortTypeHandling.castToString((Object)var3_3[423].callCurrent((GroovyObject)this, (Object)"Cannot decrypt authorizers XML content", var3_3[424].callGetProperty(ExitCode.class)));
            return var18_18;
        }
    }

    public static ProtectedPropertyContext getContext(SensitivePropertyProviderFactory providerFactory, String propertyName, String groupIdentifier) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return (ProtectedPropertyContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[425].call((Object)providerFactory, (Object)groupIdentifier, (Object)propertyName), ProtectedPropertyContext.class);
    }

    /*
     * Unable to fully structure code
     */
    public String encryptLoginIdentityProviders(String plainXml, String newKeyHex) {
        var3_3 = ConfigEncryptionTool.$getCallSiteArray();
        providerFactory = new Reference(null);
        if (ConfigEncryptionTool.__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            var5_5 = var3_3[426].callCurrent((GroovyObject)this, (Object)newKeyHex);
            providerFactory.set((Object)((SensitivePropertyProviderFactory)ScriptBytecodeAdapter.castToType((Object)var5_5, SensitivePropertyProviderFactory.class)));
        } else {
            var6_6 = this.getSensitivePropertyProviderFactory(newKeyHex);
            providerFactory.set((Object)var6_6);
        }
        doc = null;
        doc = ConfigEncryptionTool.__$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (var8_8 = var3_3[427].call(var3_3[428].callStatic(ConfigEncryptionTool.class), (Object)plainXml)) : (var9_9 = var3_3[429].call((Object)ConfigEncryptionTool.getXmlSlurper(), (Object)plainXml));
        provider = var3_3[430].call(var3_3[431].callGetProperty(doc), (Object)new _encryptLoginIdentityProviders_closure8(this, this));
        groupIdentifier = new Reference((Object)ShortTypeHandling.castToString((Object)var3_3[432].call(var3_3[433].callGetProperty(provider))));
        passwords = var3_3[434].call(var3_3[435].callGetProperty(provider), (Object)new _encryptLoginIdentityProviders_closure9(this, this));
        if (!DefaultTypeTransformation.booleanUnbox((Object)var3_3[436].call(passwords))) ** GOTO lbl30
        if (this.isVerbose) {
            var3_3[437].call((Object)ConfigEncryptionTool.logger, (Object)"No unencrypted password property elements found in login-identity-providers.xml");
        }
        var13_13 = plainXml;
        return var13_13;
lbl30:
        // 1 sources

        sensitivePropertyProvider = new Reference((Object)((SensitivePropertyProvider)ScriptBytecodeAdapter.castToType((Object)var3_3[438].call((Object)((SensitivePropertyProviderFactory)providerFactory.get()), (Object)this.protectionScheme), SensitivePropertyProvider.class)));
        var3_3[439].call(passwords, (Object)new _encryptLoginIdentityProviders_closure10(this, this, providerFactory, groupIdentifier, sensitivePropertyProvider));
        updatedXml = ShortTypeHandling.castToString((Object)var3_3[440].call(XmlUtil.class, doc));
        var3_3[441].call((Object)ConfigEncryptionTool.logger, (Object)new GStringImpl(new Object[]{updatedXml}, new String[]{"Updated XML content: ", ""}));
        var16_16 = updatedXml;
        try {
            return var16_16;
        }
        catch (Exception e) {
            if (this.isVerbose) {
                var3_3[442].call((Object)ConfigEncryptionTool.logger, (Object)"Encountered exception", (Object)e);
            }
            var18_18 = ShortTypeHandling.castToString((Object)var3_3[443].callCurrent((GroovyObject)this, (Object)"Cannot encrypt login identity providers XML content", var3_3[444].callGetProperty(ExitCode.class)));
            return var18_18;
        }
    }

    /*
     * Unable to fully structure code
     */
    public String encryptAuthorizers(String plainXml, String newKeyHex) {
        var3_3 = ConfigEncryptionTool.$getCallSiteArray();
        providerFactory = new Reference(null);
        if (ConfigEncryptionTool.__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            var5_5 = var3_3[445].callCurrent((GroovyObject)this, (Object)newKeyHex);
            providerFactory.set((Object)((SensitivePropertyProviderFactory)ScriptBytecodeAdapter.castToType((Object)var5_5, SensitivePropertyProviderFactory.class)));
        } else {
            var6_6 = this.getSensitivePropertyProviderFactory(newKeyHex);
            providerFactory.set((Object)var6_6);
        }
        filename = "authorizers.xml";
        doc = null;
        doc = ConfigEncryptionTool.__$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (var9_9 = var3_3[446].call(var3_3[447].callStatic(ConfigEncryptionTool.class), (Object)plainXml)) : (var10_10 = var3_3[448].call((Object)ConfigEncryptionTool.getXmlSlurper(), (Object)plainXml));
        userGroupProvider = var3_3[449].call(var3_3[450].callGetProperty(doc), (Object)new _encryptAuthorizers_closure11(this, this));
        groupIdentifier = new Reference((Object)ShortTypeHandling.castToString((Object)var3_3[451].call(var3_3[452].callGetProperty(userGroupProvider))));
        passwords = var3_3[453].call(var3_3[454].callGetProperty(userGroupProvider), (Object)new _encryptAuthorizers_closure12(this, this));
        if (!DefaultTypeTransformation.booleanUnbox((Object)var3_3[455].call(passwords))) ** GOTO lbl32
        if (this.isVerbose) {
            var3_3[456].call((Object)ConfigEncryptionTool.logger, (Object)new GStringImpl(new Object[]{filename}, new String[]{"No unencrypted password property elements found in ", ""}));
        }
        var14_14 = plainXml;
        return var14_14;
lbl32:
        // 1 sources

        sensitivePropertyProvider = new Reference((Object)((SensitivePropertyProvider)ScriptBytecodeAdapter.castToType((Object)var3_3[457].call((Object)((SensitivePropertyProviderFactory)providerFactory.get()), (Object)this.protectionScheme), SensitivePropertyProvider.class)));
        var3_3[458].call(passwords, (Object)new _encryptAuthorizers_closure13(this, this, providerFactory, groupIdentifier, sensitivePropertyProvider));
        updatedXml = ShortTypeHandling.castToString((Object)var3_3[459].call(XmlUtil.class, doc));
        if (this.isVerbose) {
            var3_3[460].call((Object)ConfigEncryptionTool.logger, (Object)new GStringImpl(new Object[]{updatedXml}, new String[]{"Updated XML content: ", ""}));
        }
        var17_17 = updatedXml;
        try {
            return var17_17;
        }
        catch (Exception e) {
            if (this.isVerbose) {
                var3_3[461].call((Object)ConfigEncryptionTool.logger, (Object)"Encountered exception", (Object)e);
            }
            var19_19 = ShortTypeHandling.castToString((Object)var3_3[462].callCurrent((GroovyObject)this, (Object)"Cannot encrypt authorizers XML content", var3_3[463].callGetProperty(ExitCode.class)));
            return var19_19;
        }
    }

    private NiFiProperties encryptSensitiveProperties(NiFiProperties plainProperties) {
        Reference plainProperties2 = new Reference((Object)plainProperties);
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)((NiFiProperties)plainProperties2.get()))) {
            throw (Throwable)callSiteArray[464].callConstructor(IllegalArgumentException.class, (Object)"Cannot encrypt empty NiFiProperties");
        }
        ProtectedNiFiProperties protectedWrapper = (ProtectedNiFiProperties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[465].callConstructor((Object)ConfigEncryptionTool.$get$$class$org$apache$nifi$properties$ProtectedNiFiProperties(), (Object)((NiFiProperties)plainProperties2.get())), (Class)ConfigEncryptionTool.$get$$class$org$apache$nifi$properties$ProtectedNiFiProperties());
        List sensitivePropertyKeys = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[466].call((Object)protectedWrapper), List.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[467].call((Object)sensitivePropertyKeys))) {
            callSiteArray[468].call((Object)logger, (Object)"No sensitive properties to encrypt");
            return (NiFiProperties)plainProperties2.get();
        }
        Reference encryptedProperties = new Reference((Object)((Properties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[469].callConstructor(Properties.class), Properties.class)));
        SensitivePropertyProviderFactory sensitivePropertyProviderFactory = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[470].callCurrent((GroovyObject)this, (Object)this.keyHex);
            sensitivePropertyProviderFactory = (SensitivePropertyProviderFactory)ScriptBytecodeAdapter.castToType((Object)object, SensitivePropertyProviderFactory.class);
        } else {
            SensitivePropertyProviderFactory sensitivePropertyProviderFactory2;
            sensitivePropertyProviderFactory = sensitivePropertyProviderFactory2 = this.getSensitivePropertyProviderFactory(this.keyHex);
        }
        Reference spp = new Reference((Object)((SensitivePropertyProvider)ScriptBytecodeAdapter.castToType((Object)callSiteArray[471].call((Object)sensitivePropertyProviderFactory, (Object)this.protectionScheme), SensitivePropertyProvider.class)));
        callSiteArray[472].call((Object)protectedWrapper, (Object)((SensitivePropertyProvider)spp.get()));
        Reference keysToSkip = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _encryptSensitiveProperties_closure14
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference plainProperties;
            private /* synthetic */ Reference spp;
            private /* synthetic */ Reference encryptedProperties;
            private /* synthetic */ Reference keysToSkip;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _encryptSensitiveProperties_closure14(Object _outerInstance, Object _thisObject, Reference plainProperties, Reference spp, Reference encryptedProperties, Reference keysToSkip) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                CallSite[] callSiteArray = _encryptSensitiveProperties_closure14.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.plainProperties = reference4 = plainProperties;
                this.spp = reference3 = spp;
                this.encryptedProperties = reference2 = encryptedProperties;
                this.keysToSkip = reference = keysToSkip;
            }

            public Object doCall(String key) {
                CallSite[] callSiteArray = _encryptSensitiveProperties_closure14.$getCallSiteArray();
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(this.plainProperties.get(), (Object)key))) {
                    return callSiteArray[1].call(ScriptBytecodeAdapter.getField(_encryptSensitiveProperties_closure14.class, ConfigEncryptionTool.class, (String)"logger"), (Object)new GStringImpl(new Object[]{key}, new String[]{"Skipping encryption of [", "] because it is empty"}));
                }
                String protectedValue = ShortTypeHandling.castToString((Object)callSiteArray[2].call(this.spp.get(), callSiteArray[3].call(this.plainProperties.get(), (Object)key), callSiteArray[4].call(ProtectedPropertyContext.class, (Object)key)));
                callSiteArray[5].call(this.encryptedProperties.get(), (Object)key, (Object)protectedValue);
                callSiteArray[6].call(ScriptBytecodeAdapter.getField(_encryptSensitiveProperties_closure14.class, ConfigEncryptionTool.class, (String)"logger"), (Object)new GStringImpl(new Object[]{key, callSiteArray[7].callGetProperty(callSiteArray[8].callGroovyObjectGetProperty((Object)this)), protectedValue}, new String[]{"Protected [", "] using [", "] -> \t", ""}));
                String protectionKey = ShortTypeHandling.castToString((Object)callSiteArray[9].call(ApplicationPropertiesProtector.class, (Object)key));
                callSiteArray[10].call(this.encryptedProperties.get(), (Object)protectionKey, callSiteArray[11].call(this.spp.get()));
                callSiteArray[12].call(ScriptBytecodeAdapter.getField(_encryptSensitiveProperties_closure14.class, ConfigEncryptionTool.class, (String)"logger"), (Object)new GStringImpl(new Object[]{protectionKey}, new String[]{"Updated protection key [", "]"}));
                return callSiteArray[13].call(callSiteArray[14].call(this.keysToSkip.get(), (Object)key), (Object)protectionKey);
            }

            @Generated
            public Object call(String key) {
                CallSite[] callSiteArray = _encryptSensitiveProperties_closure14.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[15].callCurrent((GroovyObject)this, (Object)key);
                }
                return this.doCall(key);
            }

            @Generated
            public NiFiProperties getPlainProperties() {
                CallSite[] callSiteArray = _encryptSensitiveProperties_closure14.$getCallSiteArray();
                return (NiFiProperties)ScriptBytecodeAdapter.castToType((Object)this.plainProperties.get(), NiFiProperties.class);
            }

            @Generated
            public SensitivePropertyProvider getSpp() {
                CallSite[] callSiteArray = _encryptSensitiveProperties_closure14.$getCallSiteArray();
                return (SensitivePropertyProvider)ScriptBytecodeAdapter.castToType((Object)this.spp.get(), SensitivePropertyProvider.class);
            }

            @Generated
            public Properties getEncryptedProperties() {
                CallSite[] callSiteArray = _encryptSensitiveProperties_closure14.$getCallSiteArray();
                return (Properties)ScriptBytecodeAdapter.castToType((Object)this.encryptedProperties.get(), Properties.class);
            }

            @Generated
            public List getKeysToSkip() {
                CallSite[] callSiteArray = _encryptSensitiveProperties_closure14.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.keysToSkip.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _encryptSensitiveProperties_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getProperty";
                stringArray[1] = "debug";
                stringArray[2] = "protect";
                stringArray[3] = "getProperty";
                stringArray[4] = "defaultContext";
                stringArray[5] = "setProperty";
                stringArray[6] = "info";
                stringArray[7] = "path";
                stringArray[8] = ConfigEncryptionTool.PROTECTION_SCHEME_ARG;
                stringArray[9] = "getProtectionKey";
                stringArray[10] = "setProperty";
                stringArray[11] = "getIdentifierKey";
                stringArray[12] = "info";
                stringArray[13] = "leftShift";
                stringArray[14] = "leftShift";
                stringArray[15] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[16];
                _encryptSensitiveProperties_closure14.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_encryptSensitiveProperties_closure14.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _encryptSensitiveProperties_closure14.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[473].call((Object)sensitivePropertyKeys, (Object)new _encryptSensitiveProperties_closure14(this, this, plainProperties2, spp, encryptedProperties, keysToSkip));
        Set nonSensitiveKeys = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[474].call(callSiteArray[475].call((Object)((NiFiProperties)plainProperties2.get())), (Object)((List)keysToSkip.get())), Set.class);
        public final class _encryptSensitiveProperties_closure15
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference encryptedProperties;
            private /* synthetic */ Reference plainProperties;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _encryptSensitiveProperties_closure15(Object _outerInstance, Object _thisObject, Reference encryptedProperties, Reference plainProperties) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _encryptSensitiveProperties_closure15.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.encryptedProperties = reference2 = encryptedProperties;
                this.plainProperties = reference = plainProperties;
            }

            public Object doCall(String key) {
                CallSite[] callSiteArray = _encryptSensitiveProperties_closure15.$getCallSiteArray();
                return callSiteArray[0].call(this.encryptedProperties.get(), (Object)key, callSiteArray[1].call(this.plainProperties.get(), (Object)key));
            }

            @Generated
            public Object call(String key) {
                CallSite[] callSiteArray = _encryptSensitiveProperties_closure15.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[2].callCurrent((GroovyObject)this, (Object)key);
                }
                return this.doCall(key);
            }

            @Generated
            public Properties getEncryptedProperties() {
                CallSite[] callSiteArray = _encryptSensitiveProperties_closure15.$getCallSiteArray();
                return (Properties)ScriptBytecodeAdapter.castToType((Object)this.encryptedProperties.get(), Properties.class);
            }

            @Generated
            public NiFiProperties getPlainProperties() {
                CallSite[] callSiteArray = _encryptSensitiveProperties_closure15.$getCallSiteArray();
                return (NiFiProperties)ScriptBytecodeAdapter.castToType((Object)this.plainProperties.get(), NiFiProperties.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _encryptSensitiveProperties_closure15.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "setProperty";
                stringArray[1] = "getProperty";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _encryptSensitiveProperties_closure15.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_encryptSensitiveProperties_closure15.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _encryptSensitiveProperties_closure15.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[476].call((Object)nonSensitiveKeys, (Object)new _encryptSensitiveProperties_closure15(this, this, encryptedProperties, plainProperties2));
        NiFiProperties mergedProperties = (NiFiProperties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[477].callConstructor(NiFiProperties.class, (Object)((Properties)encryptedProperties.get())), NiFiProperties.class);
        callSiteArray[478].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[479].call((Object)mergedProperties), callSiteArray[480].call((Object)ConfigEncryptionTool.$get$$class$org$apache$nifi$properties$ProtectedNiFiProperties(), (Object)mergedProperties)}, new String[]{"Final result: ", " keys including ", " protected keys"}));
        return mergedProperties;
    }

    public static String serializeXMLFragment(GPathResult gPathResult) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[481].call(callSiteArray[482].call(XmlUtil.class, (Object)gPathResult), (Object)XML_DECLARATION_REGEX, (Object)""));
    }

    /*
     * Unable to fully structure code
     */
    private void writeKeyToBootstrapConf() throws IOException {
        block7: {
            var1_1 = ConfigEncryptionTool.$getCallSiteArray();
            bootstrapConfFile = null;
            if (!DefaultTypeTransformation.booleanUnbox((Object)this.bootstrapConfPath)) ** GOTO lbl-1000
            var3_3 = var1_1[484].callConstructor(File.class, (Object)this.bootstrapConfPath);
            bootstrapConfFile = (File)ScriptBytecodeAdapter.castToType((Object)var3_3, File.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[483].call(var3_3))) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            if ((v0 != false && DefaultTypeTransformation.booleanUnbox((Object)var1_1[485].call(bootstrapConfFile)) != false) != false && DefaultTypeTransformation.booleanUnbox((Object)var1_1[486].call(bootstrapConfFile)) != false) {
                try {
                    lines = (List)ScriptBytecodeAdapter.castToType((Object)var1_1[487].call(bootstrapConfFile), List.class);
                    var1_1[488].callCurrent((GroovyObject)this, (Object)lines);
                    var5_5 = var1_1[489].call((Object)lines, (Object)"\n");
                    ScriptBytecodeAdapter.setProperty((Object)var5_5, null, (Object)bootstrapConfFile, (String)"text");
                    break block7;
                }
                catch (IOException e) {
                    msg = "Encountered an exception updating the bootstrap.conf file with the root key";
                    var1_1[490].call((Object)ConfigEncryptionTool.logger, (Object)msg, (Object)e);
                    throw (Throwable)e;
                }
            }
            throw (Throwable)var1_1[491].callConstructor(IOException.class, (Object)new GStringImpl(new Object[]{this.bootstrapConfPath}, new String[]{"The bootstrap.conf file at ", " must exist and be readable and writable by the user running this tool"}));
        }
    }

    private List<String> updateBootstrapContentsWithKey(List<String> lines) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        String keyLine = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{BOOTSTRAP_KEY_PREFIX, this.keyHex}, new String[]{"", "", ""}));
        public final class _updateBootstrapContentsWithKey_closure16
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updateBootstrapContentsWithKey_closure16(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _updateBootstrapContentsWithKey_closure16.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _updateBootstrapContentsWithKey_closure16.$getCallSiteArray();
                return callSiteArray[0].call(it, ScriptBytecodeAdapter.getField(_updateBootstrapContentsWithKey_closure16.class, ConfigEncryptionTool.class, (String)"BOOTSTRAP_KEY_PREFIX"));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _updateBootstrapContentsWithKey_closure16.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateBootstrapContentsWithKey_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "startsWith";
                return new CallSiteArray(_updateBootstrapContentsWithKey_closure16.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateBootstrapContentsWithKey_closure16.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        int keyLineIndex = DefaultTypeTransformation.intUnbox((Object)callSiteArray[492].call(lines, (Object)new _updateBootstrapContentsWithKey_closure16(this, this)));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)keyLineIndex, (Object)-1)) {
            int n;
            int n2;
            callSiteArray[493].call((Object)logger, (Object)"The key property was detected in bootstrap.conf");
            String string = keyLine;
            callSiteArray[494].call(lines, (Object)keyLineIndex, (Object)string);
            callSiteArray[495].call((Object)logger, (Object)"The bootstrap key value was updated");
            int keyCommentLineIndex = 0;
            keyCommentLineIndex = !BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (n2 = keyLineIndex > 0 ? DefaultTypeTransformation.intUnbox((Object)callSiteArray[496].call((Object)keyLineIndex, (Object)1)) : 0) : (n = keyLineIndex > 0 ? keyLineIndex - 1 : 0);
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[497].call(lines, (Object)keyCommentLineIndex), (Object)BOOTSTRAP_KEY_COMMENT)) {
                callSiteArray[498].call(lines, (Object)keyCommentLineIndex, (Object)BOOTSTRAP_KEY_COMMENT);
                callSiteArray[499].call((Object)logger, (Object)"A comment explaining the bootstrap key property was added");
            }
        } else {
            callSiteArray[500].call(lines, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"\n", BOOTSTRAP_KEY_COMMENT, keyLine}));
            callSiteArray[501].call((Object)logger, (Object)"The key property was not detected in bootstrap.conf so it was added along with a comment explaining it");
        }
        return lines;
    }

    private void writeLoginIdentityProviders() throws IOException {
        block8: {
            CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
            if (!DefaultTypeTransformation.booleanUnbox((Object)this.outputLoginIdentityProvidersPath)) {
                throw (Throwable)callSiteArray[502].callConstructor(IllegalArgumentException.class, (Object)"Cannot write encrypted properties to empty login-identity-providers.xml path");
            }
            File outputLoginIdentityProvidersFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[503].callConstructor(File.class, (Object)this.outputLoginIdentityProvidersPath), File.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[504].callStatic(ConfigEncryptionTool.class, (Object)outputLoginIdentityProvidersFile))) {
                try {
                    String updatedXmlContent = null;
                    File loginIdentityProvidersFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[505].callConstructor(File.class, (Object)this.loginIdentityProvidersPath), File.class);
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[506].call((Object)loginIdentityProvidersFile)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[507].call((Object)loginIdentityProvidersFile))) {
                        Object object = callSiteArray[508].call(callSiteArray[509].callStatic(ConfigEncryptionTool.class, (Object)this.loginIdentityProviders, (Object)loginIdentityProvidersFile), (Object)"\n");
                        updatedXmlContent = ShortTypeHandling.castToString((Object)object);
                    } else {
                        String string;
                        updatedXmlContent = string = this.loginIdentityProviders;
                    }
                    String string = updatedXmlContent;
                    ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)outputLoginIdentityProvidersFile, (String)"text");
                    break block8;
                }
                catch (IOException e) {
                    String msg = "Encountered an exception updating the login-identity-providers.xml file with the encrypted values";
                    callSiteArray[510].call((Object)logger, (Object)msg, (Object)e);
                    throw (Throwable)e;
                }
            }
            throw (Throwable)callSiteArray[511].callConstructor(IOException.class, (Object)new GStringImpl(new Object[]{this.outputLoginIdentityProvidersPath}, new String[]{"The login-identity-providers.xml file at ", " must be writable by the user running this tool"}));
        }
    }

    private void writeAuthorizers() throws IOException {
        block8: {
            CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
            if (!DefaultTypeTransformation.booleanUnbox((Object)this.outputAuthorizersPath)) {
                throw (Throwable)callSiteArray[512].callConstructor(IllegalArgumentException.class, (Object)"Cannot write encrypted properties to empty authorizers.xml path");
            }
            File outputAuthorizersFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[513].callConstructor(File.class, (Object)this.outputAuthorizersPath), File.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[514].callStatic(ConfigEncryptionTool.class, (Object)outputAuthorizersFile))) {
                try {
                    String updatedXmlContent = null;
                    File authorizersFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[515].callConstructor(File.class, (Object)this.authorizersPath), File.class);
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[516].call((Object)authorizersFile)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[517].call((Object)authorizersFile))) {
                        Object object = callSiteArray[518].call(callSiteArray[519].callStatic(ConfigEncryptionTool.class, (Object)this.authorizers, (Object)authorizersFile), (Object)"\n");
                        updatedXmlContent = ShortTypeHandling.castToString((Object)object);
                    } else {
                        String string;
                        updatedXmlContent = string = this.authorizers;
                    }
                    String string = updatedXmlContent;
                    ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)outputAuthorizersFile, (String)"text");
                    break block8;
                }
                catch (IOException e) {
                    String msg = "Encountered an exception updating the authorizers.xml file with the encrypted values";
                    callSiteArray[520].call((Object)logger, (Object)msg, (Object)e);
                    throw (Throwable)e;
                }
            }
            throw (Throwable)callSiteArray[521].callConstructor(IOException.class, (Object)new GStringImpl(new Object[]{this.outputAuthorizersPath}, new String[]{"The authorizers.xml file at ", " must be writable by the user running this tool"}));
        }
    }

    private void writeNiFiProperties() throws IOException {
        block8: {
            CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
            if (!DefaultTypeTransformation.booleanUnbox((Object)this.outputNiFiPropertiesPath)) {
                throw (Throwable)callSiteArray[522].callConstructor(IllegalArgumentException.class, (Object)"Cannot write encrypted properties to empty nifi.properties path");
            }
            File outputNiFiPropertiesFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[523].callConstructor(File.class, (Object)this.outputNiFiPropertiesPath), File.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[524].callStatic(ConfigEncryptionTool.class, (Object)outputNiFiPropertiesFile))) {
                try {
                    List linesToPersist = null;
                    File niFiPropertiesFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[525].callConstructor(File.class, (Object)this.niFiPropertiesPath), File.class);
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[526].call((Object)niFiPropertiesFile)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[527].call((Object)niFiPropertiesFile))) {
                        Object object = callSiteArray[528].callStatic(ConfigEncryptionTool.class, (Object)this.niFiProperties, (Object)niFiPropertiesFile);
                        linesToPersist = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
                    } else {
                        Object object = callSiteArray[529].callStatic(ConfigEncryptionTool.class, (Object)this.niFiProperties);
                        linesToPersist = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
                    }
                    Object object = callSiteArray[530].call((Object)linesToPersist, (Object)"\n");
                    ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)outputNiFiPropertiesFile, (String)"text");
                    break block8;
                }
                catch (IOException e) {
                    String msg = "Encountered an exception updating the nifi.properties file with the encrypted values";
                    callSiteArray[531].call((Object)logger, (Object)msg, (Object)e);
                    throw (Throwable)e;
                }
            }
            throw (Throwable)callSiteArray[532].callConstructor(IOException.class, (Object)new GStringImpl(new Object[]{this.outputNiFiPropertiesPath}, new String[]{"The nifi.properties file at ", " must be writable by the user running this tool"}));
        }
    }

    private static List<String> serializeNiFiPropertiesAndPreserveFormat(NiFiProperties niFiProperties, File originalPropertiesFile) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        Reference lines = new Reference((Object)((List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[533].call((Object)originalPropertiesFile), List.class)));
        Reference protectedNiFiProperties = new Reference((Object)((ProtectedNiFiProperties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[534].callConstructor((Object)ConfigEncryptionTool.$get$$class$org$apache$nifi$properties$ProtectedNiFiProperties(), (Object)niFiProperties), (Class)ConfigEncryptionTool.$get$$class$org$apache$nifi$properties$ProtectedNiFiProperties())));
        Map protectedKeys = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[535].call((Object)((ProtectedNiFiProperties)protectedNiFiProperties.get())), Map.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[536].call((Object)protectedKeys, callSiteArray[537].callGetProperty(NiFiProperties.class)))) {
            callSiteArray[538].call((Object)protectedKeys, callSiteArray[539].callGetProperty(NiFiProperties.class), callSiteArray[540].call((Object)((ProtectedNiFiProperties)protectedNiFiProperties.get()), callSiteArray[541].call(ApplicationPropertiesProtector.class, callSiteArray[542].callGetProperty(NiFiProperties.class))));
        }
        public final class _serializeNiFiPropertiesAndPreserveFormat_closure17
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference lines;
            private /* synthetic */ Reference protectedNiFiProperties;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            private static /* synthetic */ Class $class$org$apache$nifi$properties$ProtectedNiFiProperties;

            public _serializeNiFiPropertiesAndPreserveFormat_closure17(Object _outerInstance, Object _thisObject, Reference lines, Reference protectedNiFiProperties) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _serializeNiFiPropertiesAndPreserveFormat_closure17.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.lines = reference2 = lines;
                this.protectedNiFiProperties = reference = protectedNiFiProperties;
            }

            public Object doCall(String key, String protectionScheme) {
                Reference key2 = new Reference((Object)key);
                CallSite[] callSiteArray = _serializeNiFiPropertiesAndPreserveFormat_closure17.$getCallSiteArray();
                public final class _closure28
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference key;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure28(Object _outerInstance, Object _thisObject, Reference key) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure28.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.key = reference = key;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure28.$getCallSiteArray();
                        return callSiteArray[0].call(it, this.key.get());
                    }

                    @Generated
                    public String getKey() {
                        CallSite[] callSiteArray = _closure28.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.key.get());
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure28.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure28.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "startsWith";
                        return new CallSiteArray(_closure28.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure28.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                int l = DefaultTypeTransformation.intUnbox((Object)callSiteArray[0].call(this.lines.get(), (Object)new _closure28((Object)this, this.getThisObject(), key2)));
                if (ScriptBytecodeAdapter.compareNotEqual((Object)l, (Object)-1)) {
                    GStringImpl gStringImpl = new GStringImpl(new Object[]{(String)key2.get(), callSiteArray[1].call(this.protectedNiFiProperties.get(), (Object)((String)key2.get()))}, new String[]{"", "=", ""});
                    callSiteArray[2].call(this.lines.get(), (Object)l, (Object)gStringImpl);
                }
                int p = 0;
                if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    Object object = ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[3].call((Object)l, (Object)1), (Object)callSiteArray[4].call(this.lines.get())) ? callSiteArray[5].call(this.lines.get()) : callSiteArray[6].call((Object)l, (Object)1);
                    p = DefaultTypeTransformation.intUnbox((Object)object);
                } else {
                    Integer n = ScriptBytecodeAdapter.compareGreaterThan((Object)(l + 1), (Object)callSiteArray[7].call(this.lines.get())) ? callSiteArray[8].call(this.lines.get()) : Integer.valueOf(l + 1);
                    p = DefaultTypeTransformation.intUnbox((Object)n);
                }
                Object[] objectArray = new Object[2];
                objectArray[0] = callSiteArray[9].call(ApplicationPropertiesProtector.class, (Object)((String)key2.get()));
                String string = protectionScheme;
                objectArray[1] = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "";
                String protectionLine = ShortTypeHandling.castToString((Object)new GStringImpl(objectArray, new String[]{"", "=", ""}));
                if (ScriptBytecodeAdapter.compareLessThan((Object)p, (Object)callSiteArray[10].call(this.lines.get())) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[11].call(callSiteArray[12].call(this.lines.get(), (Object)p), (Object)new GStringImpl(new Object[]{callSiteArray[13].call(ApplicationPropertiesProtector.class, (Object)((String)key2.get()))}, new String[]{"", "="})))) {
                    return callSiteArray[14].call(this.lines.get(), (Object)p, (Object)protectionLine);
                }
                return callSiteArray[15].call(this.lines.get(), (Object)p, (Object)protectionLine);
            }

            @Generated
            public Object call(String key, String protectionScheme) {
                Reference key2 = new Reference((Object)key);
                CallSite[] callSiteArray = _serializeNiFiPropertiesAndPreserveFormat_closure17.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[16].callCurrent((GroovyObject)this, (Object)((String)key2.get()), (Object)protectionScheme);
                }
                return this.doCall((String)key2.get(), protectionScheme);
            }

            @Generated
            public List getLines() {
                CallSite[] callSiteArray = _serializeNiFiPropertiesAndPreserveFormat_closure17.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.lines.get(), List.class);
            }

            @Generated
            public ProtectedNiFiProperties getProtectedNiFiProperties() {
                CallSite[] callSiteArray = _serializeNiFiPropertiesAndPreserveFormat_closure17.$getCallSiteArray();
                return (ProtectedNiFiProperties)ScriptBytecodeAdapter.castToType((Object)this.protectedNiFiProperties.get(), (Class)_serializeNiFiPropertiesAndPreserveFormat_closure17.$get$$class$org$apache$nifi$properties$ProtectedNiFiProperties());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _serializeNiFiPropertiesAndPreserveFormat_closure17.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "findIndexOf";
                stringArray[1] = "getProperty";
                stringArray[2] = "putAt";
                stringArray[3] = "plus";
                stringArray[4] = "size";
                stringArray[5] = "size";
                stringArray[6] = "plus";
                stringArray[7] = "size";
                stringArray[8] = "size";
                stringArray[9] = "getProtectionKey";
                stringArray[10] = "size";
                stringArray[11] = "startsWith";
                stringArray[12] = "get";
                stringArray[13] = "getProtectionKey";
                stringArray[14] = "set";
                stringArray[15] = "add";
                stringArray[16] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[17];
                _serializeNiFiPropertiesAndPreserveFormat_closure17.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_serializeNiFiPropertiesAndPreserveFormat_closure17.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _serializeNiFiPropertiesAndPreserveFormat_closure17.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            private static /* synthetic */ Class $get$$class$org$apache$nifi$properties$ProtectedNiFiProperties() {
                Class clazz = $class$org$apache$nifi$properties$ProtectedNiFiProperties;
                if (clazz == null) {
                    clazz = $class$org$apache$nifi$properties$ProtectedNiFiProperties = _serializeNiFiPropertiesAndPreserveFormat_closure17.class$("org.apache.nifi.properties.ProtectedNiFiProperties");
                }
                return clazz;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }
        callSiteArray[543].call((Object)protectedKeys, (Object)new _serializeNiFiPropertiesAndPreserveFormat_closure17(ConfigEncryptionTool.class, ConfigEncryptionTool.class, lines, protectedNiFiProperties));
        return (List)lines.get();
    }

    private static List<String> serializeNiFiProperties(NiFiProperties nifiProperties) {
        Reference nifiProperties2 = new Reference((Object)nifiProperties);
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        OutputStream out = (OutputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[544].callConstructor(ByteArrayOutputStream.class), OutputStream.class);
        Writer writer = (Writer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[545].callConstructor(GroovyPrintWriter.class, (Object)out), Writer.class);
        Reference properties = new Reference((Object)((Properties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[546].callConstructor(Properties.class), Properties.class)));
        public final class _serializeNiFiProperties_closure18
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference properties;
            private /* synthetic */ Reference nifiProperties;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _serializeNiFiProperties_closure18(Object _outerInstance, Object _thisObject, Reference properties, Reference nifiProperties) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _serializeNiFiProperties_closure18.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.properties = reference2 = properties;
                this.nifiProperties = reference = nifiProperties;
            }

            public Object doCall(String key) {
                CallSite[] callSiteArray = _serializeNiFiProperties_closure18.$getCallSiteArray();
                return callSiteArray[0].call(this.properties.get(), (Object)key, callSiteArray[1].call(this.nifiProperties.get(), (Object)key));
            }

            @Generated
            public Object call(String key) {
                CallSite[] callSiteArray = _serializeNiFiProperties_closure18.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[2].callCurrent((GroovyObject)this, (Object)key);
                }
                return this.doCall(key);
            }

            @Generated
            public Properties getProperties() {
                CallSite[] callSiteArray = _serializeNiFiProperties_closure18.$getCallSiteArray();
                return (Properties)ScriptBytecodeAdapter.castToType((Object)this.properties.get(), Properties.class);
            }

            @Generated
            public NiFiProperties getNifiProperties() {
                CallSite[] callSiteArray = _serializeNiFiProperties_closure18.$getCallSiteArray();
                return (NiFiProperties)ScriptBytecodeAdapter.castToType((Object)this.nifiProperties.get(), NiFiProperties.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _serializeNiFiProperties_closure18.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "setProperty";
                stringArray[1] = "getProperty";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _serializeNiFiProperties_closure18.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_serializeNiFiProperties_closure18.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _serializeNiFiProperties_closure18.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[547].call(callSiteArray[548].call((Object)((NiFiProperties)nifiProperties2.get())), (Object)new _serializeNiFiProperties_closure18(ConfigEncryptionTool.class, ConfigEncryptionTool.class, properties, nifiProperties2));
        callSiteArray[549].call((Object)((Properties)properties.get()), (Object)writer, null);
        callSiteArray[550].call((Object)writer);
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[551].call(callSiteArray[552].call((Object)out), (Object)"\n"), List.class);
    }

    public static List<String> serializeLoginIdentityProvidersAndPreserveFormat(String xmlContent, File originalLoginIdentityProvidersFile) {
        String fileContents;
        CallSite[] callSiteArray;
        block7: {
            Object object;
            Object object2;
            callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
            fileContents = ShortTypeHandling.castToString((Object)callSiteArray[553].callGetProperty((Object)originalLoginIdentityProvidersFile));
            Object parsedXml = null;
            parsedXml = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[554].call(callSiteArray[555].callStatic(ConfigEncryptionTool.class), (Object)xmlContent)) : (object = callSiteArray[556].call((Object)ConfigEncryptionTool.getXmlSlurper(), (Object)xmlContent));
            public final class _serializeLoginIdentityProvidersAndPreserveFormat_closure19
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _serializeLoginIdentityProvidersAndPreserveFormat_closure19(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _serializeLoginIdentityProvidersAndPreserveFormat_closure19.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _serializeLoginIdentityProvidersAndPreserveFormat_closure19.$getCallSiteArray();
                    return ScriptBytecodeAdapter.compareEqual((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[0].callGetProperty(it), String.class)), (Object)ScriptBytecodeAdapter.getField(_serializeLoginIdentityProvidersAndPreserveFormat_closure19.class, ConfigEncryptionTool.class, (String)"LDAP_PROVIDER_CLASS"));
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _serializeLoginIdentityProvidersAndPreserveFormat_closure19.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _serializeLoginIdentityProvidersAndPreserveFormat_closure19.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "class";
                    return new CallSiteArray(_serializeLoginIdentityProvidersAndPreserveFormat_closure19.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _serializeLoginIdentityProvidersAndPreserveFormat_closure19.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Object provider = callSiteArray[557].call(callSiteArray[558].callGetProperty(parsedXml), (Object)new _serializeLoginIdentityProvidersAndPreserveFormat_closure19(ConfigEncryptionTool.class, ConfigEncryptionTool.class));
            if (!DefaultTypeTransformation.booleanUnbox((Object)provider)) break block7;
            Object serializedProvider = callSiteArray[559].callStatic(ConfigEncryptionTool.class, provider);
            Object object3 = callSiteArray[560].call((Object)fileContents, (Object)LDAP_PROVIDER_REGEX, callSiteArray[561].call(Matcher.class, serializedProvider));
            fileContents = ShortTypeHandling.castToString((Object)object3);
            List list = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[562].call((Object)fileContents, (Object)"\n"), List.class);
            return list;
        }
        try {
            throw (Throwable)callSiteArray[563].callConstructor(SAXException.class, (Object)"No ldap-provider element found");
        }
        catch (SAXException e) {
            callSiteArray[564].call((Object)logger, callSiteArray[565].call((Object)"No provider element with class {} found in XML content; ", (Object)"the file could be empty or the element may be missing or commented out: {}"), (Object)LDAP_PROVIDER_CLASS, callSiteArray[566].call((Object)e));
            List list = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[567].call((Object)fileContents, (Object)"\n"), List.class);
            return list;
        }
    }

    public static List<String> serializeAuthorizersAndPreserveFormat(String xmlContent, File originalAuthorizersFile) {
        Object object;
        Object object2;
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        String fileContents = ShortTypeHandling.castToString((Object)callSiteArray[568].callGetProperty((Object)originalAuthorizersFile));
        Object parsedXml = null;
        parsedXml = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[569].call(callSiteArray[570].callStatic(ConfigEncryptionTool.class), (Object)xmlContent)) : (object = callSiteArray[571].call((Object)ConfigEncryptionTool.getXmlSlurper(), (Object)xmlContent));
        Object object3 = callSiteArray[572].callStatic(ConfigEncryptionTool.class, (Object)fileContents, parsedXml, (Object)LDAP_USER_GROUP_PROVIDER_CLASS, (Object)LDAP_USER_GROUP_PROVIDER_REGEX);
        fileContents = ShortTypeHandling.castToString((Object)object3);
        Object object4 = callSiteArray[573].callStatic(ConfigEncryptionTool.class, (Object)fileContents, parsedXml, (Object)AZURE_USER_GROUP_PROVIDER_CLASS, (Object)AZURE_USER_GROUP_PROVIDER_REGEX);
        fileContents = ShortTypeHandling.castToString((Object)object4);
        List list = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[574].call((Object)fileContents, (Object)"\n"), List.class);
        try {
            return list;
        }
        catch (SAXException e) {
            callSiteArray[575].call((Object)logger, (Object)"Returning original file contents.", callSiteArray[576].call((Object)e));
            List list2 = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[577].call(callSiteArray[578].callGetProperty((Object)originalAuthorizersFile), (Object)"\n"), List.class);
            return list2;
        }
    }

    private static String serializeProvider(String fileContents, NodeChild parsedXml, String providerClass, String providerRegex) {
        Reference providerClass2 = new Reference((Object)providerClass);
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        public final class _serializeProvider_closure20
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference providerClass;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _serializeProvider_closure20(Object _outerInstance, Object _thisObject, Reference providerClass) {
                Reference reference;
                CallSite[] callSiteArray = _serializeProvider_closure20.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.providerClass = reference = providerClass;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _serializeProvider_closure20.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[0].callGetProperty(it), String.class)), (Object)this.providerClass.get());
            }

            @Generated
            public String getProviderClass() {
                CallSite[] callSiteArray = _serializeProvider_closure20.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.providerClass.get());
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _serializeProvider_closure20.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _serializeProvider_closure20.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "class";
                return new CallSiteArray(_serializeProvider_closure20.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _serializeProvider_closure20.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object provider = callSiteArray[579].call(callSiteArray[580].callGroovyObjectGetProperty((Object)parsedXml), (Object)new _serializeProvider_closure20(ConfigEncryptionTool.class, ConfigEncryptionTool.class, providerClass2));
        if (DefaultTypeTransformation.booleanUnbox((Object)provider)) {
            Object serializedProvider = callSiteArray[581].callStatic(ConfigEncryptionTool.class, provider);
            return ShortTypeHandling.castToString((Object)callSiteArray[582].call((Object)fileContents, (Object)providerRegex, callSiteArray[583].call(Matcher.class, serializedProvider)));
        }
        return fileContents;
    }

    private static boolean isSafeToWrite(File fileToWrite) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return DefaultTypeTransformation.booleanUnbox((Object)fileToWrite) && (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[584].call((Object)fileToWrite)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[585].call(callSiteArray[586].callGetProperty(callSiteArray[587].callGetProperty((Object)fileToWrite)))) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[588].call((Object)fileToWrite)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[589].call((Object)fileToWrite)));
        }
        return DefaultTypeTransformation.booleanUnbox((Object)fileToWrite) && (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[590].call((Object)fileToWrite)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[591].call(callSiteArray[592].callGetProperty(callSiteArray[593].callGetProperty((Object)fileToWrite)))) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[594].call((Object)fileToWrite)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[595].call((Object)fileToWrite)));
    }

    private static String deriveKeyFromPassword(String password) {
        int n;
        int n2;
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        Object object = callSiteArray[596].callSafe((Object)password);
        password = ShortTypeHandling.castToString((Object)object);
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)password) || ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[597].call((Object)password), (Object)MIN_PASSWORD_LENGTH)) {
                throw (Throwable)callSiteArray[598].callConstructor(KeyException.class, (Object)new GStringImpl(new Object[]{MIN_PASSWORD_LENGTH}, new String[]{"Cannot derive key from empty/short password -- password must be at least ", " characters"}));
            }
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)password) || ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[599].call((Object)password), (Object)MIN_PASSWORD_LENGTH)) {
            throw (Throwable)callSiteArray[600].callConstructor(KeyException.class, (Object)new GStringImpl(new Object[]{MIN_PASSWORD_LENGTH}, new String[]{"Cannot derive key from empty/short password -- password must be at least ", " characters"}));
        }
        byte[] salt = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object2 = callSiteArray[601].callStatic(ConfigEncryptionTool.class);
            salt = (byte[])ScriptBytecodeAdapter.castToType((Object)object2, byte[].class);
        } else {
            byte[] byArray;
            salt = byArray = ConfigEncryptionTool.generateScryptSaltForKeyDerivation();
        }
        int keyLengthInBytes = 0;
        keyLengthInBytes = !BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (n2 = DefaultTypeTransformation.intUnbox((Object)callSiteArray[602].call(callSiteArray[603].call(callSiteArray[604].callStatic(ConfigEncryptionTool.class)), (Object)8))) : (n = DefaultTypeTransformation.intUnbox((Object)callSiteArray[605].call(callSiteArray[606].call(ConfigEncryptionTool.getValidKeyLengths()), (Object)8)));
        byte[] derivedKeyBytes = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[607].call(SCrypt.class, ArrayUtil.createArray((Object)callSiteArray[608].call((Object)password, callSiteArray[609].callGetProperty(StandardCharsets.class)), (Object)salt, (Object)SCRYPT_N, (Object)SCRYPT_R, (Object)SCRYPT_P, (Object)keyLengthInBytes)), byte[].class);
        return ShortTypeHandling.castToString((Object)callSiteArray[610].call(callSiteArray[611].call(Hex.class, (Object)derivedKeyBytes)));
    }

    private static byte[] generateScryptSaltForKeyDerivation() {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[612].call((Object)"NIFI_SCRYPT_SALT", callSiteArray[613].callGetProperty(StandardCharsets.class)), byte[].class);
    }

    private String getExistingFlowPassword() {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        String string = (String)ScriptBytecodeAdapter.asType((Object)callSiteArray[614].call((Object)this.niFiProperties, callSiteArray[615].callGetProperty(NiFiProperties.class)), String.class);
        return DefaultTypeTransformation.booleanUnbox((Object)string) ? string : DEFAULT_NIFI_SENSITIVE_PROPS_KEY;
    }

    /*
     * Loose catch block
     */
    public boolean niFiPropertiesAreEncrypted() {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)this.niFiPropertiesPath)) {
            Object object;
            Object object2;
            Object nfp = null;
            nfp = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[616].call(callSiteArray[617].callStatic(ConfigEncryptionTool.class, (Object)this.keyHex), callSiteArray[618].callConstructor(File.class, (Object)this.niFiPropertiesPath))) : (object = callSiteArray[619].call((Object)ConfigEncryptionTool.getNiFiPropertiesLoader(this.keyHex), callSiteArray[620].callConstructor(File.class, (Object)this.niFiPropertiesPath)));
            boolean bl = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[621].call(nfp));
            try {
                return bl;
            }
            catch (SensitivePropertyProtectionException e) {
                callSiteArray[622].call((Object)logger, (Object)"Read Protected Properties failed {}", callSiteArray[623].call((Object)e));
                boolean bl2 = true;
                return bl2;
            }
            catch (IOException e2) {
                callSiteArray[624].call((Object)logger, (Object)"Read Protected Properties failed {}", callSiteArray[625].call((Object)e2));
                boolean bl3 = true;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                return bl3;
            }
        }
        return false;
    }

    public static XmlSlurper getXmlSlurper() {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        XmlSlurper xs = (XmlSlurper)ScriptBytecodeAdapter.castToType((Object)callSiteArray[626].callConstructor(XmlSlurper.class), XmlSlurper.class);
        callSiteArray[627].call((Object)xs, (Object)true);
        return xs;
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String ... args) {
        var1_1 = ConfigEncryptionTool.$getCallSiteArray();
        var1_1[628].call(Security.class, var1_1[629].callConstructor(BouncyCastleProvider.class));
        tool = (ConfigEncryptionTool)ScriptBytecodeAdapter.castToType((Object)var1_1[630].callConstructor(ConfigEncryptionTool.class), ConfigEncryptionTool.class);
        try {
            var1_1[631].call((Object)tool, (Object)args);
            if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[632].callGroovyObjectGetProperty((Object)tool))) {
                if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[633].callGroovyObjectGetProperty((Object)tool))) {
                    var3_3 = var1_1[634].call(NiFiBootstrapUtils.class, var1_1[635].callGroovyObjectGetProperty((Object)tool));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)var3_3, ConfigEncryptionTool.class, (GroovyObject)tool, (String)"keyHex");
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[636].callGroovyObjectGetProperty((Object)tool)) == false) {
                    var1_1[637].call((Object)ConfigEncryptionTool.logger, (Object)new GStringImpl(new Object[]{var1_1[638].callGroovyObjectGetProperty((Object)tool), var1_1[639].callGroovyObjectGetProperty((Object)tool)}, new String[]{"No root key detected in ", " -- if ", " is encrypted, the translation will fail"}));
                }
                var4_4 = var1_1[640].call((Object)tool, var1_1[641].callGroovyObjectGetProperty((Object)tool));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)var4_4, ConfigEncryptionTool.class, (GroovyObject)tool, (String)"niFiProperties");
                cliOutput = ShortTypeHandling.castToString((Object)var1_1[642].call((Object)tool));
                var1_1[643].call(var1_1[644].callGetProperty(System.class), (Object)cliOutput);
                var1_1[645].call(System.class, var1_1[646].call(var1_1[647].callGetProperty(ExitCode.class)));
            }
            existingNiFiPropertiesAreEncrypted = DefaultTypeTransformation.booleanUnbox((Object)var1_1[648].call((Object)tool));
            if (!BytecodeInterface8.isOrigZ() || ConfigEncryptionTool.__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[649].callGroovyObjectGetProperty((Object)tool)) == false != false || (DefaultTypeTransformation.booleanUnbox((Object)var1_1[650].callGroovyObjectGetProperty((Object)tool)) != false && existingNiFiPropertiesAreEncrypted != false) != false) {
                    if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[651].callGroovyObjectGetProperty((Object)tool))) {
                        var7_7 = var1_1[652].call(NiFiBootstrapUtils.class, var1_1[653].callGroovyObjectGetProperty((Object)tool));
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)var7_7, ConfigEncryptionTool.class, (GroovyObject)tool, (String)"keyHex");
                    } else {
                        var8_8 = var1_1[654].call((Object)tool);
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)var8_8, ConfigEncryptionTool.class, (GroovyObject)tool, (String)"keyHex");
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[655].callGroovyObjectGetProperty((Object)tool)) == false) {
                        var1_1[656].call((Object)tool, (Object)"Hex key must be provided", var1_1[657].callGetProperty(ExitCode.class));
                    }
                    try {
                        var9_9 = var1_1[658].callStatic(ConfigEncryptionTool.class, var1_1[659].callGroovyObjectGetProperty((Object)tool));
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)var9_9, ConfigEncryptionTool.class, (GroovyObject)tool, (String)"keyHex");
                    }
                    catch (KeyException e) {
                        if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[660].callGroovyObjectGetProperty((Object)tool))) {
                            var1_1[661].call((Object)ConfigEncryptionTool.logger, (Object)"Encountered an error", (Object)e);
                        }
                        var1_1[662].call((Object)tool, var1_1[663].call((Object)e), var1_1[664].callGetProperty(ExitCode.class));
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[665].callGroovyObjectGetProperty((Object)tool))) {
                        migrationKeyHex = ShortTypeHandling.castToString((Object)var1_1[666].call((Object)tool));
                        if (DefaultTypeTransformation.booleanUnbox((Object)migrationKeyHex)) {
                            try {
                                var13_13 = var1_1[667].callStatic(ConfigEncryptionTool.class, (Object)migrationKeyHex);
                                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)var13_13, ConfigEncryptionTool.class, (GroovyObject)tool, (String)"migrationKeyHex");
                            }
                            catch (KeyException e) {
                                if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[668].callGroovyObjectGetProperty((Object)tool))) {
                                    var1_1[669].call((Object)ConfigEncryptionTool.logger, (Object)"Encountered an error", (Object)e);
                                }
                                var1_1[670].call((Object)tool, var1_1[671].call((Object)e), var1_1[672].callGetProperty(ExitCode.class));
                            }
                        }
                    }
                }
            } else if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[673].callGroovyObjectGetProperty((Object)tool)) == false != false || (DefaultTypeTransformation.booleanUnbox((Object)var1_1[674].callGroovyObjectGetProperty((Object)tool)) != false && existingNiFiPropertiesAreEncrypted != false) != false) {
                if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[675].callGroovyObjectGetProperty((Object)tool))) {
                    var16_16 = var1_1[676].call(NiFiBootstrapUtils.class, var1_1[677].callGroovyObjectGetProperty((Object)tool));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)var16_16, ConfigEncryptionTool.class, (GroovyObject)tool, (String)"keyHex");
                } else {
                    var17_17 = var1_1[678].call((Object)tool);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)var17_17, ConfigEncryptionTool.class, (GroovyObject)tool, (String)"keyHex");
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[679].callGroovyObjectGetProperty((Object)tool)) == false) {
                    var1_1[680].call((Object)tool, (Object)"Hex key must be provided", var1_1[681].callGetProperty(ExitCode.class));
                }
                try {
                    var18_18 = var1_1[682].callStatic(ConfigEncryptionTool.class, var1_1[683].callGroovyObjectGetProperty((Object)tool));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)var18_18, ConfigEncryptionTool.class, (GroovyObject)tool, (String)"keyHex");
                }
                catch (KeyException e) {
                    if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[684].callGroovyObjectGetProperty((Object)tool))) {
                        var1_1[685].call((Object)ConfigEncryptionTool.logger, (Object)"Encountered an error", (Object)e);
                    }
                    var1_1[686].call((Object)tool, var1_1[687].call((Object)e), var1_1[688].callGetProperty(ExitCode.class));
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[689].callGroovyObjectGetProperty((Object)tool))) {
                    migrationKeyHex = ShortTypeHandling.castToString((Object)var1_1[690].call((Object)tool));
                    if (DefaultTypeTransformation.booleanUnbox((Object)migrationKeyHex)) {
                        try {
                            var22_22 = ConfigEncryptionTool.parseKey(migrationKeyHex);
                            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)var22_22, ConfigEncryptionTool.class, (GroovyObject)tool, (String)"migrationKeyHex");
                        }
                        catch (KeyException e) {
                            if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[691].callGroovyObjectGetProperty((Object)tool))) {
                                var1_1[692].call((Object)ConfigEncryptionTool.logger, (Object)"Encountered an error", (Object)e);
                            }
                            var1_1[693].call((Object)tool, var1_1[694].call((Object)e), var1_1[695].callGetProperty(ExitCode.class));
                        }
                    }
                }
            }
            existingKeyHex = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)(var25_25 = var1_1[696].callGroovyObjectGetProperty((Object)tool))) != false ? var25_25 : var1_1[697].callGroovyObjectGetProperty((Object)tool)));
            if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[698].callGroovyObjectGetProperty((Object)tool)) != false || DefaultTypeTransformation.booleanUnbox((Object)var1_1[699].callGroovyObjectGetProperty((Object)tool)) != false) {
                try {
                    var27_27 = var1_1[700].call((Object)tool, (Object)existingKeyHex);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)var27_27, ConfigEncryptionTool.class, (GroovyObject)tool, (String)"niFiProperties");
                }
                catch (Exception e) {
                    var1_1[701].call((Object)ConfigEncryptionTool.logger, (Object)"Load Properties failed", (Object)e);
                    var1_1[702].call((Object)tool, (Object)"Cannot migrate key if no previous encryption occurred", var1_1[703].callGetProperty(ExitCode.class));
                }
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[704].callGroovyObjectGetProperty((Object)tool))) {
                try {
                    var30_30 = var1_1[705].call((Object)tool, (Object)existingKeyHex);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)var30_30, ConfigEncryptionTool.class, (GroovyObject)tool, (String)"loginIdentityProviders");
                }
                catch (Exception e) {
                    var1_1[706].call((Object)ConfigEncryptionTool.logger, (Object)"Load Login Identify Providers failed", (Object)e);
                    var1_1[707].call((Object)tool, (Object)"Cannot migrate key if no previous encryption occurred", var1_1[708].callGetProperty(ExitCode.class));
                }
                var33_33 = var1_1[709].call((Object)tool, var1_1[710].callGroovyObjectGetProperty((Object)tool));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)var33_33, ConfigEncryptionTool.class, (GroovyObject)tool, (String)"loginIdentityProviders");
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[711].callGroovyObjectGetProperty((Object)tool))) {
                try {
                    var34_34 = var1_1[712].call((Object)tool, (Object)existingKeyHex);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)var34_34, ConfigEncryptionTool.class, (GroovyObject)tool, (String)"authorizers");
                }
                catch (Exception e) {
                    var1_1[713].call((Object)ConfigEncryptionTool.logger, (Object)"Load Authorizers failed", (Object)e);
                    var1_1[714].call((Object)tool, (Object)"Cannot migrate key if no previous encryption occurred", var1_1[715].callGetProperty(ExitCode.class));
                }
                var37_37 = var1_1[716].call((Object)tool, var1_1[717].callGroovyObjectGetProperty((Object)tool));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)var37_37, ConfigEncryptionTool.class, (GroovyObject)tool, (String)"authorizers");
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[718].callGroovyObjectGetProperty((Object)tool))) {
                try {
                    var38_38 = var1_1[719].call((Object)tool, ConfigEncryptionTool.flowXmlPath);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)var38_38, ConfigEncryptionTool.class, (GroovyObject)tool, (String)"flowXmlInputStream");
                }
                catch (Exception e) {
                    if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[720].callGroovyObjectGetProperty((Object)tool))) {
                        var1_1[721].call((Object)ConfigEncryptionTool.logger, (Object)"Encountered an error: ", (Object)e);
                    }
                    var1_1[722].call((Object)tool, (Object)"Cannot load flow.xml.gz", var1_1[723].callGetProperty(ExitCode.class));
                }
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[724].callGroovyObjectGetProperty((Object)tool))) {
                var41_41 = var1_1[725].call((Object)tool);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)var41_41, ConfigEncryptionTool.class, (GroovyObject)tool, (String)"existingFlowPropertiesPassword");
                var42_42 = var1_1[726].call((Object)tool, var1_1[727].callGroovyObjectGetProperty((Object)tool));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)var42_42, ConfigEncryptionTool.class, (GroovyObject)tool, (String)"niFiProperties");
            }
            ** GOTO lbl229
        }
        catch (CommandLineParseException e) {
            if (ScriptBytecodeAdapter.compareEqual((Object)var1_1[728].callGetProperty((Object)e), (Object)var1_1[729].callGetProperty(ExitCode.class))) {
                var1_1[730].call(System.class, var1_1[731].call(var1_1[732].callGetProperty(ExitCode.class)));
            }
            throw (Throwable)e;
        }
        catch (Exception e) {
            try {
                if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[733].callGroovyObjectGetProperty((Object)tool))) {
                    var1_1[734].call((Object)ConfigEncryptionTool.logger, (Object)"Encountered an error", (Object)e);
                }
                var1_1[735].call((Object)tool, var1_1[736].callGetProperty((Object)e), var1_1[737].callGetProperty(ExitCode.class));
lbl229:
                // 3 sources

                try {
                    var46_46 = ConfigEncryptionTool.class;
                    synchronized (var46_46) {
                        if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[738].callGroovyObjectGetProperty((Object)tool)) == false) {
                            var1_1[739].call((Object)tool);
                        }
                        if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[740].callGroovyObjectGetProperty((Object)tool))) {
                            var1_1[741].call((Object)tool, var1_1[742].call((Object)tool));
                        }
                        if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[743].callGroovyObjectGetProperty((Object)tool)) != false || DefaultTypeTransformation.booleanUnbox((Object)var1_1[744].callGroovyObjectGetProperty((Object)tool)) != false) {
                            var1_1[745].call((Object)tool);
                        }
                        if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[746].callGroovyObjectGetProperty((Object)tool))) {
                            var1_1[747].call((Object)tool);
                        }
                        if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[748].callGroovyObjectGetProperty((Object)tool))) {
                            var1_1[749].call((Object)tool);
                        }
                    }
                }
                catch (Exception e) {
                    if (DefaultTypeTransformation.booleanUnbox((Object)var1_1[750].callGroovyObjectGetProperty((Object)tool))) {
                        var1_1[751].call((Object)ConfigEncryptionTool.logger, (Object)"Encountered an error", (Object)e);
                    }
                    var1_1[752].call((Object)tool, (Object)"Encountered an error writing the root key to the bootstrap.conf file and the encrypted properties to nifi.properties", var1_1[753].callGetProperty(ExitCode.class));
                }
            }
            catch (CommandLineParseException e) {
                var1_1[754].call(System.class, var1_1[755].call(var1_1[756].callGetProperty((Object)e)));
            }
        }
        var1_1[757].call(System.class, var1_1[758].call(var1_1[759].callGetProperty(ExitCode.class)));
    }

    public void handleFlowXml(boolean existingNiFiPropertiesAreEncrypted) {
        public final class _handleFlowXml_closure21
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference rawProperties;
            private /* synthetic */ Reference nfp;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _handleFlowXml_closure21(Object _outerInstance, Object _thisObject, Reference rawProperties, Reference nfp) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _handleFlowXml_closure21.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.rawProperties = reference2 = rawProperties;
                this.nfp = reference = nfp;
            }

            public Object doCall(String k) {
                CallSite[] callSiteArray = _handleFlowXml_closure21.$getCallSiteArray();
                return callSiteArray[0].call(this.rawProperties.get(), (Object)k, callSiteArray[1].call(this.nfp.get(), (Object)k));
            }

            @Generated
            public Object call(String k) {
                CallSite[] callSiteArray = _handleFlowXml_closure21.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[2].callCurrent((GroovyObject)this, (Object)k);
                }
                return this.doCall(k);
            }

            @Generated
            public Properties getRawProperties() {
                CallSite[] callSiteArray = _handleFlowXml_closure21.$getCallSiteArray();
                return (Properties)ScriptBytecodeAdapter.castToType((Object)this.rawProperties.get(), Properties.class);
            }

            @Generated
            public NiFiProperties getNfp() {
                CallSite[] callSiteArray = _handleFlowXml_closure21.$getCallSiteArray();
                return (NiFiProperties)ScriptBytecodeAdapter.castToType((Object)this.nfp.get(), NiFiProperties.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _handleFlowXml_closure21.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "put";
                stringArray[1] = "getProperty";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _handleFlowXml_closure21.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_handleFlowXml_closure21.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _handleFlowXml_closure21.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        String existingFlowPassword = null;
        existingFlowPassword = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (string8 = DefaultTypeTransformation.booleanUnbox((Object)(string7 = this.existingFlowPropertiesPassword)) ? string7 : ShortTypeHandling.castToString((Object)callSiteArray[760].callCurrent((GroovyObject)this))) : (string6 = DefaultTypeTransformation.booleanUnbox((Object)(string5 = this.existingFlowPropertiesPassword)) ? string5 : this.getExistingFlowPassword());
        String newFlowPassword = null;
        newFlowPassword = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (string4 = DefaultTypeTransformation.booleanUnbox((Object)(string3 = this.flowPropertiesPassword)) ? string3 : ShortTypeHandling.castToString((Object)callSiteArray[761].callStatic(ConfigEncryptionTool.class))) : (string2 = DefaultTypeTransformation.booleanUnbox((Object)(string = this.flowPropertiesPassword)) ? string : ConfigEncryptionTool.getFlowPassword());
        if (!DefaultTypeTransformation.booleanUnbox((Object)newFlowPassword)) {
            String string9;
            newFlowPassword = string9 = existingFlowPassword;
        }
        Reference nfp = new Reference((Object)this.niFiProperties);
        Object object = callSiteArray[762].callSafe((Object)((NiFiProperties)nfp.get()), callSiteArray[763].callGetProperty(NiFiProperties.class));
        String existingAlgorithm = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : DEFAULT_FLOW_ALGORITHM));
        String string10 = this.newFlowAlgorithm;
        String newAlgorithm = DefaultTypeTransformation.booleanUnbox((Object)string10) ? string10 : existingAlgorithm;
        try {
            callSiteArray[764].call((Object)logger, (Object)new GStringImpl(new Object[]{flowXmlPath}, new String[]{"Migrating flow.xml file at ", ". This could take a while if the flow XML is very large."}));
            callSiteArray[765].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)this.flowXmlInputStream, (Object)existingFlowPassword, (Object)newFlowPassword, (Object)existingAlgorithm, (Object)newAlgorithm));
        }
        catch (Exception e) {
            callSiteArray[766].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[767].call((Object)e)}, new String[]{"Encountered an error: ", ""}));
            if (e instanceof BadPaddingException) {
                callSiteArray[768].call((Object)logger, (Object)"This error is likely caused by providing the wrong existing flow password. Check that the existing flow password [-p] is the one used to encrypt the provided flow.xml.gz file");
            }
            if (this.isVerbose) {
                callSiteArray[769].call((Object)logger, (Object)"Exception: ", (Object)e);
            }
            callSiteArray[770].callCurrent((GroovyObject)this, (Object)"Encountered an error migrating flow content", callSiteArray[771].callGetProperty(ExitCode.class));
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)newFlowPassword, (Object)DEFAULT_NIFI_SENSITIVE_PROPS_KEY) && ScriptBytecodeAdapter.compareNotEqual((Object)newFlowPassword, (Object)existingFlowPassword)) {
                Reference rawProperties = new Reference((Object)((Properties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[772].callConstructor(Properties.class), Properties.class)));
                callSiteArray[773].call(callSiteArray[774].call((Object)((NiFiProperties)nfp.get())), (Object)new _handleFlowXml_closure21(this, this, rawProperties, nfp));
                if (this.handlingNiFiProperties || existingNiFiPropertiesAreEncrypted) {
                    SensitivePropertyProviderFactory sensitivePropertyProviderFactory = (SensitivePropertyProviderFactory)ScriptBytecodeAdapter.castToType((Object)callSiteArray[775].callCurrent((GroovyObject)this, (Object)this.keyHex), SensitivePropertyProviderFactory.class);
                    SensitivePropertyProvider spp = (SensitivePropertyProvider)ScriptBytecodeAdapter.castToType((Object)callSiteArray[776].call((Object)sensitivePropertyProviderFactory, (Object)this.protectionScheme), SensitivePropertyProvider.class);
                    String encryptedSPK = ShortTypeHandling.castToString((Object)callSiteArray[777].call((Object)spp, (Object)newFlowPassword, callSiteArray[778].call(ProtectedPropertyContext.class, callSiteArray[779].callGetProperty(NiFiProperties.class))));
                    callSiteArray[780].call((Object)((Properties)rawProperties.get()), callSiteArray[781].callGetProperty(NiFiProperties.class), (Object)encryptedSPK);
                    callSiteArray[782].call((Object)((Properties)rawProperties.get()), callSiteArray[783].call(ApplicationPropertiesProtector.class, callSiteArray[784].callGetProperty(NiFiProperties.class)), callSiteArray[785].call((Object)spp));
                    if (this.isVerbose) {
                        callSiteArray[786].call((Object)logger, (Object)"Tool is not configured to encrypt nifi.properties, but the existing nifi.properties is encrypted and flow.xml.gz was migrated, so manually persisting the new encrypted value to nifi.properties");
                    }
                } else {
                    callSiteArray[787].call((Object)((Properties)rawProperties.get()), callSiteArray[788].callGetProperty(NiFiProperties.class), (Object)newFlowPassword);
                    callSiteArray[789].call((Object)((Properties)rawProperties.get()), callSiteArray[790].call(ApplicationPropertiesProtector.class, callSiteArray[791].callGetProperty(NiFiProperties.class)), (Object)"");
                }
                Object object2 = callSiteArray[792].callConstructor(NiFiProperties.class, (Object)((Properties)rawProperties.get()));
                this.niFiProperties = (NiFiProperties)ScriptBytecodeAdapter.castToType((Object)object2, NiFiProperties.class);
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)newFlowPassword, (Object)DEFAULT_NIFI_SENSITIVE_PROPS_KEY) && ScriptBytecodeAdapter.compareNotEqual((Object)newFlowPassword, (Object)existingFlowPassword)) {
            Reference rawProperties = new Reference((Object)((Properties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[793].callConstructor(Properties.class), Properties.class)));
            callSiteArray[794].call(callSiteArray[795].call((Object)((NiFiProperties)nfp.get())), (Object)new _handleFlowXml_closure21(this, this, rawProperties, nfp));
            if (this.handlingNiFiProperties || existingNiFiPropertiesAreEncrypted) {
                SensitivePropertyProviderFactory sensitivePropertyProviderFactory = this.getSensitivePropertyProviderFactory(this.keyHex);
                SensitivePropertyProvider spp = (SensitivePropertyProvider)ScriptBytecodeAdapter.castToType((Object)callSiteArray[796].call((Object)sensitivePropertyProviderFactory, (Object)this.protectionScheme), SensitivePropertyProvider.class);
                String encryptedSPK = ShortTypeHandling.castToString((Object)callSiteArray[797].call((Object)spp, (Object)newFlowPassword, callSiteArray[798].call(ProtectedPropertyContext.class, callSiteArray[799].callGetProperty(NiFiProperties.class))));
                callSiteArray[800].call((Object)((Properties)rawProperties.get()), callSiteArray[801].callGetProperty(NiFiProperties.class), (Object)encryptedSPK);
                callSiteArray[802].call((Object)((Properties)rawProperties.get()), callSiteArray[803].call(ApplicationPropertiesProtector.class, callSiteArray[804].callGetProperty(NiFiProperties.class)), callSiteArray[805].call((Object)spp));
                if (this.isVerbose) {
                    callSiteArray[806].call((Object)logger, (Object)"Tool is not configured to encrypt nifi.properties, but the existing nifi.properties is encrypted and flow.xml.gz was migrated, so manually persisting the new encrypted value to nifi.properties");
                }
            } else {
                callSiteArray[807].call((Object)((Properties)rawProperties.get()), callSiteArray[808].callGetProperty(NiFiProperties.class), (Object)newFlowPassword);
                callSiteArray[809].call((Object)((Properties)rawProperties.get()), callSiteArray[810].call(ApplicationPropertiesProtector.class, callSiteArray[811].callGetProperty(NiFiProperties.class)), (Object)"");
            }
            Object object3 = callSiteArray[812].callConstructor(NiFiProperties.class, (Object)((Properties)rawProperties.get()));
            this.niFiProperties = (NiFiProperties)ScriptBytecodeAdapter.castToType((Object)object3, NiFiProperties.class);
        }
    }

    public String translateNiFiPropertiesToCLI() {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        String baseUrl = ShortTypeHandling.castToString((Object)callSiteArray[813].callStatic(ConfigEncryptionTool.class, (Object)this.niFiProperties));
        Reference cliOutput = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{new GStringImpl(new Object[]{baseUrl}, new String[]{"baseUrl=", ""})}));
        public final class _translateNiFiPropertiesToCLI_closure22
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference cliOutput;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _translateNiFiPropertiesToCLI_closure22(Object _outerInstance, Object _thisObject, Reference cliOutput) {
                Reference reference;
                CallSite[] callSiteArray = _translateNiFiPropertiesToCLI_closure22.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.cliOutput = reference = cliOutput;
            }

            public Object doCall(String nfpKey, String cliKey) {
                CallSite[] callSiteArray = _translateNiFiPropertiesToCLI_closure22.$getCallSiteArray();
                return callSiteArray[0].call(this.cliOutput.get(), (Object)new GStringImpl(new Object[]{cliKey, callSiteArray[1].call(callSiteArray[2].callGroovyObjectGetProperty((Object)this), (Object)nfpKey)}, new String[]{"", "=", ""}));
            }

            @Generated
            public Object call(String nfpKey, String cliKey) {
                CallSite[] callSiteArray = _translateNiFiPropertiesToCLI_closure22.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[3].callCurrent((GroovyObject)this, (Object)nfpKey, (Object)cliKey);
                }
                return this.doCall(nfpKey, cliKey);
            }

            @Generated
            public List getCliOutput() {
                CallSite[] callSiteArray = _translateNiFiPropertiesToCLI_closure22.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.cliOutput.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateNiFiPropertiesToCLI_closure22.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "leftShift";
                stringArray[1] = "getProperty";
                stringArray[2] = ConfigEncryptionTool.NIFI_PROPERTIES_ARG;
                stringArray[3] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _translateNiFiPropertiesToCLI_closure22.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_translateNiFiPropertiesToCLI_closure22.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _translateNiFiPropertiesToCLI_closure22.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[814].call(PROPERTY_KEY_MAP, (Object)new _translateNiFiPropertiesToCLI_closure22(this, this, cliOutput));
        callSiteArray[815].call((Object)((List)cliOutput.get()), (Object)"proxiedEntity=");
        return ShortTypeHandling.castToString((Object)callSiteArray[816].call((Object)((List)cliOutput.get()), (Object)"\n"));
    }

    public static Supplier<BootstrapProperties> getBootstrapSupplier(String bootstrapConfPath) {
        Reference bootstrapConfPath2 = new Reference((Object)bootstrapConfPath);
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return new Supplier<BootstrapProperties>(bootstrapConfPath2){
            public /* synthetic */ Reference bootstrapConfPath;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                MetaClass metaClass;
                Reference reference;
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.bootstrapConfPath = reference = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public BootstrapProperties get() {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                BootstrapProperties bootstrapProperties = (BootstrapProperties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(NiFiBootstrapUtils.class, this.bootstrapConfPath.get()), BootstrapProperties.class);
                try {
                    return bootstrapProperties;
                }
                catch (IOException e) {
                    callSiteArray[1].call(ScriptBytecodeAdapter.getField(1.class, ConfigEncryptionTool.class, (String)"logger"), callSiteArray[2].call((Object)"Could not load default bootstrap.conf: ", callSiteArray[3].call((Object)e)));
                    BootstrapProperties bootstrapProperties2 = (BootstrapProperties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].callGetProperty(BootstrapProperties.class), BootstrapProperties.class);
                    return bootstrapProperties2;
                }
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(1.class, ConfigEncryptionTool.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(1.class, ConfigEncryptionTool.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object value) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ConfigEncryptionTool.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ConfigEncryptionTool.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(1.class, ConfigEncryptionTool.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(1.class, ConfigEncryptionTool.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            @Transient
            public MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "loadBootstrapProperties";
                stringArray[1] = "warn";
                stringArray[2] = "plus";
                stringArray[3] = "getMessage";
                stringArray[4] = "EMPTY";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        };
    }

    public static String determineBaseUrl(NiFiProperties niFiProperties) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        String protocol = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[817].call((Object)niFiProperties)) ? "https" : "http";
        String host = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[818].call((Object)niFiProperties)) ? callSiteArray[819].call((Object)niFiProperties, callSiteArray[820].callGetProperty(NiFiProperties.class)) : callSiteArray[821].call((Object)niFiProperties, callSiteArray[822].callGetProperty(NiFiProperties.class))));
        String port = ShortTypeHandling.castToString((Object)callSiteArray[823].call((Object)niFiProperties));
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{protocol, host, port}, new String[]{"", "://", ":", ""}));
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ConfigEncryptionTool.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ConfigEncryptionTool.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ConfigEncryptionTool.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    private static String buildHeader() {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ConfigEncryptionTool.buildHeader(DEFAULT_DESCRIPTION);
        }
        return ConfigEncryptionTool.buildHeader(DEFAULT_DESCRIPTION);
    }

    @Generated
    public boolean commandLineHasActionFlags(CommandLine commandLine) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return this.commandLineHasActionFlags(commandLine, ScriptBytecodeAdapter.createList((Object[])new Object[0]));
    }

    @Generated
    private String getKeyInternal(String keyHex, String password, boolean usingPassword) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return this.getKeyInternal((TextDevice)ScriptBytecodeAdapter.castToType((Object)callSiteArray[824].call(TextDevices.class), TextDevice.class), keyHex, password, usingPassword);
    }

    @Generated
    private String getKey() {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return this.getKey((TextDevice)ScriptBytecodeAdapter.castToType((Object)callSiteArray[825].call(TextDevices.class), TextDevice.class));
    }

    @Generated
    private static String getFlowPassword() {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return ConfigEncryptionTool.getFlowPassword((TextDevice)ScriptBytecodeAdapter.castToType((Object)callSiteArray[826].call(TextDevices.class), TextDevice.class));
    }

    @Generated
    private NiFiProperties loadNiFiProperties() throws IOException {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.loadNiFiProperties(this.keyHex);
        }
        return this.loadNiFiProperties(this.keyHex);
    }

    @Generated
    private String loadLoginIdentityProviders() throws IOException {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.loadLoginIdentityProviders(this.keyHex);
        }
        return this.loadLoginIdentityProviders(this.keyHex);
    }

    @Generated
    private String loadAuthorizers() throws IOException {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.loadAuthorizers(this.keyHex);
        }
        return this.loadAuthorizers(this.keyHex);
    }

    @Generated
    private InputStream migrateFlowXmlContent(InputStream flowXmlContent, String existingFlowPassword, String newFlowPassword, String existingAlgorithm) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return this.migrateFlowXmlContent(flowXmlContent, existingFlowPassword, newFlowPassword, existingAlgorithm, DEFAULT_FLOW_ALGORITHM);
    }

    @Generated
    private InputStream migrateFlowXmlContent(InputStream flowXmlContent, String existingFlowPassword, String newFlowPassword) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        return this.migrateFlowXmlContent(flowXmlContent, existingFlowPassword, newFlowPassword, DEFAULT_FLOW_ALGORITHM, DEFAULT_FLOW_ALGORITHM);
    }

    @Generated
    public String decryptLoginIdentityProviders(String encryptedXml) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.decryptLoginIdentityProviders(encryptedXml, this.keyHex);
        }
        return this.decryptLoginIdentityProviders(encryptedXml, this.keyHex);
    }

    @Generated
    public String decryptAuthorizers(String encryptedXml) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.decryptAuthorizers(encryptedXml, this.keyHex);
        }
        return this.decryptAuthorizers(encryptedXml, this.keyHex);
    }

    @Generated
    public String encryptLoginIdentityProviders(String plainXml) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.encryptLoginIdentityProviders(plainXml, this.keyHex);
        }
        return this.encryptLoginIdentityProviders(plainXml, this.keyHex);
    }

    @Generated
    public String encryptAuthorizers(String plainXml) {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.encryptAuthorizers(plainXml, this.keyHex);
        }
        return this.encryptAuthorizers(plainXml, this.keyHex);
    }

    @Generated
    public void handleFlowXml() {
        CallSite[] callSiteArray = ConfigEncryptionTool.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            this.handleFlowXml(false);
        } else {
            this.handleFlowXml(false);
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ConfigEncryptionTool.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Map map;
        Object object = ConfigEncryptionTool.$getCallSiteArray()[827].call(LoggerFactory.class, ConfigEncryptionTool.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
        Object object2 = ConfigEncryptionTool.$getCallSiteArray()[828].callConstructor(StandardProtectionScheme.class, (Object)"aes/gcm");
        DEFAULT_PROTECTION_SCHEME = (ProtectionScheme)ScriptBytecodeAdapter.castToType((Object)object2, ProtectionScheme.class);
        Object object3 = ConfigEncryptionTool.$getCallSiteArray()[829].callConstructor(StandardProtectionSchemeResolver.class);
        PROTECTION_SCHEME_RESOLVER = (StandardProtectionSchemeResolver)ScriptBytecodeAdapter.castToType((Object)object3, StandardProtectionSchemeResolver.class);
        Object object4 = ConfigEncryptionTool.$getCallSiteArray()[830].call(String.class, (Object)"Selects the protection scheme for encrypted properties. Default is AES_GCM. Valid values: %s", ConfigEncryptionTool.$getCallSiteArray()[831].callGetProperty((Object)PROTECTION_SCHEME_RESOLVER));
        PROTECTION_SCHEME_DESC = ShortTypeHandling.castToString((Object)object4);
        Object object5 = ConfigEncryptionTool.$getCallSiteArray()[832].call(System.class);
        SEP = ShortTypeHandling.castToString((Object)object5);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object6 = ConfigEncryptionTool.$getCallSiteArray()[833].callStatic(ConfigEncryptionTool.class);
            FOOTER = ShortTypeHandling.castToString((Object)object6);
        } else {
            String string;
            FOOTER = string = ConfigEncryptionTool.buildFooter();
        }
        PROPERTY_KEY_MAP = map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"nifi.security.keystore", "keystore", "nifi.security.keystoreType", "keystoreType", "nifi.security.keystorePasswd", "keystorePasswd", "nifi.security.keyPasswd", "keyPasswd", "nifi.security.truststore", "truststore", "nifi.security.truststoreType", "truststoreType", "nifi.security.truststorePasswd", "truststorePasswd"});
    }

    @Generated
    public static ProtectionScheme getDEFAULT_PROTECTION_SCHEME() {
        return DEFAULT_PROTECTION_SCHEME;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "DEFAULT_DESCRIPTION";
        stringArray[1] = "buildHeader";
        stringArray[2] = "getCliOptions";
        stringArray[3] = "multiply";
        stringArray[4] = "getenv";
        stringArray[5] = "getenv";
        stringArray[6] = "<$constructor$>";
        stringArray[7] = "addOption";
        stringArray[8] = "build";
        stringArray[9] = "desc";
        stringArray[10] = "hasArg";
        stringArray[11] = "longOpt";
        stringArray[12] = "builder";
        stringArray[13] = "addOption";
        stringArray[14] = "build";
        stringArray[15] = "desc";
        stringArray[16] = "hasArg";
        stringArray[17] = "longOpt";
        stringArray[18] = "builder";
        stringArray[19] = "addOption";
        stringArray[20] = "build";
        stringArray[21] = "desc";
        stringArray[22] = "argName";
        stringArray[23] = "hasArg";
        stringArray[24] = "longOpt";
        stringArray[25] = "builder";
        stringArray[26] = "addOption";
        stringArray[27] = "build";
        stringArray[28] = "desc";
        stringArray[29] = "argName";
        stringArray[30] = "hasArg";
        stringArray[31] = "longOpt";
        stringArray[32] = "builder";
        stringArray[33] = "addOption";
        stringArray[34] = "build";
        stringArray[35] = "desc";
        stringArray[36] = "argName";
        stringArray[37] = "hasArg";
        stringArray[38] = "longOpt";
        stringArray[39] = "builder";
        stringArray[40] = "addOption";
        stringArray[41] = "build";
        stringArray[42] = "desc";
        stringArray[43] = "argName";
        stringArray[44] = "hasArg";
        stringArray[45] = "longOpt";
        stringArray[46] = "builder";
        stringArray[47] = "addOption";
        stringArray[48] = "build";
        stringArray[49] = "desc";
        stringArray[50] = "argName";
        stringArray[51] = "hasArg";
        stringArray[52] = "longOpt";
        stringArray[53] = "builder";
        stringArray[54] = "addOption";
        stringArray[55] = "build";
        stringArray[56] = "desc";
        stringArray[57] = "argName";
        stringArray[58] = "hasArg";
        stringArray[59] = "longOpt";
        stringArray[60] = "builder";
        stringArray[61] = "addOption";
        stringArray[62] = "build";
        stringArray[63] = "desc";
        stringArray[64] = "argName";
        stringArray[65] = "hasArg";
        stringArray[66] = "longOpt";
        stringArray[67] = "builder";
        stringArray[68] = "addOption";
        stringArray[69] = "build";
        stringArray[70] = "desc";
        stringArray[71] = "argName";
        stringArray[72] = "hasArg";
        stringArray[73] = "longOpt";
        stringArray[74] = "builder";
        stringArray[75] = "addOption";
        stringArray[76] = "build";
        stringArray[77] = "desc";
        stringArray[78] = "argName";
        stringArray[79] = "hasArg";
        stringArray[80] = "longOpt";
        stringArray[81] = "builder";
        stringArray[82] = "addOption";
        stringArray[83] = "build";
        stringArray[84] = "desc";
        stringArray[85] = "argName";
        stringArray[86] = "hasArg";
        stringArray[87] = "longOpt";
        stringArray[88] = "builder";
        stringArray[89] = "addOption";
        stringArray[90] = "build";
        stringArray[91] = "desc";
        stringArray[92] = "argName";
        stringArray[93] = "hasArg";
        stringArray[94] = "longOpt";
        stringArray[95] = "builder";
        stringArray[96] = "addOption";
        stringArray[97] = "build";
        stringArray[98] = "desc";
        stringArray[99] = "argName";
        stringArray[100] = "hasArg";
        stringArray[101] = "longOpt";
        stringArray[102] = "builder";
        stringArray[103] = "addOption";
        stringArray[104] = "build";
        stringArray[105] = "desc";
        stringArray[106] = "argName";
        stringArray[107] = "hasArg";
        stringArray[108] = "longOpt";
        stringArray[109] = "builder";
        stringArray[110] = "addOption";
        stringArray[111] = "build";
        stringArray[112] = "desc";
        stringArray[113] = "argName";
        stringArray[114] = "hasArg";
        stringArray[115] = "longOpt";
        stringArray[116] = "builder";
        stringArray[117] = "addOption";
        stringArray[118] = "build";
        stringArray[119] = "desc";
        stringArray[120] = "argName";
        stringArray[121] = "hasArg";
        stringArray[122] = "longOpt";
        stringArray[123] = "builder";
        stringArray[124] = "addOption";
        stringArray[125] = "build";
        stringArray[126] = "desc";
        stringArray[127] = "hasArg";
        stringArray[128] = "longOpt";
        stringArray[129] = "builder";
        stringArray[130] = "addOption";
        stringArray[131] = "build";
        stringArray[132] = "desc";
        stringArray[133] = "hasArg";
        stringArray[134] = "longOpt";
        stringArray[135] = "builder";
        stringArray[136] = "addOption";
        stringArray[137] = "build";
        stringArray[138] = "desc";
        stringArray[139] = "hasArg";
        stringArray[140] = "longOpt";
        stringArray[141] = "builder";
        stringArray[142] = "addOption";
        stringArray[143] = "build";
        stringArray[144] = "desc";
        stringArray[145] = "argName";
        stringArray[146] = "hasArg";
        stringArray[147] = "longOpt";
        stringArray[148] = "builder";
        stringArray[149] = "addOption";
        stringArray[150] = "build";
        stringArray[151] = "desc";
        stringArray[152] = "argName";
        stringArray[153] = "hasArg";
        stringArray[154] = "longOpt";
        stringArray[155] = "builder";
        stringArray[156] = "addOption";
        stringArray[157] = "build";
        stringArray[158] = "desc";
        stringArray[159] = "argName";
        stringArray[160] = "hasArg";
        stringArray[161] = "longOpt";
        stringArray[162] = "builder";
        stringArray[163] = "addOption";
        stringArray[164] = "build";
        stringArray[165] = "desc";
        stringArray[166] = "hasArg";
        stringArray[167] = "longOpt";
        stringArray[168] = "builder";
        stringArray[169] = "buildOptions";
        stringArray[170] = "println";
        stringArray[171] = "out";
        stringArray[172] = "println";
        stringArray[173] = "out";
        stringArray[174] = "<$constructor$>";
        stringArray[175] = "setWidth";
        stringArray[176] = "setOptionComparator";
        stringArray[177] = "printHelp";
        stringArray[178] = "getCanonicalName";
        stringArray[179] = "printUsage";
        stringArray[180] = "<$constructor$>";
        stringArray[181] = "<$constructor$>";
        stringArray[182] = "parse";
        stringArray[183] = "hasOption";
        stringArray[184] = "printUsageAndThrow";
        stringArray[185] = "HELP";
        stringArray[186] = "hasOption";
        stringArray[187] = "hasOption";
        stringArray[188] = "commandLineHasActionFlags";
        stringArray[189] = "printUsageAndThrow";
        stringArray[190] = "INVALID_ARGS";
        stringArray[191] = "getOptionValue";
        stringArray[192] = "hasOption";
        stringArray[193] = "hasOption";
        stringArray[194] = "info";
        stringArray[195] = "info";
        stringArray[196] = "getOptionValue";
        stringArray[197] = "getOptionValue";
        stringArray[198] = "warn";
        stringArray[199] = "hasOption";
        stringArray[200] = "getProtectionScheme";
        stringArray[201] = "getOptionValue";
        stringArray[202] = "printUsageAndThrow";
        stringArray[203] = "INVALID_ARGS";
        stringArray[204] = "hasOption";
        stringArray[205] = "hasOption";
        stringArray[206] = "info";
        stringArray[207] = "getOptionValue";
        stringArray[208] = "getOptionValue";
        stringArray[209] = "warn";
        stringArray[210] = "hasOption";
        stringArray[211] = "info";
        stringArray[212] = "getOptionValue";
        stringArray[213] = "getOptionValue";
        stringArray[214] = "warn";
        stringArray[215] = "hasOption";
        stringArray[216] = "info";
        stringArray[217] = "getOptionValue";
        stringArray[218] = "getOptionValue";
        stringArray[219] = "getOptionValue";
        stringArray[220] = "getOptionValue";
        stringArray[221] = "warn";
        stringArray[222] = "hasOption";
        stringArray[223] = "printUsageAndThrow";
        stringArray[224] = "INVALID_ARGS";
        stringArray[225] = "info";
        stringArray[226] = "info";
        stringArray[227] = "info";
        stringArray[228] = "info";
        stringArray[229] = "info";
        stringArray[230] = "info";
        stringArray[231] = "info";
        stringArray[232] = "info";
        stringArray[233] = "info";
        stringArray[234] = "hasOption";
        stringArray[235] = "hasOption";
        stringArray[236] = "hasOption";
        stringArray[237] = "hasOption";
        stringArray[238] = "printUsageAndThrow";
        stringArray[239] = "plus";
        stringArray[240] = "plus";
        stringArray[241] = "plus";
        stringArray[242] = "plus";
        stringArray[243] = "plus";
        stringArray[244] = "INVALID_ARGS";
        stringArray[245] = "hasOption";
        stringArray[246] = "hasOption";
        stringArray[247] = "hasOption";
        stringArray[248] = "hasOption";
        stringArray[249] = "printUsageAndThrow";
        stringArray[250] = "plus";
        stringArray[251] = "plus";
        stringArray[252] = "plus";
        stringArray[253] = "plus";
        stringArray[254] = "plus";
        stringArray[255] = "INVALID_ARGS";
        stringArray[256] = "hasOption";
        stringArray[257] = "info";
        stringArray[258] = "hasOption";
        stringArray[259] = "getProtectionScheme";
        stringArray[260] = "getOptionValue";
        stringArray[261] = "hasOption";
        stringArray[262] = "hasOption";
        stringArray[263] = "printUsageAndThrow";
        stringArray[264] = "INVALID_ARGS";
        stringArray[265] = "getOptionValue";
        stringArray[266] = "getOptionValue";
        stringArray[267] = "hasOption";
        stringArray[268] = "hasOption";
        stringArray[269] = "printUsageAndThrow";
        stringArray[270] = "INVALID_ARGS";
        stringArray[271] = "hasOption";
        stringArray[272] = "hasOption";
        stringArray[273] = "printUsageAndThrow";
        stringArray[274] = "INVALID_ARGS";
        stringArray[275] = "getOptionValue";
        stringArray[276] = "getOptionValue";
        stringArray[277] = "hasOption";
        stringArray[278] = "warn";
        stringArray[279] = "hasOption";
        stringArray[280] = "getOptionValue";
        stringArray[281] = "error";
        stringArray[282] = "printUsageAndThrow";
        stringArray[283] = "plus";
        stringArray[284] = "plus";
        stringArray[285] = "getMessage";
        stringArray[286] = "ERROR_PARSING_COMMAND_LINE";
        stringArray[287] = "resolveOptions";
        stringArray[288] = "resolveOptions";
        stringArray[289] = "minus";
        stringArray[290] = "options";
        stringArray[291] = "plus";
        stringArray[292] = "error";
        stringArray[293] = "collect";
        stringArray[294] = "info";
        stringArray[295] = "readPasswordFromConsole";
        stringArray[296] = "deriveKeyFromPassword";
        stringArray[297] = "info";
        stringArray[298] = "readKeyFromConsole";
        stringArray[299] = "getKeyInternal";
        stringArray[300] = "getKeyInternal";
        stringArray[301] = "defaultTextDevice";
        stringArray[302] = "readPasswordFromConsole";
        stringArray[303] = "printf";
        stringArray[304] = "<$constructor$>";
        stringArray[305] = "readPassword";
        stringArray[306] = "printf";
        stringArray[307] = "<$constructor$>";
        stringArray[308] = "readPassword";
        stringArray[309] = "replaceAll";
        stringArray[310] = "toUpperCase";
        stringArray[311] = "getMaxAllowedKeyLength";
        stringArray[312] = "<$constructor$>";
        stringArray[313] = "withKey";
        stringArray[314] = "exists";
        stringArray[315] = "<$constructor$>";
        stringArray[316] = "load";
        stringArray[317] = "getNiFiPropertiesLoader";
        stringArray[318] = "load";
        stringArray[319] = "info";
        stringArray[320] = "size";
        stringArray[321] = "error";
        stringArray[322] = "<$constructor$>";
        stringArray[323] = "printUsageAndThrow";
        stringArray[324] = "ERROR_READING_NIFI_PROPERTIES";
        stringArray[325] = "exists";
        stringArray[326] = "<$constructor$>";
        stringArray[327] = "readLines";
        stringArray[328] = "join";
        stringArray[329] = "info";
        stringArray[330] = "size";
        stringArray[331] = "decryptLoginIdentityProviders";
        stringArray[332] = "error";
        stringArray[333] = "<$constructor$>";
        stringArray[334] = "printUsageAndThrow";
        stringArray[335] = "ERROR_READING_NIFI_PROPERTIES";
        stringArray[336] = "exists";
        stringArray[337] = "<$constructor$>";
        stringArray[338] = "readLines";
        stringArray[339] = "join";
        stringArray[340] = "info";
        stringArray[341] = "size";
        stringArray[342] = "decryptAuthorizers";
        stringArray[343] = "error";
        stringArray[344] = "<$constructor$>";
        stringArray[345] = "printUsageAndThrow";
        stringArray[346] = "ERROR_READING_NIFI_PROPERTIES";
        stringArray[347] = "exists";
        stringArray[348] = "<$constructor$>";
        stringArray[349] = "<$constructor$>";
        stringArray[350] = "<$constructor$>";
        stringArray[351] = "debug";
        stringArray[352] = "getMessage";
        stringArray[353] = "<$constructor$>";
        stringArray[354] = "error";
        stringArray[355] = "<$constructor$>";
        stringArray[356] = "printUsageAndThrow";
        stringArray[357] = "ERROR_READING_NIFI_PROPERTIES";
        stringArray[358] = "<$constructor$>";
        stringArray[359] = "toString";
        stringArray[360] = "getTemporaryFlowXmlFile";
        stringArray[361] = "<$constructor$>";
        stringArray[362] = "toString";
        stringArray[363] = "getFlowOutputStream";
        stringArray[364] = "createBasicNiFiProperties";
        stringArray[365] = "SENSITIVE_PROPS_KEY";
        stringArray[366] = "SENSITIVE_PROPS_ALGORITHM";
        stringArray[367] = "createBasicNiFiProperties";
        stringArray[368] = "SENSITIVE_PROPS_KEY";
        stringArray[369] = "SENSITIVE_PROPS_ALGORITHM";
        stringArray[370] = "getPropertyEncryptor";
        stringArray[371] = "getPropertyEncryptor";
        stringArray[372] = "<$constructor$>";
        stringArray[373] = "processFlow";
        stringArray[374] = "move";
        stringArray[375] = "toPath";
        stringArray[376] = "get";
        stringArray[377] = "ATOMIC_MOVE";
        stringArray[378] = "loadFlowXml";
        stringArray[379] = "<$constructor$>";
        stringArray[380] = "<$constructor$>";
        stringArray[381] = "toString";
        stringArray[382] = "getFileName";
        stringArray[383] = "get";
        stringArray[384] = "resolveSibling";
        stringArray[385] = "get";
        stringArray[386] = "withKeyAndBootstrapSupplier";
        stringArray[387] = "getBootstrapSupplier";
        stringArray[388] = "withKeyAndBootstrapSupplier";
        stringArray[389] = "getSensitivePropertyProviderFactory";
        stringArray[390] = "parseText";
        stringArray[391] = "getXmlSlurper";
        stringArray[392] = "parseText";
        stringArray[393] = "find";
        stringArray[394] = "provider";
        stringArray[395] = "text";
        stringArray[396] = "identifier";
        stringArray[397] = "findAll";
        stringArray[398] = "property";
        stringArray[399] = "isEmpty";
        stringArray[400] = "info";
        stringArray[401] = "each";
        stringArray[402] = "serialize";
        stringArray[403] = "info";
        stringArray[404] = "error";
        stringArray[405] = "printUsageAndThrow";
        stringArray[406] = "SERVICE_ERROR";
        stringArray[407] = "getSensitivePropertyProviderFactory";
        stringArray[408] = "parseText";
        stringArray[409] = "getXmlSlurper";
        stringArray[410] = "parseText";
        stringArray[411] = "findAll";
        stringArray[412] = "userGroupProvider";
        stringArray[413] = "text";
        stringArray[414] = "identifier";
        stringArray[415] = "findAll";
        stringArray[416] = "property";
        stringArray[417] = "isEmpty";
        stringArray[418] = "info";
        stringArray[419] = "each";
        stringArray[420] = "serialize";
        stringArray[421] = "info";
        stringArray[422] = "error";
        stringArray[423] = "printUsageAndThrow";
        stringArray[424] = "SERVICE_ERROR";
        stringArray[425] = "getPropertyContext";
        stringArray[426] = "getSensitivePropertyProviderFactory";
        stringArray[427] = "parseText";
        stringArray[428] = "getXmlSlurper";
        stringArray[429] = "parseText";
        stringArray[430] = "find";
        stringArray[431] = "provider";
        stringArray[432] = "text";
        stringArray[433] = "identifier";
        stringArray[434] = "findAll";
        stringArray[435] = "property";
        stringArray[436] = "isEmpty";
        stringArray[437] = "info";
        stringArray[438] = "getProvider";
        stringArray[439] = "each";
        stringArray[440] = "serialize";
        stringArray[441] = "info";
        stringArray[442] = "error";
        stringArray[443] = "printUsageAndThrow";
        stringArray[444] = "SERVICE_ERROR";
        stringArray[445] = "getSensitivePropertyProviderFactory";
        stringArray[446] = "parseText";
        stringArray[447] = "getXmlSlurper";
        stringArray[448] = "parseText";
        stringArray[449] = "findAll";
        stringArray[450] = "userGroupProvider";
        stringArray[451] = "text";
        stringArray[452] = "identifier";
        stringArray[453] = "findAll";
        stringArray[454] = "property";
        stringArray[455] = "isEmpty";
        stringArray[456] = "info";
        stringArray[457] = "getProvider";
        stringArray[458] = "each";
        stringArray[459] = "serialize";
        stringArray[460] = "info";
        stringArray[461] = "error";
        stringArray[462] = "printUsageAndThrow";
        stringArray[463] = "SERVICE_ERROR";
        stringArray[464] = "<$constructor$>";
        stringArray[465] = "<$constructor$>";
        stringArray[466] = "getSensitivePropertyKeys";
        stringArray[467] = "isEmpty";
        stringArray[468] = "info";
        stringArray[469] = "<$constructor$>";
        stringArray[470] = "getSensitivePropertyProviderFactory";
        stringArray[471] = "getProvider";
        stringArray[472] = "addSensitivePropertyProvider";
        stringArray[473] = "each";
        stringArray[474] = "minus";
        stringArray[475] = "getPropertyKeys";
        stringArray[476] = "each";
        stringArray[477] = "<$constructor$>";
        stringArray[478] = "info";
        stringArray[479] = "size";
        stringArray[480] = "countProtectedProperties";
        stringArray[481] = "replaceFirst";
        stringArray[482] = "serialize";
        stringArray[483] = "exists";
        stringArray[484] = "<$constructor$>";
        stringArray[485] = "canRead";
        stringArray[486] = "canWrite";
        stringArray[487] = "readLines";
        stringArray[488] = "updateBootstrapContentsWithKey";
        stringArray[489] = "join";
        stringArray[490] = "error";
        stringArray[491] = "<$constructor$>";
        stringArray[492] = "findIndexOf";
        stringArray[493] = "debug";
        stringArray[494] = "putAt";
        stringArray[495] = "debug";
        stringArray[496] = "minus";
        stringArray[497] = "getAt";
        stringArray[498] = "add";
        stringArray[499] = "debug";
        stringArray[500] = "addAll";
        stringArray[501] = "debug";
        stringArray[502] = "<$constructor$>";
        stringArray[503] = "<$constructor$>";
        stringArray[504] = "isSafeToWrite";
        stringArray[505] = "<$constructor$>";
        stringArray[506] = "exists";
        stringArray[507] = "canRead";
        stringArray[508] = "join";
        stringArray[509] = "serializeLoginIdentityProvidersAndPreserveFormat";
        stringArray[510] = "error";
        stringArray[511] = "<$constructor$>";
        stringArray[512] = "<$constructor$>";
        stringArray[513] = "<$constructor$>";
        stringArray[514] = "isSafeToWrite";
        stringArray[515] = "<$constructor$>";
        stringArray[516] = "exists";
        stringArray[517] = "canRead";
        stringArray[518] = "join";
        stringArray[519] = "serializeAuthorizersAndPreserveFormat";
        stringArray[520] = "error";
        stringArray[521] = "<$constructor$>";
        stringArray[522] = "<$constructor$>";
        stringArray[523] = "<$constructor$>";
        stringArray[524] = "isSafeToWrite";
        stringArray[525] = "<$constructor$>";
        stringArray[526] = "exists";
        stringArray[527] = "canRead";
        stringArray[528] = "serializeNiFiPropertiesAndPreserveFormat";
        stringArray[529] = "serializeNiFiProperties";
        stringArray[530] = "join";
        stringArray[531] = "error";
        stringArray[532] = "<$constructor$>";
        stringArray[533] = "readLines";
        stringArray[534] = "<$constructor$>";
        stringArray[535] = "getProtectedPropertyKeys";
        stringArray[536] = "containsKey";
        stringArray[537] = "SENSITIVE_PROPS_KEY";
        stringArray[538] = "put";
        stringArray[539] = "SENSITIVE_PROPS_KEY";
        stringArray[540] = "getProperty";
        stringArray[541] = "getProtectionKey";
        stringArray[542] = "SENSITIVE_PROPS_KEY";
        stringArray[543] = "each";
        stringArray[544] = "<$constructor$>";
        stringArray[545] = "<$constructor$>";
        stringArray[546] = "<$constructor$>";
        stringArray[547] = "each";
        stringArray[548] = "getPropertyKeys";
        stringArray[549] = "store";
        stringArray[550] = "flush";
        stringArray[551] = "split";
        stringArray[552] = "toString";
        stringArray[553] = "text";
        stringArray[554] = "parseText";
        stringArray[555] = "getXmlSlurper";
        stringArray[556] = "parseText";
        stringArray[557] = "find";
        stringArray[558] = "provider";
        stringArray[559] = "serializeXMLFragment";
        stringArray[560] = "replaceFirst";
        stringArray[561] = "quoteReplacement";
        stringArray[562] = "split";
        stringArray[563] = "<$constructor$>";
        stringArray[564] = "error";
        stringArray[565] = "plus";
        stringArray[566] = "getMessage";
        stringArray[567] = "split";
        stringArray[568] = "text";
        stringArray[569] = "parseText";
        stringArray[570] = "getXmlSlurper";
        stringArray[571] = "parseText";
        stringArray[572] = "serializeProvider";
        stringArray[573] = "serializeProvider";
        stringArray[574] = "split";
        stringArray[575] = "error";
        stringArray[576] = "getMessage";
        stringArray[577] = "split";
        stringArray[578] = "text";
        stringArray[579] = "find";
        stringArray[580] = "userGroupProvider";
        stringArray[581] = "serializeXMLFragment";
        stringArray[582] = "replaceFirst";
        stringArray[583] = "quoteReplacement";
        stringArray[584] = "exists";
        stringArray[585] = "canWrite";
        stringArray[586] = "parentFile";
        stringArray[587] = "absoluteFile";
        stringArray[588] = "exists";
        stringArray[589] = "canWrite";
        stringArray[590] = "exists";
        stringArray[591] = "canWrite";
        stringArray[592] = "parentFile";
        stringArray[593] = "absoluteFile";
        stringArray[594] = "exists";
        stringArray[595] = "canWrite";
        stringArray[596] = "trim";
        stringArray[597] = "length";
        stringArray[598] = "<$constructor$>";
        stringArray[599] = "length";
        stringArray[600] = "<$constructor$>";
        stringArray[601] = "generateScryptSaltForKeyDerivation";
        stringArray[602] = "div";
        stringArray[603] = "max";
        stringArray[604] = "getValidKeyLengths";
        stringArray[605] = "div";
        stringArray[606] = "max";
        stringArray[607] = "generate";
        stringArray[608] = "getBytes";
        stringArray[609] = "UTF_8";
        stringArray[610] = "toUpperCase";
        stringArray[611] = "encodeHexString";
        stringArray[612] = "getBytes";
        stringArray[613] = "UTF_8";
        stringArray[614] = "getProperty";
        stringArray[615] = "SENSITIVE_PROPS_KEY";
        stringArray[616] = "loadProtectedProperties";
        stringArray[617] = "getNiFiPropertiesLoader";
        stringArray[618] = "<$constructor$>";
        stringArray[619] = "loadProtectedProperties";
        stringArray[620] = "<$constructor$>";
        stringArray[621] = "hasProtectedKeys";
        stringArray[622] = "debug";
        stringArray[623] = "getMessage";
        stringArray[624] = "debug";
        stringArray[625] = "getMessage";
        stringArray[626] = "<$constructor$>";
        stringArray[627] = "setKeepIgnorableWhitespace";
        stringArray[628] = "addProvider";
        stringArray[629] = "<$constructor$>";
        stringArray[630] = "<$constructor$>";
        stringArray[631] = "parse";
        stringArray[632] = "translatingCli";
        stringArray[633] = "bootstrapConfPath";
        stringArray[634] = "extractKeyFromBootstrapFile";
        stringArray[635] = "bootstrapConfPath";
        stringArray[636] = "keyHex";
        stringArray[637] = "info";
        stringArray[638] = "bootstrapConfPath";
        stringArray[639] = "niFiPropertiesPath";
        stringArray[640] = "loadNiFiProperties";
        stringArray[641] = "keyHex";
        stringArray[642] = "translateNiFiPropertiesToCLI";
        stringArray[643] = "println";
        stringArray[644] = "out";
        stringArray[645] = "exit";
        stringArray[646] = "ordinal";
        stringArray[647] = "SUCCESS";
        stringArray[648] = "niFiPropertiesAreEncrypted";
        stringArray[649] = "ignorePropertiesFiles";
        stringArray[650] = "handlingFlowXml";
        stringArray[651] = "ignorePropertiesFiles";
        stringArray[652] = "extractKeyFromBootstrapFile";
        stringArray[653] = "bootstrapConfPath";
        stringArray[654] = "getKey";
        stringArray[655] = "keyHex";
        stringArray[656] = "printUsageAndThrow";
        stringArray[657] = "INVALID_ARGS";
        stringArray[658] = "parseKey";
        stringArray[659] = "keyHex";
        stringArray[660] = "isVerbose";
        stringArray[661] = "error";
        stringArray[662] = "printUsageAndThrow";
        stringArray[663] = "getMessage";
        stringArray[664] = "INVALID_ARGS";
        stringArray[665] = "migration";
        stringArray[666] = "getMigrationKey";
        stringArray[667] = "parseKey";
        stringArray[668] = "isVerbose";
        stringArray[669] = "error";
        stringArray[670] = "printUsageAndThrow";
        stringArray[671] = "getMessage";
        stringArray[672] = "INVALID_ARGS";
        stringArray[673] = "ignorePropertiesFiles";
        stringArray[674] = "handlingFlowXml";
        stringArray[675] = "ignorePropertiesFiles";
        stringArray[676] = "extractKeyFromBootstrapFile";
        stringArray[677] = "bootstrapConfPath";
        stringArray[678] = "getKey";
        stringArray[679] = "keyHex";
        stringArray[680] = "printUsageAndThrow";
        stringArray[681] = "INVALID_ARGS";
        stringArray[682] = "parseKey";
        stringArray[683] = "keyHex";
        stringArray[684] = "isVerbose";
        stringArray[685] = "error";
        stringArray[686] = "printUsageAndThrow";
        stringArray[687] = "getMessage";
        stringArray[688] = "INVALID_ARGS";
        stringArray[689] = "migration";
        stringArray[690] = "getMigrationKey";
        stringArray[691] = "isVerbose";
        stringArray[692] = "error";
        stringArray[693] = "printUsageAndThrow";
        stringArray[694] = "getMessage";
        stringArray[695] = "INVALID_ARGS";
        stringArray[696] = "migrationKeyHex";
        stringArray[697] = "keyHex";
        stringArray[698] = "handlingNiFiProperties";
        stringArray[699] = "handlingFlowXml";
        stringArray[700] = "loadNiFiProperties";
        stringArray[701] = "error";
        stringArray[702] = "printUsageAndThrow";
        stringArray[703] = "ERROR_READING_NIFI_PROPERTIES";
        stringArray[704] = "handlingLoginIdentityProviders";
        stringArray[705] = "loadLoginIdentityProviders";
        stringArray[706] = "error";
        stringArray[707] = "printUsageAndThrow";
        stringArray[708] = "ERROR_INCORRECT_NUMBER_OF_PASSWORDS";
        stringArray[709] = "encryptLoginIdentityProviders";
        stringArray[710] = LOGIN_IDENTITY_PROVIDERS_ARG;
        stringArray[711] = "handlingAuthorizers";
        stringArray[712] = "loadAuthorizers";
        stringArray[713] = "error";
        stringArray[714] = "printUsageAndThrow";
        stringArray[715] = "ERROR_INCORRECT_NUMBER_OF_PASSWORDS";
        stringArray[716] = "encryptAuthorizers";
        stringArray[717] = AUTHORIZERS_ARG;
        stringArray[718] = "handlingFlowXml";
        stringArray[719] = "loadFlowXml";
        stringArray[720] = "isVerbose";
        stringArray[721] = "error";
        stringArray[722] = "printUsageAndThrow";
        stringArray[723] = "ERROR_READING_NIFI_PROPERTIES";
        stringArray[724] = "handlingNiFiProperties";
        stringArray[725] = "getExistingFlowPassword";
        stringArray[726] = "encryptSensitiveProperties";
        stringArray[727] = NIFI_PROPERTIES_ARG;
        stringArray[728] = "exitCode";
        stringArray[729] = "HELP";
        stringArray[730] = "exit";
        stringArray[731] = "ordinal";
        stringArray[732] = "HELP";
        stringArray[733] = "isVerbose";
        stringArray[734] = "error";
        stringArray[735] = "printUsageAndThrow";
        stringArray[736] = "message";
        stringArray[737] = "ERROR_PARSING_COMMAND_LINE";
        stringArray[738] = "ignorePropertiesFiles";
        stringArray[739] = "writeKeyToBootstrapConf";
        stringArray[740] = "handlingFlowXml";
        stringArray[741] = "handleFlowXml";
        stringArray[742] = "niFiPropertiesAreEncrypted";
        stringArray[743] = "handlingNiFiProperties";
        stringArray[744] = "handlingFlowXml";
        stringArray[745] = "writeNiFiProperties";
        stringArray[746] = "handlingLoginIdentityProviders";
        stringArray[747] = "writeLoginIdentityProviders";
        stringArray[748] = "handlingAuthorizers";
        stringArray[749] = "writeAuthorizers";
        stringArray[750] = "isVerbose";
        stringArray[751] = "error";
        stringArray[752] = "printUsageAndThrow";
        stringArray[753] = "ERROR_GENERATING_CONFIG";
        stringArray[754] = "exit";
        stringArray[755] = "ordinal";
        stringArray[756] = "exitCode";
        stringArray[757] = "exit";
        stringArray[758] = "ordinal";
        stringArray[759] = "SUCCESS";
        stringArray[760] = "getExistingFlowPassword";
        stringArray[761] = "getFlowPassword";
        stringArray[762] = "getProperty";
        stringArray[763] = "SENSITIVE_PROPS_ALGORITHM";
        stringArray[764] = "info";
        stringArray[765] = "migrateFlowXmlContent";
        stringArray[766] = "error";
        stringArray[767] = "getLocalizedMessage";
        stringArray[768] = "error";
        stringArray[769] = "error";
        stringArray[770] = "printUsageAndThrow";
        stringArray[771] = "ERROR_MIGRATING_FLOW";
        stringArray[772] = "<$constructor$>";
        stringArray[773] = "each";
        stringArray[774] = "getPropertyKeys";
        stringArray[775] = "getSensitivePropertyProviderFactory";
        stringArray[776] = "getProvider";
        stringArray[777] = "protect";
        stringArray[778] = "defaultContext";
        stringArray[779] = "SENSITIVE_PROPS_KEY";
        stringArray[780] = "put";
        stringArray[781] = "SENSITIVE_PROPS_KEY";
        stringArray[782] = "put";
        stringArray[783] = "getProtectionKey";
        stringArray[784] = "SENSITIVE_PROPS_KEY";
        stringArray[785] = "getIdentifierKey";
        stringArray[786] = "info";
        stringArray[787] = "put";
        stringArray[788] = "SENSITIVE_PROPS_KEY";
        stringArray[789] = "put";
        stringArray[790] = "getProtectionKey";
        stringArray[791] = "SENSITIVE_PROPS_KEY";
        stringArray[792] = "<$constructor$>";
        stringArray[793] = "<$constructor$>";
        stringArray[794] = "each";
        stringArray[795] = "getPropertyKeys";
        stringArray[796] = "getProvider";
        stringArray[797] = "protect";
        stringArray[798] = "defaultContext";
        stringArray[799] = "SENSITIVE_PROPS_KEY";
        stringArray[800] = "put";
        stringArray[801] = "SENSITIVE_PROPS_KEY";
        stringArray[802] = "put";
        stringArray[803] = "getProtectionKey";
        stringArray[804] = "SENSITIVE_PROPS_KEY";
        stringArray[805] = "getIdentifierKey";
        stringArray[806] = "info";
        stringArray[807] = "put";
        stringArray[808] = "SENSITIVE_PROPS_KEY";
        stringArray[809] = "put";
        stringArray[810] = "getProtectionKey";
        stringArray[811] = "SENSITIVE_PROPS_KEY";
        stringArray[812] = "<$constructor$>";
        stringArray[813] = "determineBaseUrl";
        stringArray[814] = "each";
        stringArray[815] = "leftShift";
        stringArray[816] = "join";
        stringArray[817] = "isHTTPSConfigured";
        stringArray[818] = "isHTTPSConfigured";
        stringArray[819] = "getProperty";
        stringArray[820] = "WEB_HTTPS_HOST";
        stringArray[821] = "getProperty";
        stringArray[822] = "WEB_HTTP_HOST";
        stringArray[823] = "getConfiguredHttpOrHttpsPort";
        stringArray[824] = "defaultTextDevice";
        stringArray[825] = "defaultTextDevice";
        stringArray[826] = "defaultTextDevice";
        stringArray[827] = "getLogger";
        stringArray[828] = "<$constructor$>";
        stringArray[829] = "<$constructor$>";
        stringArray[830] = "format";
        stringArray[831] = "supportedProtectionSchemes";
        stringArray[832] = "lineSeparator";
        stringArray[833] = "buildFooter";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[834];
        ConfigEncryptionTool.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ConfigEncryptionTool.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ConfigEncryptionTool.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    private static /* synthetic */ Class $get$$class$org$apache$nifi$properties$ProtectedNiFiProperties() {
        Class clazz = $class$org$apache$nifi$properties$ProtectedNiFiProperties;
        if (clazz == null) {
            clazz = $class$org$apache$nifi$properties$ProtectedNiFiProperties = ConfigEncryptionTool.class$("org.apache.nifi.properties.ProtectedNiFiProperties");
        }
        return clazz;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

