/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.TxnScoreboard;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Rows;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.str.Path;
import io.questdb.tasks.ColumnPurgeTask;
import java.io.Closeable;

public class ColumnPurgeOperator
implements Closeable {
    private static final Log LOG = LogFactory.getLog(ColumnPurgeOperator.class);
    private final LongList completedRowIds = new LongList();
    private final FilesFacade ff;
    private final MicrosecondClock microClock;
    private final Path path = new Path();
    private final int pathRootLen;
    private final TableWriter purgeLogWriter;
    private final String updateCompleteColumnName;
    private final int updateCompleteColumnWriterIndex;
    private long longBytes;
    private int pathTableLen;
    private int purgeLogPartitionFd = -1;
    private long purgeLogPartitionTimestamp = Long.MAX_VALUE;
    private TxReader txReader;
    private TxnScoreboard txnScoreboard;

    public ColumnPurgeOperator(CairoConfiguration configuration, TableWriter purgeLogWriter, String updateCompleteColumnName) {
        this.ff = configuration.getFilesFacade();
        this.purgeLogWriter = purgeLogWriter;
        this.updateCompleteColumnName = updateCompleteColumnName;
        this.updateCompleteColumnWriterIndex = purgeLogWriter.getMetadata().getColumnIndex(updateCompleteColumnName);
        this.path.of(configuration.getRoot());
        this.pathRootLen = this.path.length();
        this.txnScoreboard = new TxnScoreboard(this.ff, configuration.getTxnScoreboardEntryCount());
        this.txReader = new TxReader(this.ff);
        this.microClock = configuration.getMicrosecondClock();
        this.longBytes = Unsafe.malloc(8L, 42);
    }

    public ColumnPurgeOperator(CairoConfiguration configuration) {
        this.ff = configuration.getFilesFacade();
        this.purgeLogWriter = null;
        this.updateCompleteColumnName = null;
        this.updateCompleteColumnWriterIndex = -1;
        this.path.of(configuration.getRoot());
        this.pathRootLen = this.path.length();
        this.txnScoreboard = null;
        this.txReader = null;
        this.microClock = configuration.getMicrosecondClock();
        this.longBytes = 0L;
    }

    @Override
    public void close() {
        if (this.longBytes != 0L) {
            Unsafe.free(this.longBytes, 8L, 42);
            this.longBytes = 0L;
        }
        this.closePurgeLogCompleteFile();
        Misc.free(this.path);
        this.txnScoreboard = Misc.free(this.txnScoreboard);
    }

    public boolean purge(ColumnPurgeTask task) {
        try {
            boolean done = this.purge0(task, ScoreboardUseMode.INTERNAL);
            this.setCompletionTimestamp(this.completedRowIds, this.microClock.getTicks());
            return done;
        }
        catch (Throwable ex) {
            LOG.error().$("could not purge").$(ex).$();
            return false;
        }
    }

    public boolean purge(ColumnPurgeTask task, TableReader tableReader) {
        try {
            this.txReader = tableReader.getTxFile();
            this.txnScoreboard = tableReader.getTxnScoreboard();
            return this.purge0(task, ScoreboardUseMode.EXTERNAL);
        }
        catch (Throwable ex) {
            LOG.error().$("could not purge").$(ex).$();
            return false;
        }
    }

    public void purgeExclusive(ColumnPurgeTask task) {
        try {
            this.purge0(task, ScoreboardUseMode.EXCLUSIVE);
        }
        catch (Throwable ex) {
            LOG.error().$("could not purge").$(ex).$();
        }
    }

    private static boolean couldNotRemove(FilesFacade ff, Path path) {
        if (ff.remove(path)) {
            return false;
        }
        int errno = ff.errno();
        if (ff.exists(path)) {
            LOG.info().$("cannot delete file, will retry [path=").$(path).$(", errno=").$(errno).I$();
            return true;
        }
        return false;
    }

    private boolean checkScoreboardHasReadersBeforeUpdate(long columnVersion, ColumnPurgeTask task) {
        long updateTxn = task.getUpdateTxn();
        try {
            return !this.txnScoreboard.isRangeAvailable(columnVersion + 1L, updateTxn);
        }
        catch (CairoException ex) {
            LOG.error().$("cannot lock last txn in scoreboard, column purge will re-run [table=").utf8(task.getTableName().getTableName()).$(", txn=").$(updateTxn).$(", error=").$(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).I$();
            return true;
        }
    }

    private void closePurgeLogCompleteFile() {
        if (this.ff.close(this.purgeLogPartitionFd)) {
            LOG.info().$("closed purge log complete file [fd=").$(this.purgeLogPartitionFd).I$();
            this.purgeLogPartitionFd = -1;
        }
    }

    private boolean openScoreboardAndTxn(ColumnPurgeTask task, ScoreboardUseMode scoreboardUseMode) {
        if (scoreboardUseMode == ScoreboardUseMode.INTERNAL) {
            this.txnScoreboard.ofRO(this.path.trimTo(this.pathTableLen));
        }
        if (scoreboardUseMode == ScoreboardUseMode.INTERNAL || scoreboardUseMode == ScoreboardUseMode.EXCLUSIVE) {
            int tableId = this.readTableId(this.path);
            if (tableId != task.getTableId()) {
                LOG.info().$("cannot purge orphan table [path=").utf8(this.path.trimTo(this.pathTableLen)).I$();
                return false;
            }
            this.path.trimTo(this.pathTableLen).concat("_txn");
            this.txReader.ofRO(this.path.$(), task.getPartitionBy());
            this.txReader.unsafeLoadAll();
            if (this.txReader.getTruncateVersion() != task.getTruncateVersion()) {
                LOG.info().$("cannot purge, purge request overlaps with truncate [path=").$(this.path.trimTo(this.pathTableLen)).I$();
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean purge0(ColumnPurgeTask task, ScoreboardUseMode scoreboardMode) {
        LOG.info().$("purging [table=").utf8(task.getTableName().getTableName()).$(", column=").utf8(task.getColumnName()).$(", tableId=").$(task.getTableId()).I$();
        this.setTablePath(task.getTableName());
        LongList updatedColumnInfo = task.getUpdatedColumnInfo();
        long minUnlockedTxnRangeStarts = Long.MAX_VALUE;
        boolean allDone = true;
        boolean setupScoreboard = scoreboardMode != ScoreboardUseMode.EXTERNAL;
        try {
            this.completedRowIds.clear();
            int n = updatedColumnInfo.size();
            for (int i = 0; i < n; i += 4) {
                long columnVersion = updatedColumnInfo.getQuick(i + 0);
                long partitionTimestamp = updatedColumnInfo.getQuick(i + 1);
                long partitionTxnName = updatedColumnInfo.getQuick(i + 2);
                long updateRowId = updatedColumnInfo.getQuick(i + 3);
                this.setUpPartitionPath(task.getPartitionBy(), partitionTimestamp, partitionTxnName);
                int pathTrimToPartition = this.path.length();
                TableUtils.dFile(this.path, task.getColumnName(), columnVersion);
                if (!this.ff.exists(this.path)) {
                    if (ColumnType.isVariableLength(task.getColumnType())) {
                        this.path.trimTo(pathTrimToPartition);
                        TableUtils.iFile(this.path, task.getColumnName(), columnVersion);
                        if (!this.ff.exists(this.path)) {
                            this.completedRowIds.add(updateRowId);
                            continue;
                        }
                    } else {
                        this.completedRowIds.add(updateRowId);
                        continue;
                    }
                }
                if (setupScoreboard) {
                    if (!this.openScoreboardAndTxn(task, scoreboardMode)) {
                        this.completedRowIds.add(updateRowId);
                        continue;
                    }
                    this.setUpPartitionPath(task.getPartitionBy(), partitionTimestamp, partitionTxnName);
                    TableUtils.dFile(this.path, task.getColumnName(), columnVersion);
                    setupScoreboard = false;
                }
                if (this.txReader.isPartitionReadOnlyByPartitionTimestamp(partitionTimestamp)) {
                    LOG.info().$("skipping purge of read-only partition [path=").utf8(this.path.$()).$(", column=").utf8(task.getColumnName()).I$();
                    this.completedRowIds.add(updateRowId);
                    continue;
                }
                if (columnVersion < minUnlockedTxnRangeStarts) {
                    if (scoreboardMode != ScoreboardUseMode.EXCLUSIVE && this.checkScoreboardHasReadersBeforeUpdate(columnVersion, task)) {
                        allDone = false;
                        LOG.debug().$("cannot purge, version is in use [path=").$(this.path).I$();
                        continue;
                    }
                    minUnlockedTxnRangeStarts = columnVersion;
                }
                LOG.info().$("purging [path=").$(this.path).I$();
                if (ColumnPurgeOperator.couldNotRemove(this.ff, this.path)) {
                    allDone = false;
                    continue;
                }
                if (ColumnType.isVariableLength(task.getColumnType())) {
                    this.path.trimTo(pathTrimToPartition);
                    TableUtils.iFile(this.path, task.getColumnName(), columnVersion);
                    if (ColumnPurgeOperator.couldNotRemove(this.ff, this.path)) {
                        allDone = false;
                        continue;
                    }
                }
                if (ColumnType.isSymbol(task.getColumnType())) {
                    this.path.trimTo(pathTrimToPartition);
                    BitmapIndexUtils.keyFileName(this.path, task.getColumnName(), columnVersion);
                    if (ColumnPurgeOperator.couldNotRemove(this.ff, this.path)) {
                        allDone = false;
                        continue;
                    }
                    this.path.trimTo(pathTrimToPartition);
                    BitmapIndexUtils.valueFileName(this.path, task.getColumnName(), columnVersion);
                    if (ColumnPurgeOperator.couldNotRemove(this.ff, this.path)) {
                        allDone = false;
                        continue;
                    }
                }
                this.completedRowIds.add(updateRowId);
            }
        }
        finally {
            if (scoreboardMode != ScoreboardUseMode.EXTERNAL) {
                Misc.free(this.txnScoreboard);
                Misc.free(this.txReader);
            }
        }
        return allDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readTableId(Path path) {
        int INVALID_TABLE_ID = Integer.MIN_VALUE;
        int fd = this.ff.openRO(path.trimTo(this.pathTableLen).concat("_meta").$());
        if (fd < 0) {
            return Integer.MIN_VALUE;
        }
        try {
            if (this.ff.read(fd, this.longBytes, 4L, 16L) != 4L) {
                int n = Integer.MIN_VALUE;
                return n;
            }
            int n = Unsafe.getUnsafe().getInt(this.longBytes);
            return n;
        }
        finally {
            this.ff.close(fd);
        }
    }

    private void reopenPurgeLogPartition(int partitionIndex, long partitionTimestamp) {
        this.path.trimTo(this.pathRootLen);
        this.path.concat(this.purgeLogWriter.getTableToken());
        long partitionNameTxn = this.purgeLogWriter.getPartitionNameTxn(partitionIndex);
        TableUtils.setPathForPartition(this.path, this.purgeLogWriter.getPartitionBy(), partitionTimestamp, false);
        TableUtils.txnPartitionConditionally(this.path, partitionNameTxn);
        TableUtils.dFile(this.path, this.updateCompleteColumnName, this.purgeLogWriter.getColumnNameTxn(partitionTimestamp, this.updateCompleteColumnWriterIndex));
        this.closePurgeLogCompleteFile();
        this.purgeLogPartitionFd = TableUtils.openRW(this.ff, this.path.$(), LOG, this.purgeLogWriter.getConfiguration().getWriterFileOpenOpts());
        this.purgeLogPartitionTimestamp = partitionTimestamp;
        LOG.info().$("reopened purge log complete file [path=").$(this.path).$(", fd=").$(this.purgeLogPartitionFd).I$();
    }

    private void setCompletionTimestamp(LongList completedRecordIds, long timeMicro) {
        try {
            Unsafe.getUnsafe().putLong(this.longBytes, timeMicro);
            int n = completedRecordIds.size();
            for (int rec = 0; rec < n; ++rec) {
                long partitionTimestamp;
                long recordId = completedRecordIds.getQuick(rec);
                int partitionIndex = Rows.toPartitionIndex(recordId);
                if (rec == 0 && this.purgeLogPartitionTimestamp != (partitionTimestamp = this.purgeLogWriter.getPartitionTimestamp(partitionIndex))) {
                    this.reopenPurgeLogPartition(partitionIndex, partitionTimestamp);
                }
                long rowId = Rows.toLocalRowID(recordId);
                long offset = rowId * 8L;
                if (this.ff.write(this.purgeLogPartitionFd, this.longBytes, 8L, rowId * 8L) == 8L) continue;
                int errno = this.ff.errno();
                long length = this.ff.length(this.purgeLogPartitionFd);
                LOG.error().$("could not mark record as purged [errno=").$(errno).$(", writeOffset=").$(offset).$(", fd=").$(this.purgeLogPartitionFd).$(", fileSize=").$(length).I$();
                this.purgeLogPartitionTimestamp = -1L;
            }
        }
        catch (CairoException ex) {
            LOG.error().$("could not update completion timestamp").$(ex).$();
        }
    }

    private void setTablePath(TableToken tableName) {
        this.path.trimTo(this.pathRootLen).concat(tableName);
        this.pathTableLen = this.path.length();
    }

    private void setUpPartitionPath(int partitionBy, long partitionTimestamp, long partitionTxnName) {
        this.path.trimTo(this.pathTableLen);
        TableUtils.setPathForPartition(this.path, partitionBy, partitionTimestamp, false);
        TableUtils.txnPartitionConditionally(this.path, partitionTxnName);
    }

    private static enum ScoreboardUseMode {
        INTERNAL,
        EXTERNAL,
        EXCLUSIVE;

    }
}

