/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.CommitFailedException;
import io.questdb.cairo.EntryUnavailableException;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.cairo.wal.WalWriter;
import io.questdb.cutlass.line.LineProtoTimestampAdapter;
import io.questdb.cutlass.line.tcp.DefaultColumnTypes;
import io.questdb.cutlass.line.tcp.LineTcpConnectionContext;
import io.questdb.cutlass.line.tcp.LineTcpMeasurementEvent;
import io.questdb.cutlass.line.tcp.LineTcpNetworkIOJob;
import io.questdb.cutlass.line.tcp.LineTcpParser;
import io.questdb.cutlass.line.tcp.LineTcpReceiver;
import io.questdb.cutlass.line.tcp.LineTcpReceiverConfiguration;
import io.questdb.cutlass.line.tcp.LineTcpWriterJob;
import io.questdb.cutlass.line.tcp.NetworkIOJob;
import io.questdb.cutlass.line.tcp.TableStructureAdapter;
import io.questdb.cutlass.line.tcp.TableUpdateDetails;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.MPSequence;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.mp.WorkerPool;
import io.questdb.network.IODispatcher;
import io.questdb.std.ByteCharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.LowerCaseCharSequenceObjHashMap;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.Os;
import io.questdb.std.SimpleReadWriteLock;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.ByteCharSequence;
import io.questdb.std.str.DirectByteCharSequence;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import io.questdb.tasks.TelemetryTask;
import java.io.Closeable;
import java.util.Arrays;
import java.util.concurrent.locks.ReadWriteLock;
import org.jetbrains.annotations.NotNull;

class LineTcpMeasurementScheduler
implements Closeable {
    private static final Log LOG = LogFactory.getLog(LineTcpMeasurementScheduler.class);
    private final ObjList<TableUpdateDetails>[] assignedTables;
    private final boolean autoCreateNewColumns;
    private final boolean autoCreateNewTables;
    private final CairoConfiguration cairoConfiguration;
    private final LineTcpReceiverConfiguration configuration;
    private final MemoryMARW ddlMem = Vm.getMARWInstance();
    private final DefaultColumnTypes defaultColumnTypes;
    private final CairoEngine engine;
    private final LowerCaseCharSequenceObjHashMap<TableUpdateDetails> idleTableUpdateDetailsUtf16;
    private final long[] loadByWriterThread;
    private final NetworkIOJob[] netIoJobs;
    private final Path path = new Path();
    private final MPSequence[] pubSeq;
    private final RingQueue<LineTcpMeasurementEvent>[] queue;
    private final CairoSecurityContext securityContext;
    private final StringSink[] tableNameSinks;
    private final TableStructureAdapter tableStructureAdapter;
    private final ReadWriteLock tableUpdateDetailsLock = new SimpleReadWriteLock();
    private final LowerCaseCharSequenceObjHashMap<TableUpdateDetails> tableUpdateDetailsUtf16;
    private final long writerIdleTimeout;
    private LineTcpReceiver.SchedulerListener listener;

    LineTcpMeasurementScheduler(LineTcpReceiverConfiguration lineConfiguration, CairoEngine engine, WorkerPool ioWorkerPool, IODispatcher<LineTcpConnectionContext> dispatcher, WorkerPool writerWorkerPool) {
        this.engine = engine;
        this.securityContext = lineConfiguration.getCairoSecurityContext();
        this.cairoConfiguration = engine.getConfiguration();
        this.configuration = lineConfiguration;
        MillisecondClock milliClock = this.cairoConfiguration.getMillisecondClock();
        this.defaultColumnTypes = new DefaultColumnTypes(lineConfiguration);
        int n = ioWorkerPool.getWorkerCount();
        this.netIoJobs = new NetworkIOJob[n];
        this.tableNameSinks = new StringSink[n];
        for (int i = 0; i < n; ++i) {
            NetworkIOJob netIoJob;
            this.tableNameSinks[i] = new StringSink();
            this.netIoJobs[i] = netIoJob = this.createNetworkIOJob(dispatcher, i);
            ioWorkerPool.assign(i, netIoJob);
            ioWorkerPool.freeOnExit(netIoJob);
        }
        this.tableUpdateDetailsUtf16 = new LowerCaseCharSequenceObjHashMap();
        this.idleTableUpdateDetailsUtf16 = new LowerCaseCharSequenceObjHashMap();
        this.loadByWriterThread = new long[writerWorkerPool.getWorkerCount()];
        this.autoCreateNewTables = lineConfiguration.getAutoCreateNewTables();
        this.autoCreateNewColumns = lineConfiguration.getAutoCreateNewColumns();
        int maxMeasurementSize = lineConfiguration.getMaxMeasurementSize();
        int queueSize = lineConfiguration.getWriterQueueCapacity();
        long commitIntervalDefault = this.configuration.getCommitIntervalDefault();
        int nWriterThreads = writerWorkerPool.getWorkerCount();
        this.pubSeq = new MPSequence[nWriterThreads];
        this.queue = new RingQueue[nWriterThreads];
        this.assignedTables = new ObjList[nWriterThreads];
        for (int i = 0; i < nWriterThreads; ++i) {
            MPSequence ps;
            this.pubSeq[i] = ps = new MPSequence(queueSize);
            RingQueue<LineTcpMeasurementEvent> q = new RingQueue<LineTcpMeasurementEvent>((address, addressSize) -> new LineTcpMeasurementEvent(address, addressSize, lineConfiguration.getMicrosecondClock(), lineConfiguration.getTimestampAdapter(), this.defaultColumnTypes, lineConfiguration.isStringToCharCastAllowed(), lineConfiguration.getMaxFileNameLength(), lineConfiguration.getAutoCreateNewColumns()), LineTcpMeasurementScheduler.getEventSlotSize(maxMeasurementSize), queueSize, 46);
            this.queue[i] = q;
            SCSequence subSeq = new SCSequence();
            ps.then(subSeq).then(ps);
            this.assignedTables[i] = new ObjList();
            LineTcpWriterJob lineTcpWriterJob = new LineTcpWriterJob(i, q, subSeq, milliClock, commitIntervalDefault, this, engine.getMetrics(), this.assignedTables[i]);
            writerWorkerPool.assign(i, lineTcpWriterJob);
            writerWorkerPool.freeOnExit(lineTcpWriterJob);
        }
        this.tableStructureAdapter = new TableStructureAdapter(this.cairoConfiguration, this.defaultColumnTypes, this.configuration.getDefaultPartitionBy());
        this.writerIdleTimeout = lineConfiguration.getWriterIdleTimeout();
    }

    @Override
    public void close() {
        int i;
        this.tableUpdateDetailsLock.writeLock().lock();
        try {
            this.closeLocals(this.tableUpdateDetailsUtf16);
            this.closeLocals(this.idleTableUpdateDetailsUtf16);
        }
        finally {
            this.tableUpdateDetailsLock.writeLock().unlock();
        }
        Misc.free(this.path);
        Misc.free(this.ddlMem);
        int n = this.assignedTables.length;
        for (i = 0; i < n; ++i) {
            Misc.freeObjList(this.assignedTables[i]);
            this.assignedTables[i].clear();
        }
        n = this.queue.length;
        for (i = 0; i < n; ++i) {
            Misc.free(this.queue[i]);
        }
        n = this.netIoJobs.length;
        for (i = 0; i < n; ++i) {
            this.netIoJobs[i].close();
        }
    }

    public long commitWalTables(ByteCharSequenceObjHashMap<TableUpdateDetails> tableUpdateDetailsUtf8, long wallClockMillis) {
        long minTableNextCommitTime = Long.MAX_VALUE;
        int sz = tableUpdateDetailsUtf8.size();
        for (int n = 0; n < sz; ++n) {
            ByteCharSequence tableNameUtf8 = tableUpdateDetailsUtf8.keys().get(n);
            TableUpdateDetails tud = tableUpdateDetailsUtf8.get(tableNameUtf8);
            if (tud.getWriterThreadId() != -1) continue;
            MillisecondClock millisecondClock = tud.getMillisecondClock();
            try {
                long tableNextCommitTime = tud.commitIfIntervalElapsed(wallClockMillis);
                wallClockMillis = millisecondClock.getTicks();
                if (tableNextCommitTime >= minTableNextCommitTime) continue;
                minTableNextCommitTime = tableNextCommitTime;
                continue;
            }
            catch (Throwable ex) {
                LOG.critical().$("commit failed [table=").$(tud.getTableNameUtf16()).$(",ex=").$(ex).I$();
                this.engine.getMetrics().health().incrementUnhandledErrors();
            }
        }
        long commitIntervalDefault = this.configuration.getCommitIntervalDefault();
        return minTableNextCommitTime != Long.MAX_VALUE ? minTableNextCommitTime : wallClockMillis + commitIntervalDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doMaintenance(ByteCharSequenceObjHashMap<TableUpdateDetails> tableUpdateDetailsUtf8, int readerWorkerId, long millis) {
        int sz = tableUpdateDetailsUtf8.size();
        for (int n = 0; n < sz; ++n) {
            ByteCharSequence tableNameUtf8 = tableUpdateDetailsUtf8.keys().get(n);
            TableUpdateDetails tud = tableUpdateDetailsUtf8.get(tableNameUtf8);
            if (millis - tud.getLastMeasurementMillis() < this.writerIdleTimeout) continue;
            this.tableUpdateDetailsLock.writeLock().lock();
            try {
                if (tud.getNetworkIOOwnerCount() == 1) {
                    int writerWorkerId = tud.getWriterThreadId();
                    long seq = this.getNextPublisherEventSequence(writerWorkerId);
                    if (seq > -1L) {
                        LineTcpMeasurementEvent event = this.queue[writerWorkerId].get(seq);
                        event.createWriterReleaseEvent(tud, true);
                        tableUpdateDetailsUtf8.remove(tableNameUtf8);
                        String tableNameUtf16 = tud.getTableNameUtf16();
                        this.tableUpdateDetailsUtf16.remove(tableNameUtf16);
                        this.idleTableUpdateDetailsUtf16.put(tableNameUtf16, tud);
                        tud.removeReference(readerWorkerId);
                        this.pubSeq[writerWorkerId].done(seq);
                        if (this.listener != null) {
                            this.listener.onEvent(tud.getTableToken(), 1);
                        }
                        LOG.info().$("active table going idle [tableName=").$(tableNameUtf16).I$();
                    }
                    boolean bl = true;
                    return bl;
                }
                tableUpdateDetailsUtf8.remove(tableNameUtf8);
                tud.removeReference(readerWorkerId);
                if (tud.getWriterThreadId() == -1) {
                    if (this.listener != null) {
                        this.listener.onEvent(tud.getTableToken(), 1);
                    }
                    tud.releaseWriter(true);
                    tud.close();
                }
                boolean bl = sz > 1;
                return bl;
            }
            finally {
                this.tableUpdateDetailsLock.writeLock().unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processWriterReleaseEvent(LineTcpMeasurementEvent event, int workerId) {
        this.tableUpdateDetailsLock.readLock().lock();
        try {
            TableUpdateDetails tub = event.getTableUpdateDetails();
            if (tub.getWriterThreadId() != workerId) {
                return;
            }
            if (!event.getTableUpdateDetails().isWriterInError() && this.tableUpdateDetailsUtf16.keyIndex(tub.getTableNameUtf16()) < 0) {
                return;
            }
            LOG.info().$("releasing writer, its been idle since ").$ts(tub.getLastMeasurementMillis() * 1000L).$("[tableName=").$(tub.getTableNameUtf16()).I$();
            event.releaseWriter();
        }
        finally {
            this.tableUpdateDetailsLock.readLock().unlock();
        }
    }

    private static long getEventSlotSize(int maxMeasurementSize) {
        return Numbers.ceilPow2((long)(maxMeasurementSize / 4) * 13L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void appendToWal(NetworkIOJob netIoJob, LineTcpParser parser, TableUpdateDetails tud) throws CommitFailedException {
        long timestamp;
        boolean stringToCharCastAllowed = this.configuration.isStringToCharCastAllowed();
        LineProtoTimestampAdapter timestampAdapter = this.configuration.getTimestampAdapter();
        TableUpdateDetails.ThreadLocalDetails ld = tud.getThreadLocalDetails(netIoJob.getWorkerId());
        ld.resetStateIfNecessary();
        ld.clearColumnTypes();
        WalWriter ww = (WalWriter)tud.getWriter();
        TableRecordMetadata metadata = ww.getMetadata();
        if (ld.getStructureVersion() > ww.getStructureVersion()) {
            ww.commit();
        }
        timestamp = (timestamp = parser.getTimestamp()) != Long.MIN_VALUE ? timestampAdapter.getMicros(timestamp) : this.configuration.getMicrosecondClock().getTicks();
        int entCount = parser.getEntityCount();
        for (int i = 0; i < entCount; ++i) {
            int columnType;
            int columnIndex;
            block75: {
                LineTcpParser.ProtoEntity ent;
                block74: {
                    ent = parser.getEntity(i);
                    columnIndex = ld.getColumnIndex(ent.getName(), parser.hasNonAsciiChars(), metadata);
                    columnType = 0;
                    if (columnIndex != -1) break block74;
                    String columnNameUtf16 = ld.getColNameUtf16();
                    if (this.autoCreateNewColumns && TableUtils.isValidColumnName(columnNameUtf16, this.cairoConfiguration.getMaxFileNameLength())) {
                        block73: {
                            if (metadata.getColumnIndexQuiet(columnNameUtf16) < 0) {
                                ww.commit();
                                try {
                                    ww.addColumn(columnNameUtf16, ld.getColumnType(ld.getColNameUtf8(), ent.getType()));
                                }
                                catch (CairoException e) {
                                    columnIndex = metadata.getColumnIndexQuiet(columnNameUtf16);
                                    if (columnIndex >= 0) break block73;
                                    throw e;
                                }
                            }
                        }
                        columnIndex = metadata.getColumnIndexQuiet(columnNameUtf16);
                        columnType = metadata.getColumnType(columnIndex);
                        break block75;
                    } else {
                        if (this.autoCreateNewColumns) throw LineTcpMeasurementEvent.invalidColNameError(tud, columnNameUtf16);
                        throw LineTcpMeasurementEvent.newColumnsNotAllowed(tud, columnNameUtf16);
                    }
                }
                if (columnIndex > -1) {
                    if (columnIndex == tud.getTimestampIndex()) {
                        timestamp = timestampAdapter.getMicros(ent.getLongValue());
                        columnIndex = -2;
                    }
                    columnType = columnIndex < 0 ? 0 : metadata.getColumnType(columnIndex);
                }
            }
            ld.addColumnType(columnIndex, columnType);
        }
        TableWriter.Row r = ww.newRow(timestamp);
        try {
            int i = 0;
            while (true) {
                if (i >= entCount) {
                    r.append();
                    tud.commitIfMaxUncommittedRowsCountReached();
                    return;
                }
                LineTcpParser.ProtoEntity ent = parser.getEntity(i);
                short entType = ent.getType();
                int colTypeAndIndex = ld.getColumnType(i);
                short colType = Numbers.decodeLowShort(colTypeAndIndex);
                short columnIndex = Numbers.decodeHighShort(colTypeAndIndex);
                if (columnIndex >= 0) {
                    block3 : switch (entType) {
                        case 1: {
                            if (ColumnType.tagOf(colType) != 12) throw LineTcpMeasurementEvent.castError("tag", i, colType, ent.getName());
                            r.putSymUtf8(columnIndex, ent.getValue(), parser.hasNonAsciiChars());
                            break;
                        }
                        case 3: {
                            switch (ColumnType.tagOf(colType)) {
                                case 6: {
                                    r.putLong(columnIndex, ent.getLongValue());
                                    break block3;
                                }
                                case 5: {
                                    long entityValue = ent.getLongValue();
                                    if (entityValue >= Integer.MIN_VALUE && entityValue <= Integer.MAX_VALUE) {
                                        r.putInt(columnIndex, (int)entityValue);
                                        break block3;
                                    }
                                    if (entityValue != Long.MIN_VALUE) throw LineTcpMeasurementEvent.boundsError(entityValue, i, 5);
                                    r.putInt(columnIndex, Integer.MIN_VALUE);
                                    break block3;
                                }
                                case 3: {
                                    long entityValue = ent.getLongValue();
                                    if (entityValue >= -32768L && entityValue <= 32767L) {
                                        r.putShort(columnIndex, (short)entityValue);
                                        break block3;
                                    }
                                    if (entityValue != Long.MIN_VALUE) throw LineTcpMeasurementEvent.boundsError(entityValue, i, 3);
                                    r.putShort(columnIndex, (short)0);
                                    break block3;
                                }
                                case 2: {
                                    long entityValue = ent.getLongValue();
                                    if (entityValue >= -128L && entityValue <= 127L) {
                                        r.putByte(columnIndex, (byte)entityValue);
                                        break block3;
                                    }
                                    if (entityValue != Long.MIN_VALUE) throw LineTcpMeasurementEvent.boundsError(entityValue, i, 2);
                                    r.putByte(columnIndex, (byte)0);
                                    break block3;
                                }
                                case 8: {
                                    r.putTimestamp(columnIndex, ent.getLongValue());
                                    break block3;
                                }
                                case 7: {
                                    r.putDate(columnIndex, ent.getLongValue());
                                    break block3;
                                }
                                case 10: {
                                    r.putDouble(columnIndex, ent.getLongValue());
                                    break block3;
                                }
                                case 9: {
                                    r.putFloat(columnIndex, ent.getLongValue());
                                    break block3;
                                }
                                case 12: {
                                    r.putSym((int)columnIndex, ent.getValue());
                                    break block3;
                                }
                            }
                            throw LineTcpMeasurementEvent.castError("integer", i, colType, ent.getName());
                        }
                        case 2: {
                            switch (ColumnType.tagOf(colType)) {
                                case 10: {
                                    r.putDouble(columnIndex, ent.getFloatValue());
                                    break block3;
                                }
                                case 9: {
                                    r.putFloat(columnIndex, (float)ent.getFloatValue());
                                    break block3;
                                }
                                case 12: {
                                    r.putSym((int)columnIndex, ent.getValue());
                                    break block3;
                                }
                            }
                            throw LineTcpMeasurementEvent.castError("float", i, colType, ent.getName());
                        }
                        case 4: {
                            long geoHash;
                            int geoHashBits = ColumnType.getGeoHashBits(colType);
                            DirectByteCharSequence entityValue = ent.getValue();
                            if (geoHashBits == 0) {
                                switch (ColumnType.tagOf(colType)) {
                                    case 11: {
                                        r.putStrUtf8AsUtf16(columnIndex, entityValue, parser.hasNonAsciiChars());
                                        break block3;
                                    }
                                    case 4: {
                                        if (entityValue.length() == 1 && entityValue.byteAt(0) > -1) {
                                            r.putChar(columnIndex, entityValue.charAt(0));
                                            break block3;
                                        }
                                        if (!stringToCharCastAllowed) throw LineTcpMeasurementEvent.castError("string", i, colType, ent.getName());
                                        int encodedResult = Chars.utf8CharDecode(entityValue.getLo(), entityValue.getHi());
                                        if (Numbers.decodeLowShort(encodedResult) <= 0) throw LineTcpMeasurementEvent.castError("string", i, colType, ent.getName());
                                        r.putChar(columnIndex, (char)Numbers.decodeHighShort(encodedResult));
                                        break block3;
                                    }
                                    case 12: {
                                        r.putSymUtf8(columnIndex, entityValue, parser.hasNonAsciiChars());
                                        break block3;
                                    }
                                    case 19: {
                                        r.putUuid(columnIndex, entityValue);
                                        break block3;
                                    }
                                }
                                throw LineTcpMeasurementEvent.castError("string", i, colType, ent.getName());
                            }
                            try {
                                DirectByteCharSequence value = ent.getValue();
                                geoHash = GeoHashes.fromStringTruncatingNl(value.getLo(), value.getHi(), geoHashBits);
                            }
                            catch (NumericException e) {
                                geoHash = -1L;
                            }
                            r.putGeoHash(columnIndex, geoHash);
                            break;
                        }
                        case 7: {
                            switch (ColumnType.tagOf(colType)) {
                                case 13: {
                                    r.putLong256((int)columnIndex, ent.getValue());
                                    break block3;
                                }
                                case 12: {
                                    r.putSym((int)columnIndex, ent.getValue());
                                    break block3;
                                }
                            }
                            throw LineTcpMeasurementEvent.castError("long256", i, colType, ent.getName());
                        }
                        case 6: {
                            switch (ColumnType.tagOf(colType)) {
                                case 1: {
                                    r.putBool(columnIndex, ent.getBooleanValue());
                                    break block3;
                                }
                                case 2: {
                                    r.putByte(columnIndex, (byte)(ent.getBooleanValue() ? 1 : 0));
                                    break block3;
                                }
                                case 3: {
                                    r.putShort(columnIndex, (short)(ent.getBooleanValue() ? 1 : 0));
                                    break block3;
                                }
                                case 5: {
                                    r.putInt(columnIndex, ent.getBooleanValue() ? 1 : 0);
                                    break block3;
                                }
                                case 6: {
                                    r.putLong(columnIndex, ent.getBooleanValue() ? 1L : 0L);
                                    break block3;
                                }
                                case 9: {
                                    r.putFloat(columnIndex, ent.getBooleanValue() ? 1.0f : 0.0f);
                                    break block3;
                                }
                                case 10: {
                                    r.putDouble(columnIndex, ent.getBooleanValue() ? 1.0 : 0.0);
                                    break block3;
                                }
                                case 12: {
                                    r.putSym((int)columnIndex, ent.getValue());
                                    break block3;
                                }
                            }
                            throw LineTcpMeasurementEvent.castError("boolean", i, colType, ent.getName());
                        }
                        case 13: {
                            switch (ColumnType.tagOf(colType)) {
                                case 8: {
                                    r.putTimestamp(columnIndex, ent.getLongValue());
                                    break block3;
                                }
                                case 7: {
                                    r.putTimestamp(columnIndex, ent.getLongValue() / 1000L);
                                    break block3;
                                }
                                case 12: {
                                    r.putSym((int)columnIndex, ent.getValue());
                                    break block3;
                                }
                            }
                            throw LineTcpMeasurementEvent.castError("timestamp", i, colType, ent.getName());
                        }
                        case 5: {
                            if (ColumnType.tagOf(colType) != 12) throw LineTcpMeasurementEvent.castError("symbol", i, colType, ent.getName());
                            r.putSymUtf8(columnIndex, ent.getValue(), parser.hasNonAsciiChars());
                            break;
                        }
                    }
                }
                ++i;
            }
        }
        catch (CommitFailedException commitFailedException) {
            throw commitFailedException;
        }
        catch (Throwable th) {
            LOG.error().$("could not write line protocol measurement [tableName=").$(tud.getTableNameUtf16()).$(", message=").$(th.getMessage()).$(th).I$();
            if (r == null) return;
            r.cancel();
        }
    }

    private void closeLocals(LowerCaseCharSequenceObjHashMap<TableUpdateDetails> tudUtf16) {
        ObjList tableNames = tudUtf16.keys();
        int sz = tableNames.size();
        for (int n = 0; n < sz; ++n) {
            tudUtf16.get((CharSequence)tableNames.get(n)).closeLocals();
        }
        tudUtf16.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dispatchEvent(NetworkIOJob netIoJob, LineTcpParser parser, TableUpdateDetails tud) {
        int writerThreadId = tud.getWriterThreadId();
        long seq = this.getNextPublisherEventSequence(writerThreadId);
        if (seq > -1L) {
            try {
                if (tud.isWriterInError()) {
                    throw CairoException.critical(0).put("writer is in error, aborting ILP pipeline");
                }
                this.queue[writerThreadId].get(seq).createMeasurementEvent(tud, parser, netIoJob.getWorkerId());
            }
            finally {
                this.pubSeq[writerThreadId].done(seq);
            }
            tud.incrementEventsProcessedSinceReshuffle();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableUpdateDetails getTableUpdateDetailsFromSharedArea(@NotNull NetworkIOJob netIoJob, @NotNull LineTcpParser parser) {
        DirectByteCharSequence tableNameUtf8 = parser.getMeasurementName();
        StringSink tableNameUtf16 = this.tableNameSinks[netIoJob.getWorkerId()];
        tableNameUtf16.clear();
        Chars.utf8Decode(tableNameUtf8.getLo(), tableNameUtf8.getHi(), tableNameUtf16);
        this.tableUpdateDetailsLock.writeLock().lock();
        try {
            TableUpdateDetails tud;
            int tudKeyIndex = this.tableUpdateDetailsUtf16.keyIndex(tableNameUtf16);
            if (tudKeyIndex < 0) {
                tud = this.tableUpdateDetailsUtf16.valueAt(tudKeyIndex);
            } else {
                int idleTudKeyIndex;
                TableToken tableToken = this.engine.getTableTokenIfExists(tableNameUtf16);
                int status = this.engine.getStatus(this.securityContext, this.path, tableToken);
                if (status != 0) {
                    if (!this.autoCreateNewTables) {
                        throw CairoException.nonCritical().put("table does not exist, creating new tables is disabled [table=").put(tableNameUtf16).put(']');
                    }
                    if (!this.autoCreateNewColumns) {
                        throw CairoException.nonCritical().put("table does not exist, cannot create table, creating new columns is disabled [table=").put(tableNameUtf16).put(']');
                    }
                    TableStructureAdapter tsa = this.tableStructureAdapter.of(tableNameUtf16, parser);
                    int n = tsa.getColumnCount();
                    for (int i = 0; i < n; ++i) {
                        if (tsa.getColumnType(i) != 0) continue;
                        throw CairoException.nonCritical().put("unknown column type [columnName=").put(tsa.getColumnName(i)).put(']');
                    }
                    LOG.info().$("creating table [tableName=").$(tableNameUtf16).$(']').$();
                    tableToken = this.engine.createTable(this.securityContext, this.ddlMem, this.path, true, tsa, false);
                }
                if ((idleTudKeyIndex = this.idleTableUpdateDetailsUtf16.keyIndex(tableNameUtf16)) < 0) {
                    tud = this.idleTableUpdateDetailsUtf16.valueAt(idleTudKeyIndex);
                    LOG.info().$("idle table going active [tableName=").$(tud.getTableNameUtf16()).I$();
                    if (tud.getWriter() == null) {
                        tud.closeNoLock();
                        tud = this.unsafeAssignTableToWriterThread(tudKeyIndex, tud.getTableNameUtf16());
                    } else {
                        this.idleTableUpdateDetailsUtf16.removeAt(idleTudKeyIndex);
                        this.tableUpdateDetailsUtf16.putAt(tudKeyIndex, tud.getTableNameUtf16(), tud);
                    }
                } else {
                    TelemetryTask.doStoreTelemetry(this.engine, (short)102, (short)5);
                    this.path.of(this.engine.getConfiguration().getRoot());
                    tud = this.engine.isWalTable(tableToken) ? new TableUpdateDetails(this.configuration, this.engine, this.engine.getWalWriter(this.securityContext, tableToken), -1, this.netIoJobs, this.defaultColumnTypes) : this.unsafeAssignTableToWriterThread(tudKeyIndex, tableNameUtf16);
                }
            }
            netIoJob.addTableUpdateDetails(ByteCharSequence.newInstance(tableNameUtf8), tud);
            TableUpdateDetails tableUpdateDetails = tud;
            return tableUpdateDetails;
        }
        finally {
            this.tableUpdateDetailsLock.writeLock().unlock();
        }
    }

    private boolean isOpen() {
        return null != this.pubSeq;
    }

    @NotNull
    private TableUpdateDetails unsafeAssignTableToWriterThread(int tudKeyIndex, CharSequence tableNameUtf16) {
        this.unsafeCalcThreadLoad();
        long leastLoad = Long.MAX_VALUE;
        int threadId = 0;
        int n = this.loadByWriterThread.length;
        for (int i = 0; i < n; ++i) {
            if (this.loadByWriterThread[i] >= leastLoad) continue;
            leastLoad = this.loadByWriterThread[i];
            threadId = i;
        }
        TableToken tableToken = this.engine.getTableToken(tableNameUtf16);
        TableUpdateDetails tud = new TableUpdateDetails(this.configuration, this.engine, this.engine.getTableWriterAPI(this.securityContext, tableToken, "tcpIlp"), threadId, this.netIoJobs, this.defaultColumnTypes);
        this.tableUpdateDetailsUtf16.putAt(tudKeyIndex, tud.getTableNameUtf16(), tud);
        LOG.info().$("assigned ").$(tableToken).$(" to thread ").$(threadId).$();
        return tud;
    }

    private void unsafeCalcThreadLoad() {
        Arrays.fill(this.loadByWriterThread, 0L);
        ObjList tableNames = this.tableUpdateDetailsUtf16.keys();
        int sz = tableNames.size();
        for (int n = 0; n < sz; ++n) {
            CharSequence tableName = (CharSequence)tableNames.getQuick(n);
            TableUpdateDetails stats = this.tableUpdateDetailsUtf16.get(tableName);
            if (stats != null) {
                int n2 = stats.getWriterThreadId();
                this.loadByWriterThread[n2] = this.loadByWriterThread[n2] + stats.getEventsProcessedSinceReshuffle();
                continue;
            }
            LOG.error().$("could not find statistic for table [name=").$(tableName).I$();
        }
    }

    protected NetworkIOJob createNetworkIOJob(IODispatcher<LineTcpConnectionContext> dispatcher, int workerId) {
        return new LineTcpNetworkIOJob(this.configuration, this, dispatcher, workerId);
    }

    long getNextPublisherEventSequence(int writerWorkerId) {
        long seq;
        assert (this.isOpen());
        while ((seq = this.pubSeq[writerWorkerId].next()) == -2L) {
            Os.pause();
        }
        return seq;
    }

    boolean scheduleEvent(NetworkIOJob netIoJob, LineTcpParser parser) {
        TableUpdateDetails tud;
        try {
            tud = netIoJob.getLocalTableDetails(parser.getMeasurementName());
            if (tud == null) {
                tud = this.getTableUpdateDetailsFromSharedArea(netIoJob, parser);
            }
        }
        catch (EntryUnavailableException ex) {
            LOG.info().$("could not get table writer [tableName=").$(parser.getMeasurementName()).$(", ex=`").$(ex.getFlyweightMessage()).$("`]").$();
            return true;
        }
        catch (CairoException ex) {
            LOG.error().$("could not create table [tableName=").$(parser.getMeasurementName()).$(", errno=").$(ex.getErrno()).I$();
            throw ex;
        }
        if (tud.getWriterThreadId() == -1) {
            try {
                this.appendToWal(netIoJob, parser, tud);
            }
            catch (Throwable ex) {
                tud.setWriterInError();
                LOG.critical().$("closing writer because of error [table=").$(tud.getTableNameUtf16()).$(",ex=").$(ex).I$();
                this.engine.getMetrics().health().incrementUnhandledErrors();
            }
            return false;
        }
        return this.dispatchEvent(netIoJob, parser, tud);
    }

    void setListener(LineTcpReceiver.SchedulerListener listener) {
        this.listener = listener;
    }
}

