/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.components.monitor;

import java.text.NumberFormat;
import java.util.List;
import org.apache.nifi.controller.ActiveThreadInfo;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ThreadDetails;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.reporting.Severity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongRunningTaskMonitor
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LongRunningTaskMonitor.class);
    private final FlowManager flowManager;
    private final EventReporter eventReporter;
    private final long thresholdMillis;

    public LongRunningTaskMonitor(FlowManager flowManager, EventReporter eventReporter, long thresholdMillis) {
        this.flowManager = flowManager;
        this.eventReporter = eventReporter;
        this.thresholdMillis = thresholdMillis;
    }

    @Override
    public void run() {
        this.getLogger().debug("Checking long running processor tasks...");
        long start = System.nanoTime();
        int activeThreadCount = 0;
        int longRunningThreadCount = 0;
        ThreadDetails threadDetails = this.captureThreadDetails();
        for (ProcessorNode processorNode : this.flowManager.getRootGroup().findAllProcessors()) {
            List activeThreads = processorNode.getActiveThreads(threadDetails);
            activeThreadCount += activeThreads.size();
            for (ActiveThreadInfo activeThread : activeThreads) {
                if (activeThread.getActiveMillis() <= this.thresholdMillis) continue;
                ++longRunningThreadCount;
                String taskSeconds = String.format("%,d seconds", activeThread.getActiveMillis() / 1000L);
                this.getLogger().warn(String.format("Long running task detected on processor [id=%s, name=%s, type=%s]. Task time: %s. Stack trace:\n%s", processorNode.getIdentifier(), processorNode.getName(), processorNode.getComponentType(), taskSeconds, activeThread.getStackTrace()));
                this.eventReporter.reportEvent(Severity.WARNING, "Long Running Task", String.format("Processor with ID %s, Name %s and Type %s has a task that has been running for %s (thread name: %s).", processorNode.getIdentifier(), processorNode.getName(), processorNode.getComponentType(), taskSeconds, activeThread.getThreadName()));
                processorNode.getLogger().warn(String.format("The processor has a task that has been running for %s (thread name: %s).", taskSeconds, activeThread.getThreadName()));
            }
        }
        long nanos = System.nanoTime() - start;
        this.getLogger().info("Active threads: {}; Long running threads: {}; time to check: {} nanos", new Object[]{activeThreadCount, longRunningThreadCount, NumberFormat.getInstance().format(nanos)});
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    protected ThreadDetails captureThreadDetails() {
        return ThreadDetails.capture();
    }
}

