/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.params;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;

public class DeleteAsset
extends AbstractNiFiCommand<VoidResult> {
    public DeleteAsset() {
        super("delete-asset", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Deletes an asset from a given parameter context";
    }

    @Override
    protected void doInitialize(Context context) {
        super.doInitialize(context);
        this.addOption(CommandOption.PARAM_CONTEXT_ID.createOption());
        this.addOption(CommandOption.ASSET_ID.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String paramContextId = this.getRequiredArg(properties, CommandOption.PARAM_CONTEXT_ID);
        String assetId = this.getRequiredArg(properties, CommandOption.ASSET_ID);
        client.getParamContextClient().deleteAsset(paramContextId, assetId);
        return VoidResult.getInstance();
    }
}

