/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication.ott.reactive;

import java.time.Clock;
import org.springframework.security.authentication.ott.GenerateOneTimeTokenRequest;
import org.springframework.security.authentication.ott.InMemoryOneTimeTokenService;
import org.springframework.security.authentication.ott.OneTimeToken;
import org.springframework.security.authentication.ott.OneTimeTokenAuthenticationToken;
import org.springframework.security.authentication.ott.reactive.ReactiveOneTimeTokenService;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public final class InMemoryReactiveOneTimeTokenService
implements ReactiveOneTimeTokenService {
    private final InMemoryOneTimeTokenService oneTimeTokenService = new InMemoryOneTimeTokenService();

    @Override
    public Mono<OneTimeToken> generate(GenerateOneTimeTokenRequest request) {
        return Mono.just((Object)request).map(this.oneTimeTokenService::generate);
    }

    @Override
    public Mono<OneTimeToken> consume(OneTimeTokenAuthenticationToken authenticationToken) {
        return Mono.just((Object)authenticationToken).mapNotNull(this.oneTimeTokenService::consume);
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"clock cannot be null");
        this.oneTimeTokenService.setClock(clock);
    }
}

