/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmKeyPropertyRef;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.provider.CsdlPropertyRef;

public class EdmKeyPropertyRefImpl
implements EdmKeyPropertyRef {
    private final CsdlPropertyRef ref;
    private EdmEntityType edmEntityType;
    private EdmProperty property;

    public EdmKeyPropertyRefImpl(EdmEntityType edmEntityType, CsdlPropertyRef ref) {
        this.edmEntityType = edmEntityType;
        this.ref = ref;
    }

    @Override
    public String getName() {
        return this.ref.getName();
    }

    @Override
    public String getAlias() {
        return this.ref.getAlias();
    }

    @Override
    public EdmProperty getProperty() {
        if (this.property == null) {
            if (this.getAlias() == null) {
                this.property = this.edmEntityType.getStructuralProperty(this.getName());
                if (this.property == null) {
                    throw new EdmException("Invalid key property ref specified. Can\u00b4t find property with name: " + this.getName());
                }
            } else {
                if (this.getName() == null || this.getName().isEmpty()) {
                    throw new EdmException("Alias but no path specified for propertyRef");
                }
                String[] splitPath = this.getName().split("/");
                EdmStructuredType structType = this.edmEntityType;
                for (int i = 0; i < splitPath.length - 1; ++i) {
                    EdmProperty _property = structType.getStructuralProperty(splitPath[i]);
                    if (_property == null) {
                        throw new EdmException("Invalid property ref specified. Can\u00b4t find property with name: " + splitPath[i] + " at type: " + structType.getNamespace() + "." + structType.getName());
                    }
                    structType = (EdmStructuredType)_property.getType();
                }
                this.property = structType.getStructuralProperty(splitPath[splitPath.length - 1]);
                if (this.property == null) {
                    throw new EdmException("Invalid property ref specified. Can\u00b4t find property with name: " + splitPath[splitPath.length - 1] + " at type: " + structType.getNamespace() + "." + structType.getName());
                }
            }
        }
        return this.property;
    }
}

