/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.util.Collection;
import org.apache.openjpa.kernel.exps.ExpressionFactory;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.persistence.criteria.CriteriaQueryImpl;
import org.apache.openjpa.persistence.criteria.Expressions;
import org.apache.openjpa.persistence.criteria.SelectionImpl;

abstract class ExpressionImpl<X>
extends SelectionImpl<X>
implements Expression<X> {
    public ExpressionImpl(Class<X> cls) {
        super(cls);
    }

    public <Y> Expression<Y> as(Class<Y> type) {
        return type == this.getJavaType() ? this : new Expressions.CastAs<Y>(type, this);
    }

    public Predicate in(Object ... values) {
        Expressions.In result = new Expressions.In(this);
        for (Object v : values) {
            result.value(v);
        }
        return result;
    }

    public Predicate in(Expression<?> ... values) {
        Expressions.In result = new Expressions.In(this);
        for (Expression<?> e : values) {
            result.value(e);
        }
        return result;
    }

    public Predicate in(Collection<?> values) {
        Expressions.In result = new Expressions.In(this);
        for (Object e : values) {
            result.value(e);
        }
        return result;
    }

    public Predicate in(Expression<Collection<?>> values) {
        Expressions.In result = new Expressions.In(this);
        result.value(values);
        return result;
    }

    public Predicate isNotNull() {
        return new Expressions.IsNotNull(this);
    }

    public Predicate isNull() {
        return new Expressions.IsNull(this);
    }

    abstract Value toValue(ExpressionFactory var1, CriteriaQueryImpl<?> var2);

    org.apache.openjpa.kernel.exps.Expression toKernelExpression(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
        return factory.asExpression(this.toValue(factory, q));
    }
}

