/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.annotation;

import java.io.IOException;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.annotation.AnnotationValidator;
import org.apache.pdfbox.preflight.exception.ValidationException;

public class LinkAnnotationValidator
extends AnnotationValidator {
    protected PDAnnotationLink pdLink = null;

    public LinkAnnotationValidator(PreflightContext ctx, COSDictionary annotDictionary) {
        super(ctx, annotDictionary);
        this.pdLink = new PDAnnotationLink(annotDictionary);
        this.pdAnnot = this.pdLink;
    }

    public boolean validate() throws ValidationException {
        boolean isValide = super.validate();
        isValide = isValide && this.checkDest();
        return isValide;
    }

    protected boolean checkDest() {
        try {
            PDDestination dest = this.pdLink.getDestination();
            if (dest != null && this.pdLink.getAction() != null) {
                this.ctx.addValidationError(new ValidationResult.ValidationError("5.2.4", "Dest can't be used due to A element"));
                return false;
            }
        }
        catch (IOException e) {
            this.ctx.addValidationError(new ValidationResult.ValidationError("5.3.3", "Dest can't be checked"));
            return false;
        }
        return true;
    }

    protected boolean checkMandatoryFields() {
        boolean result;
        boolean subtype = this.annotDictionary.containsKey(COSName.SUBTYPE);
        boolean rect = this.annotDictionary.containsKey(COSName.RECT);
        boolean f = this.annotDictionary.containsKey(COSName.F);
        boolean bl = result = subtype && rect && f;
        if (!result) {
            this.ctx.addValidationError(new ValidationResult.ValidationError("5.1"));
        }
        return result;
    }
}

