/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.encoding.Encoding;
import org.apache.pdfbox.preflight.font.util.GlyphDescription;
import org.apache.pdfbox.preflight.font.util.GlyphException;

public class Type1 {
    private Map<Integer, String> cidToLabel = new HashMap<Integer, String>(0);
    private Map<String, Integer> labelToCid = new HashMap<String, Integer>(0);
    private Map<String, GlyphDescription> labelToMetric = new HashMap<String, GlyphDescription>(0);
    private Encoding encoding = null;

    public Type1(Encoding encoding) {
        this.encoding = encoding;
    }

    void addCidWithLabel(Integer cid, String label) {
        this.labelToCid.put(label, cid);
        this.cidToLabel.put(cid, label);
    }

    void addGlyphDescription(String glyphLabel, GlyphDescription description) {
        this.labelToMetric.put(glyphLabel, description);
    }

    void initEncodingWithStandardEncoding() {
        this.labelToCid.put("/A", 65);
        this.labelToCid.put("/AE", 225);
        this.labelToCid.put("/B", 66);
        this.labelToCid.put("/C", 67);
        this.labelToCid.put("/D", 68);
        this.labelToCid.put("/E", 69);
        this.labelToCid.put("/F", 70);
        this.labelToCid.put("/G", 71);
        this.labelToCid.put("/H", 72);
        this.labelToCid.put("/I", 73);
        this.labelToCid.put("/J", 74);
        this.labelToCid.put("/K", 75);
        this.labelToCid.put("/L", 76);
        this.labelToCid.put("/Lslash", 232);
        this.labelToCid.put("/M", 77);
        this.labelToCid.put("/N", 78);
        this.labelToCid.put("/O", 79);
        this.labelToCid.put("/OE", 234);
        this.labelToCid.put("/Oslash", 233);
        this.labelToCid.put("/P", 80);
        this.labelToCid.put("/Q", 81);
        this.labelToCid.put("/R", 82);
        this.labelToCid.put("/S", 83);
        this.labelToCid.put("/T", 84);
        this.labelToCid.put("/U", 85);
        this.labelToCid.put("/V", 86);
        this.labelToCid.put("/W", 87);
        this.labelToCid.put("/X", 88);
        this.labelToCid.put("/Y", 89);
        this.labelToCid.put("/Z", 90);
        this.labelToCid.put("/a", 97);
        this.labelToCid.put("/acute", 194);
        this.labelToCid.put("/acute", 194);
        this.labelToCid.put("/ae", 241);
        this.labelToCid.put("/ampersand", 38);
        this.labelToCid.put("/asciicircum", 94);
        this.labelToCid.put("/asciitilde", 126);
        this.labelToCid.put("/asterisk", 42);
        this.labelToCid.put("/at", 64);
        this.labelToCid.put("/b", 98);
        this.labelToCid.put("/backslash", 92);
        this.labelToCid.put("/bar", 124);
        this.labelToCid.put("/braceleft", 123);
        this.labelToCid.put("/braceright", 125);
        this.labelToCid.put("/bracketleft", 91);
        this.labelToCid.put("/bracketright", 93);
        this.labelToCid.put("/breve", 198);
        this.labelToCid.put("/bullet", 183);
        this.labelToCid.put("/c", 99);
        this.labelToCid.put("/caron", 207);
        this.labelToCid.put("/cedilla", 203);
        this.labelToCid.put("/cent", 162);
        this.labelToCid.put("/circumflex", 195);
        this.labelToCid.put("/colon", 58);
        this.labelToCid.put("/comma", 44);
        this.labelToCid.put("/currency", 168);
        this.labelToCid.put("/d", 100);
        this.labelToCid.put("/dagger", 178);
        this.labelToCid.put("/daggerdbl", 179);
        this.labelToCid.put("/dieresis", 200);
        this.labelToCid.put("/dollar", 36);
        this.labelToCid.put("/dotaccent", 199);
        this.labelToCid.put("/dotlessi", 245);
        this.labelToCid.put("/e", 101);
        this.labelToCid.put("/eight", 56);
        this.labelToCid.put("/ellipsis", 274);
        this.labelToCid.put("/emdash", 208);
        this.labelToCid.put("/endash", 177);
        this.labelToCid.put("/equal", 61);
        this.labelToCid.put("/exclam", 33);
        this.labelToCid.put("/exclamdown", 161);
        this.labelToCid.put("/f", 102);
        this.labelToCid.put("/fi", 174);
        this.labelToCid.put("/five", 53);
        this.labelToCid.put("/fl", 175);
        this.labelToCid.put("/florin", 166);
        this.labelToCid.put("/four", 52);
        this.labelToCid.put("/fraction", 164);
        this.labelToCid.put("/g", 103);
        this.labelToCid.put("/germandbls", 251);
        this.labelToCid.put("/grave", 193);
        this.labelToCid.put("/greater", 62);
        this.labelToCid.put("/guillemotleft", 171);
        this.labelToCid.put("/guillemotright", 187);
        this.labelToCid.put("/guilsinglleft", 172);
        this.labelToCid.put("/guilsinglright", 173);
        this.labelToCid.put("/h", 104);
        this.labelToCid.put("/hungarumlaut", 205);
        this.labelToCid.put("/hyphen", 45);
        this.labelToCid.put("/i", 105);
        this.labelToCid.put("/j", 106);
        this.labelToCid.put("/k", 107);
        this.labelToCid.put("/l", 108);
        this.labelToCid.put("/less", 60);
        this.labelToCid.put("/lslash", 248);
        this.labelToCid.put("/m", 109);
        this.labelToCid.put("/macron", 197);
        this.labelToCid.put("/n", 110);
        this.labelToCid.put("/nine", 57);
        this.labelToCid.put("/numbersign", 35);
        this.labelToCid.put("/o", 111);
        this.labelToCid.put("/oe", 250);
        this.labelToCid.put("/ogonek", 206);
        this.labelToCid.put("/one", 49);
        this.labelToCid.put("/ordfeminine", 227);
        this.labelToCid.put("/ordmasculine", 235);
        this.labelToCid.put("/oslash", 249);
        this.labelToCid.put("/p", 112);
        this.labelToCid.put("/paragraph", 182);
        this.labelToCid.put("/parenleft", 40);
        this.labelToCid.put("/parenright", 41);
        this.labelToCid.put("/percent", 37);
        this.labelToCid.put("/period", 46);
        this.labelToCid.put("/periodcentered", 180);
        this.labelToCid.put("/perthousand", 189);
        this.labelToCid.put("/plus", 43);
        this.labelToCid.put("/q", 113);
        this.labelToCid.put("/question", 63);
        this.labelToCid.put("/questiondown", 191);
        this.labelToCid.put("/quotedbl", 34);
        this.labelToCid.put("/quotedblbase", 185);
        this.labelToCid.put("/quotedblleft", 170);
        this.labelToCid.put("/quotedblright", 186);
        this.labelToCid.put("/quoteleft", 96);
        this.labelToCid.put("/quoteright", 39);
        this.labelToCid.put("/quotesinglbase", 184);
        this.labelToCid.put("/quotesingle", 169);
        this.labelToCid.put("/r", 114);
        this.labelToCid.put("/ring", 202);
        this.labelToCid.put("/s", 115);
        this.labelToCid.put("/section", 167);
        this.labelToCid.put("/semicolon", 59);
        this.labelToCid.put("/seven", 55);
        this.labelToCid.put("/six", 54);
        this.labelToCid.put("/slash", 47);
        this.labelToCid.put("/space", 32);
        this.labelToCid.put("/sterling", 163);
        this.labelToCid.put("/t", 116);
        this.labelToCid.put("/three", 51);
        this.labelToCid.put("/tilde", 196);
        this.labelToCid.put("/two", 50);
        this.labelToCid.put("/u", 117);
        this.labelToCid.put("/underscore", 95);
        this.labelToCid.put("/v", 118);
        this.labelToCid.put("/w", 119);
        this.labelToCid.put("/x", 120);
        this.labelToCid.put("/y", 121);
        this.labelToCid.put("/yen", 165);
        this.labelToCid.put("/z", 122);
        this.labelToCid.put("/zero", 48);
        this.transafertLTOCinCTIL();
    }

    private void transafertLTOCinCTIL() {
        for (Map.Entry<String, Integer> entry : this.labelToCid.entrySet()) {
            this.cidToLabel.put(entry.getValue(), entry.getKey());
        }
    }

    void initEncodingWithISOLatin1Encoding() {
        this.labelToCid.put("/A", 65);
        this.labelToCid.put("/AE", 198);
        this.labelToCid.put("/Aacute", 193);
        this.labelToCid.put("/Acircumflex", 194);
        this.labelToCid.put("/Adieresis", 196);
        this.labelToCid.put("/Agrave", 192);
        this.labelToCid.put("/Aring", 197);
        this.labelToCid.put("/Atilde", 195);
        this.labelToCid.put("/B", 66);
        this.labelToCid.put("/C", 67);
        this.labelToCid.put("/Ccedilla", 199);
        this.labelToCid.put("/D", 68);
        this.labelToCid.put("/E", 69);
        this.labelToCid.put("/Eacute", 201);
        this.labelToCid.put("/Ecircumflex", 202);
        this.labelToCid.put("/Edieresis", 203);
        this.labelToCid.put("/Egrave", 200);
        this.labelToCid.put("/Eth", 208);
        this.labelToCid.put("/F", 70);
        this.labelToCid.put("/G", 71);
        this.labelToCid.put("/H", 72);
        this.labelToCid.put("/I", 73);
        this.labelToCid.put("/Iacute", 205);
        this.labelToCid.put("/Icircumflex", 206);
        this.labelToCid.put("/Idieresis", 207);
        this.labelToCid.put("/Igrave", 204);
        this.labelToCid.put("/J", 74);
        this.labelToCid.put("/K", 75);
        this.labelToCid.put("/L", 76);
        this.labelToCid.put("/M", 77);
        this.labelToCid.put("/N", 78);
        this.labelToCid.put("/Ntilde", 209);
        this.labelToCid.put("/O", 79);
        this.labelToCid.put("/Oacute", 211);
        this.labelToCid.put("/Ocircumflex", 212);
        this.labelToCid.put("/Odieresis", 214);
        this.labelToCid.put("/Ograve", 210);
        this.labelToCid.put("/Oslash", 216);
        this.labelToCid.put("/Otilde", 213);
        this.labelToCid.put("/P", 80);
        this.labelToCid.put("/Q", 81);
        this.labelToCid.put("/R", 82);
        this.labelToCid.put("/S", 83);
        this.labelToCid.put("/T", 84);
        this.labelToCid.put("/Thorn", 222);
        this.labelToCid.put("/U", 85);
        this.labelToCid.put("/Uacute", 218);
        this.labelToCid.put("/Ucircumflex", 219);
        this.labelToCid.put("/Udieresis", 220);
        this.labelToCid.put("/Ugrave", 217);
        this.labelToCid.put("/V", 86);
        this.labelToCid.put("/W", 87);
        this.labelToCid.put("/X", 88);
        this.labelToCid.put("/Y", 89);
        this.labelToCid.put("/Yacute", 221);
        this.labelToCid.put("/Z", 90);
        this.labelToCid.put("/a", 97);
        this.labelToCid.put("/aacute", 225);
        this.labelToCid.put("/acircumflex", 226);
        this.labelToCid.put("/acute", 146);
        this.labelToCid.put("/acute", 180);
        this.labelToCid.put("/adieresis", 228);
        this.labelToCid.put("/ae", 230);
        this.labelToCid.put("/agrave", 224);
        this.labelToCid.put("/ampersand", 38);
        this.labelToCid.put("/aring", 229);
        this.labelToCid.put("/asciicircum", 94);
        this.labelToCid.put("/asciitilde", 126);
        this.labelToCid.put("/asterisk", 42);
        this.labelToCid.put("/at", 64);
        this.labelToCid.put("/atilde", 227);
        this.labelToCid.put("/b", 98);
        this.labelToCid.put("/backslash", 92);
        this.labelToCid.put("/bar", 124);
        this.labelToCid.put("/braceleft", 123);
        this.labelToCid.put("/braceright", 125);
        this.labelToCid.put("/bracketleft", 91);
        this.labelToCid.put("/bracketright", 93);
        this.labelToCid.put("/breve", 150);
        this.labelToCid.put("/brokenbar", 166);
        this.labelToCid.put("/c", 99);
        this.labelToCid.put("/caron", 159);
        this.labelToCid.put("/ccedilla", 231);
        this.labelToCid.put("/cedilla", 184);
        this.labelToCid.put("/cent", 162);
        this.labelToCid.put("/circumflex", 147);
        this.labelToCid.put("/colon", 58);
        this.labelToCid.put("/comma", 44);
        this.labelToCid.put("/copyright", 169);
        this.labelToCid.put("/currency", 164);
        this.labelToCid.put("/d", 100);
        this.labelToCid.put("/degree", 176);
        this.labelToCid.put("/dieresis", 168);
        this.labelToCid.put("/divide", 247);
        this.labelToCid.put("/dollar", 36);
        this.labelToCid.put("/dotaccent", 151);
        this.labelToCid.put("/dotlessi", 144);
        this.labelToCid.put("/e", 101);
        this.labelToCid.put("/eacute", 233);
        this.labelToCid.put("/ecircumflex", 234);
        this.labelToCid.put("/edieresis", 235);
        this.labelToCid.put("/egrave", 232);
        this.labelToCid.put("/eight", 56);
        this.labelToCid.put("/equal", 61);
        this.labelToCid.put("/eth", 240);
        this.labelToCid.put("/exclam", 33);
        this.labelToCid.put("/exclamdown", 161);
        this.labelToCid.put("/f", 102);
        this.labelToCid.put("/five", 53);
        this.labelToCid.put("/four", 52);
        this.labelToCid.put("/g", 103);
        this.labelToCid.put("/germandbls", 223);
        this.labelToCid.put("/grave", 145);
        this.labelToCid.put("/greater", 62);
        this.labelToCid.put("/guillemotleft", 171);
        this.labelToCid.put("/guillemotright", 187);
        this.labelToCid.put("/h", 104);
        this.labelToCid.put("/hungarumlaut", 157);
        this.labelToCid.put("/hyphen", 173);
        this.labelToCid.put("/i", 105);
        this.labelToCid.put("/iacute", 237);
        this.labelToCid.put("/icircumflex", 238);
        this.labelToCid.put("/idieresis", 239);
        this.labelToCid.put("/igrave", 236);
        this.labelToCid.put("/j", 106);
        this.labelToCid.put("/k", 107);
        this.labelToCid.put("/l", 108);
        this.labelToCid.put("/less", 60);
        this.labelToCid.put("/logicalnot", 172);
        this.labelToCid.put("/m", 109);
        this.labelToCid.put("/macron", 175);
        this.labelToCid.put("/minus", 45);
        this.labelToCid.put("/mu", 181);
        this.labelToCid.put("/multiply", 215);
        this.labelToCid.put("/n", 110);
        this.labelToCid.put("/nine", 57);
        this.labelToCid.put("/ntilde", 241);
        this.labelToCid.put("/numbersign", 35);
        this.labelToCid.put("/o", 111);
        this.labelToCid.put("/oacute", 243);
        this.labelToCid.put("/ocircumflex", 244);
        this.labelToCid.put("/odieresis", 246);
        this.labelToCid.put("/ogonek", 158);
        this.labelToCid.put("/ograve", 242);
        this.labelToCid.put("/one", 49);
        this.labelToCid.put("/onehalf", 189);
        this.labelToCid.put("/onequarter", 188);
        this.labelToCid.put("/onesuperior", 185);
        this.labelToCid.put("/ordfeminine", 170);
        this.labelToCid.put("/ordmasculine", 186);
        this.labelToCid.put("/oslash", 248);
        this.labelToCid.put("/otilde", 245);
        this.labelToCid.put("/p", 112);
        this.labelToCid.put("/paragraph", 182);
        this.labelToCid.put("/parenleft", 40);
        this.labelToCid.put("/parenright", 41);
        this.labelToCid.put("/percent", 37);
        this.labelToCid.put("/period", 46);
        this.labelToCid.put("/periodcentered", 183);
        this.labelToCid.put("/plus", 43);
        this.labelToCid.put("/plusminus", 177);
        this.labelToCid.put("/q", 113);
        this.labelToCid.put("/question", 63);
        this.labelToCid.put("/questiondown", 191);
        this.labelToCid.put("/quotedbl", 34);
        this.labelToCid.put("/quoteleft", 96);
        this.labelToCid.put("/quoteright", 39);
        this.labelToCid.put("/r", 114);
        this.labelToCid.put("/registered", 174);
        this.labelToCid.put("/ring", 154);
        this.labelToCid.put("/s", 115);
        this.labelToCid.put("/section", 167);
        this.labelToCid.put("/semicolon", 59);
        this.labelToCid.put("/seven", 55);
        this.labelToCid.put("/six", 54);
        this.labelToCid.put("/slash", 47);
        this.labelToCid.put("/space", 32);
        this.labelToCid.put("/sterling", 163);
        this.labelToCid.put("/t", 116);
        this.labelToCid.put("/thorn", 254);
        this.labelToCid.put("/three", 51);
        this.labelToCid.put("/threequarters", 190);
        this.labelToCid.put("/threesuperior", 179);
        this.labelToCid.put("/tilde", 148);
        this.labelToCid.put("/two", 50);
        this.labelToCid.put("/twosuperior", 178);
        this.labelToCid.put("/u", 117);
        this.labelToCid.put("/uacute", 250);
        this.labelToCid.put("/ucircumflex", 251);
        this.labelToCid.put("/udieresis", 252);
        this.labelToCid.put("/ugrave", 249);
        this.labelToCid.put("/underscore", 95);
        this.labelToCid.put("/v", 118);
        this.labelToCid.put("/w", 119);
        this.labelToCid.put("/x", 120);
        this.labelToCid.put("/y", 121);
        this.labelToCid.put("/yacute", 253);
        this.labelToCid.put("/ydieresis", 255);
        this.labelToCid.put("/yen", 165);
        this.labelToCid.put("/z", 122);
        this.labelToCid.put("/zero", 48);
        this.transafertLTOCinCTIL();
    }

    public int getWidthOfCID(int cid) throws GlyphException {
        String label = this.getLabelAsName(cid);
        GlyphDescription glyph = this.labelToMetric.get(label);
        if (glyph != null) {
            return glyph.getGlyphWidth();
        }
        throw new GlyphException("3.3.1", cid, "Missing glyph for the CID " + cid);
    }

    private String getLabelAsName(int cid) {
        String label;
        block2: {
            label = null;
            try {
                label = this.encoding.getName(cid);
            }
            catch (IOException e) {
                label = this.cidToLabel.get(cid);
                if (label != null) break block2;
                label = "/.notdef";
            }
        }
        return label.charAt(0) == '/' ? label : '/' + label;
    }
}

