/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.workload.mt.handlers;

import com.lmax.disruptor.LifecycleAware;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CyclicBarrier;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.result.ResultValue;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.apache.phoenix.pherf.workload.mt.generators.BaseLoadEventGenerator;
import org.apache.phoenix.pherf.workload.mt.generators.TenantOperationInfo;
import org.apache.phoenix.pherf.workload.mt.handlers.PherfWorkHandler;
import org.apache.phoenix.pherf.workload.mt.operations.OperationStats;
import org.apache.phoenix.pherf.workload.mt.operations.TenantOperationFactory;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.thirdparty.com.google.common.base.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RendezvousingWorkHandler
implements PherfWorkHandler<BaseLoadEventGenerator.TenantOperationEvent>,
LifecycleAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(RendezvousingWorkHandler.class);
    private final String handlerId;
    private final TenantOperationFactory operationFactory;
    private final Map<String, CyclicBarrier> rendezvousPoints;

    public RendezvousingWorkHandler(TenantOperationFactory operationFactory, String handlerId, Map<String, CyclicBarrier> rendezvousPoints) {
        this.handlerId = handlerId;
        this.operationFactory = operationFactory;
        this.rendezvousPoints = rendezvousPoints;
    }

    @Override
    public void onEvent(BaseLoadEventGenerator.TenantOperationEvent event) throws Exception {
        TenantOperationInfo input = event.getTenantOperationInfo();
        Supplier<Function<TenantOperationInfo, OperationStats>> opSupplier = this.operationFactory.getOperationSupplier(input);
        boolean startRendezvousEnabled = this.rendezvousPoints.containsKey("pherf.mt.handlers_start_rendezvous");
        if (startRendezvousEnabled) {
            this.rendezvousPoints.get("pherf.mt.handlers_start_rendezvous").await();
        }
        OperationStats stats = opSupplier.get().apply(input);
        stats.setHandlerId(this.handlerId);
        boolean resultsRendezvousEnabled = this.rendezvousPoints.containsKey("pherf.mt.handlers_results_rendezvous");
        if (resultsRendezvousEnabled) {
            this.rendezvousPoints.get("pherf.mt.handlers_results_rendezvous").await();
        }
        this.operationFactory.getPhoenixUtil();
        LOGGER.info(PhoenixUtil.getGSON().toJson(stats));
    }

    @Override
    public void onStart() {
        Scenario scenario = this.operationFactory.getScenario();
        LOGGER.info(String.format("TenantOperationWorkHandler started for %s:%s", scenario.getName(), scenario.getTableName()));
    }

    @Override
    public void onShutdown() {
        Scenario scenario = this.operationFactory.getScenario();
        LOGGER.info(String.format("TenantOperationWorkHandler stopped for %s:%s", scenario.getName(), scenario.getTableName()));
    }

    @Override
    public List<ResultValue<OperationStats>> getResults() {
        return new ArrayList<ResultValue<OperationStats>>();
    }
}

