/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.workload.mt.operations;

import java.util.concurrent.TimeUnit;
import org.apache.phoenix.pherf.configuration.DataModel;
import org.apache.phoenix.pherf.configuration.IdleTime;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.apache.phoenix.pherf.workload.mt.generators.TenantOperationInfo;
import org.apache.phoenix.pherf.workload.mt.operations.BaseOperationSupplier;
import org.apache.phoenix.pherf.workload.mt.operations.IdleTimeOperation;
import org.apache.phoenix.pherf.workload.mt.operations.OperationStats;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleTimeOperationSupplier
extends BaseOperationSupplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdleTimeOperationSupplier.class);

    public IdleTimeOperationSupplier(PhoenixUtil phoenixUtil, DataModel model, Scenario scenario) {
        super(phoenixUtil, model, scenario);
    }

    @Override
    public Function<TenantOperationInfo, OperationStats> get() {
        return new Function<TenantOperationInfo, OperationStats>(){

            @Override
            public OperationStats apply(TenantOperationInfo input) {
                Preconditions.checkNotNull(input);
                IdleTimeOperation operation = (IdleTimeOperation)input.getOperation();
                IdleTime idleTime = operation.getIdleTime();
                String tenantId = input.getTenantId();
                String tenantGroup = input.getTenantGroupId();
                String opGroup = input.getOperationGroupId();
                String tableName = input.getTableName();
                String scenarioName = input.getScenarioName();
                String opName = String.format("%s:%s:%s:%s:%s", scenarioName, tableName, opGroup, tenantGroup, tenantId);
                long startTime = EnvironmentEdgeManager.currentTimeMillis();
                int status = 0;
                try {
                    TimeUnit.MILLISECONDS.sleep(idleTime.getIdleTime());
                }
                catch (InterruptedException ie) {
                    LOGGER.error("Operation " + opName + " failed with exception ", (Throwable)ie);
                    status = -1;
                }
                long duration = EnvironmentEdgeManager.currentTimeMillis() - startTime;
                return new OperationStats(input, startTime, status, 0L, duration);
            }
        };
    }
}

