/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.queryserver.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.avatica.server.AvaticaServerConfiguration;
import org.apache.calcite.avatica.server.ServerCustomizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.queryserver.server.customizers.HostedClientJarsServerCustomizer;
import org.apache.phoenix.queryserver.server.customizers.JMXJsonEndpointServerCustomizer;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ServerCustomizersFactory {
    public List<ServerCustomizer<Server>> createServerCustomizers(Configuration var1, AvaticaServerConfiguration var2);

    public static class ServerCustomizersFactoryImpl
    implements ServerCustomizersFactory {
        private static final Logger LOG = LoggerFactory.getLogger(ServerCustomizersFactoryImpl.class);

        @Override
        public List<ServerCustomizer<Server>> createServerCustomizers(Configuration conf, AvaticaServerConfiguration avaticaServerConfiguration) {
            ArrayList<ServerCustomizer<Server>> customizers = new ArrayList<ServerCustomizer<Server>>();
            if (conf.getBoolean("phoenix.queryserver.client.jars.enabled", false)) {
                String repoLocation = conf.get("phoenix.queryserver.client.jars.repo", "");
                if (repoLocation != null && !repoLocation.isEmpty()) {
                    File repo = new File(repoLocation);
                    if (!repo.isDirectory()) {
                        throw new IllegalArgumentException("Provided maven repository is not a directory. " + repo);
                    }
                    String contextPath = conf.get("phoenix.queryserver.client.jars.context", "/maven");
                    LOG.info("Creating ServerCustomizer to host client jars from {} at HTTP endpoint {}", (Object)repo, (Object)contextPath);
                    HostedClientJarsServerCustomizer customizer = new HostedClientJarsServerCustomizer(repo, contextPath);
                    customizers.add(customizer);
                } else {
                    LOG.warn("Empty value provided for {}, ignoring", (Object)"phoenix.queryserver.client.jars.repo");
                }
            }
            if (!conf.getBoolean("phoenix.queryserver.jmxjsonendpoint.disabled", false)) {
                customizers.add(new JMXJsonEndpointServerCustomizer());
            }
            return Collections.unmodifiableList(customizers);
        }
    }
}

