/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataProtocolLevel is the corresponding interface of BACnetConstructedDataProtocolLevel
type BACnetConstructedDataProtocolLevel interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetProtocolLevel returns ProtocolLevel (property field)
	GetProtocolLevel() BACnetProtocolLevelTagged
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetProtocolLevelTagged
	// IsBACnetConstructedDataProtocolLevel is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataProtocolLevel()
	// CreateBuilder creates a BACnetConstructedDataProtocolLevelBuilder
	CreateBACnetConstructedDataProtocolLevelBuilder() BACnetConstructedDataProtocolLevelBuilder
}

// _BACnetConstructedDataProtocolLevel is the data-structure of this message
type _BACnetConstructedDataProtocolLevel struct {
	BACnetConstructedDataContract
	ProtocolLevel BACnetProtocolLevelTagged
}

var _ BACnetConstructedDataProtocolLevel = (*_BACnetConstructedDataProtocolLevel)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataProtocolLevel)(nil)

// NewBACnetConstructedDataProtocolLevel factory function for _BACnetConstructedDataProtocolLevel
func NewBACnetConstructedDataProtocolLevel(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, protocolLevel BACnetProtocolLevelTagged, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataProtocolLevel {
	if protocolLevel == nil {
		panic("protocolLevel of type BACnetProtocolLevelTagged for BACnetConstructedDataProtocolLevel must not be nil")
	}
	_result := &_BACnetConstructedDataProtocolLevel{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		ProtocolLevel:                 protocolLevel,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataProtocolLevelBuilder is a builder for BACnetConstructedDataProtocolLevel
type BACnetConstructedDataProtocolLevelBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(protocolLevel BACnetProtocolLevelTagged) BACnetConstructedDataProtocolLevelBuilder
	// WithProtocolLevel adds ProtocolLevel (property field)
	WithProtocolLevel(BACnetProtocolLevelTagged) BACnetConstructedDataProtocolLevelBuilder
	// WithProtocolLevelBuilder adds ProtocolLevel (property field) which is build by the builder
	WithProtocolLevelBuilder(func(BACnetProtocolLevelTaggedBuilder) BACnetProtocolLevelTaggedBuilder) BACnetConstructedDataProtocolLevelBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataProtocolLevel or returns an error if something is wrong
	Build() (BACnetConstructedDataProtocolLevel, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataProtocolLevel
}

// NewBACnetConstructedDataProtocolLevelBuilder() creates a BACnetConstructedDataProtocolLevelBuilder
func NewBACnetConstructedDataProtocolLevelBuilder() BACnetConstructedDataProtocolLevelBuilder {
	return &_BACnetConstructedDataProtocolLevelBuilder{_BACnetConstructedDataProtocolLevel: new(_BACnetConstructedDataProtocolLevel)}
}

type _BACnetConstructedDataProtocolLevelBuilder struct {
	*_BACnetConstructedDataProtocolLevel

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataProtocolLevelBuilder) = (*_BACnetConstructedDataProtocolLevelBuilder)(nil)

func (b *_BACnetConstructedDataProtocolLevelBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataProtocolLevel
}

func (b *_BACnetConstructedDataProtocolLevelBuilder) WithMandatoryFields(protocolLevel BACnetProtocolLevelTagged) BACnetConstructedDataProtocolLevelBuilder {
	return b.WithProtocolLevel(protocolLevel)
}

func (b *_BACnetConstructedDataProtocolLevelBuilder) WithProtocolLevel(protocolLevel BACnetProtocolLevelTagged) BACnetConstructedDataProtocolLevelBuilder {
	b.ProtocolLevel = protocolLevel
	return b
}

func (b *_BACnetConstructedDataProtocolLevelBuilder) WithProtocolLevelBuilder(builderSupplier func(BACnetProtocolLevelTaggedBuilder) BACnetProtocolLevelTaggedBuilder) BACnetConstructedDataProtocolLevelBuilder {
	builder := builderSupplier(b.ProtocolLevel.CreateBACnetProtocolLevelTaggedBuilder())
	var err error
	b.ProtocolLevel, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetProtocolLevelTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataProtocolLevelBuilder) Build() (BACnetConstructedDataProtocolLevel, error) {
	if b.ProtocolLevel == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'protocolLevel' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataProtocolLevel.deepCopy(), nil
}

func (b *_BACnetConstructedDataProtocolLevelBuilder) MustBuild() BACnetConstructedDataProtocolLevel {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataProtocolLevelBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataProtocolLevelBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataProtocolLevelBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataProtocolLevelBuilder().(*_BACnetConstructedDataProtocolLevelBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataProtocolLevelBuilder creates a BACnetConstructedDataProtocolLevelBuilder
func (b *_BACnetConstructedDataProtocolLevel) CreateBACnetConstructedDataProtocolLevelBuilder() BACnetConstructedDataProtocolLevelBuilder {
	if b == nil {
		return NewBACnetConstructedDataProtocolLevelBuilder()
	}
	return &_BACnetConstructedDataProtocolLevelBuilder{_BACnetConstructedDataProtocolLevel: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataProtocolLevel) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataProtocolLevel) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_PROTOCOL_LEVEL
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataProtocolLevel) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataProtocolLevel) GetProtocolLevel() BACnetProtocolLevelTagged {
	return m.ProtocolLevel
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataProtocolLevel) GetActualValue() BACnetProtocolLevelTagged {
	ctx := context.Background()
	_ = ctx
	return CastBACnetProtocolLevelTagged(m.GetProtocolLevel())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataProtocolLevel(structType any) BACnetConstructedDataProtocolLevel {
	if casted, ok := structType.(BACnetConstructedDataProtocolLevel); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataProtocolLevel); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataProtocolLevel) GetTypeName() string {
	return "BACnetConstructedDataProtocolLevel"
}

func (m *_BACnetConstructedDataProtocolLevel) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (protocolLevel)
	lengthInBits += m.ProtocolLevel.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataProtocolLevel) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataProtocolLevel) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataProtocolLevel BACnetConstructedDataProtocolLevel, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataProtocolLevel"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataProtocolLevel")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	protocolLevel, err := ReadSimpleField[BACnetProtocolLevelTagged](ctx, "protocolLevel", ReadComplex[BACnetProtocolLevelTagged](BACnetProtocolLevelTaggedParseWithBufferProducer((uint8)(uint8(0)), (TagClass)(TagClass_APPLICATION_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'protocolLevel' field"))
	}
	m.ProtocolLevel = protocolLevel

	actualValue, err := ReadVirtualField[BACnetProtocolLevelTagged](ctx, "actualValue", (*BACnetProtocolLevelTagged)(nil), protocolLevel)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataProtocolLevel"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataProtocolLevel")
	}

	return m, nil
}

func (m *_BACnetConstructedDataProtocolLevel) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataProtocolLevel) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataProtocolLevel"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataProtocolLevel")
		}

		if err := WriteSimpleField[BACnetProtocolLevelTagged](ctx, "protocolLevel", m.GetProtocolLevel(), WriteComplex[BACnetProtocolLevelTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'protocolLevel' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataProtocolLevel"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataProtocolLevel")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataProtocolLevel) IsBACnetConstructedDataProtocolLevel() {}

func (m *_BACnetConstructedDataProtocolLevel) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataProtocolLevel) deepCopy() *_BACnetConstructedDataProtocolLevel {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataProtocolLevelCopy := &_BACnetConstructedDataProtocolLevel{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetProtocolLevelTagged](m.ProtocolLevel),
	}
	_BACnetConstructedDataProtocolLevelCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataProtocolLevelCopy
}

func (m *_BACnetConstructedDataProtocolLevel) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
