/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetClientCOVNone extends BACnetClientCOV implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final BACnetApplicationTagNull defaultIncrement;

  public BACnetClientCOVNone(
      BACnetTagHeader peekedTagHeader, BACnetApplicationTagNull defaultIncrement) {
    super(peekedTagHeader);
    this.defaultIncrement = defaultIncrement;
  }

  public BACnetApplicationTagNull getDefaultIncrement() {
    return defaultIncrement;
  }

  @Override
  protected void serializeBACnetClientCOVChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetClientCOVNone");

    // Simple Field (defaultIncrement)
    writeSimpleField("defaultIncrement", defaultIncrement, writeComplex(writeBuffer));

    writeBuffer.popContext("BACnetClientCOVNone");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetClientCOVNone _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (defaultIncrement)
    lengthInBits += defaultIncrement.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetClientCOVBuilder staticParseBACnetClientCOVBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("BACnetClientCOVNone");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetApplicationTagNull defaultIncrement =
        readSimpleField(
            "defaultIncrement",
            readComplex(
                () -> (BACnetApplicationTagNull) BACnetApplicationTag.staticParse(readBuffer),
                readBuffer));

    readBuffer.closeContext("BACnetClientCOVNone");
    // Create the instance
    return new BACnetClientCOVNoneBuilderImpl(defaultIncrement);
  }

  public static class BACnetClientCOVNoneBuilderImpl
      implements BACnetClientCOV.BACnetClientCOVBuilder {
    private final BACnetApplicationTagNull defaultIncrement;

    public BACnetClientCOVNoneBuilderImpl(BACnetApplicationTagNull defaultIncrement) {
      this.defaultIncrement = defaultIncrement;
    }

    public BACnetClientCOVNone build(BACnetTagHeader peekedTagHeader) {
      BACnetClientCOVNone bACnetClientCOVNone =
          new BACnetClientCOVNone(peekedTagHeader, defaultIncrement);
      return bACnetClientCOVNone;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetClientCOVNone)) {
      return false;
    }
    BACnetClientCOVNone that = (BACnetClientCOVNone) o;
    return (getDefaultIncrement() == that.getDefaultIncrement()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getDefaultIncrement());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
