/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum ClockAndTimekeepingCommandTypeContainer {
  MediaTransportControlCommandUpdateNetworkVariable_0Bytes(
      (short) 0x08, (byte) 0, ClockAndTimekeepingCommandType.UPDATE_NETWORK_VARIABLE),
  MediaTransportControlCommandUpdateNetworkVariable_1Bytes(
      (short) 0x09, (byte) 1, ClockAndTimekeepingCommandType.UPDATE_NETWORK_VARIABLE),
  MediaTransportControlCommandUpdateNetworkVariable_2Bytes(
      (short) 0x0A, (byte) 2, ClockAndTimekeepingCommandType.UPDATE_NETWORK_VARIABLE),
  MediaTransportControlCommandUpdateNetworkVariable_3Bytes(
      (short) 0x0B, (byte) 3, ClockAndTimekeepingCommandType.UPDATE_NETWORK_VARIABLE),
  MediaTransportControlCommandUpdateNetworkVariable_4Bytes(
      (short) 0x0C, (byte) 4, ClockAndTimekeepingCommandType.UPDATE_NETWORK_VARIABLE),
  MediaTransportControlCommandUpdateNetworkVariable_5Bytes(
      (short) 0x0D, (byte) 5, ClockAndTimekeepingCommandType.UPDATE_NETWORK_VARIABLE),
  MediaTransportControlCommandUpdateNetworkVariable_6Bytes(
      (short) 0x0E, (byte) 6, ClockAndTimekeepingCommandType.UPDATE_NETWORK_VARIABLE),
  MediaTransportControlCommandUpdateNetworkVariable_7Bytes(
      (short) 0x0F, (byte) 7, ClockAndTimekeepingCommandType.UPDATE_NETWORK_VARIABLE),
  MediaTransportControlCommandRequestRefresh(
      (short) 0x11, (byte) 1, ClockAndTimekeepingCommandType.REQUEST_REFRESH);
  private static final Map<Short, ClockAndTimekeepingCommandTypeContainer> map;

  static {
    map = new HashMap<>();
    for (ClockAndTimekeepingCommandTypeContainer value :
        ClockAndTimekeepingCommandTypeContainer.values()) {
      map.put((short) value.getValue(), value);
    }
  }

  private final short value;
  private final byte numBytes;
  private final ClockAndTimekeepingCommandType commandType;

  ClockAndTimekeepingCommandTypeContainer(
      short value, byte numBytes, ClockAndTimekeepingCommandType commandType) {
    this.value = value;
    this.numBytes = numBytes;
    this.commandType = commandType;
  }

  public short getValue() {
    return value;
  }

  public byte getNumBytes() {
    return numBytes;
  }

  public static ClockAndTimekeepingCommandTypeContainer firstEnumForFieldNumBytes(byte fieldValue) {
    for (ClockAndTimekeepingCommandTypeContainer _val :
        ClockAndTimekeepingCommandTypeContainer.values()) {
      if (_val.getNumBytes() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<ClockAndTimekeepingCommandTypeContainer> enumsForFieldNumBytes(
      byte fieldValue) {
    List<ClockAndTimekeepingCommandTypeContainer> _values = new ArrayList<>();
    for (ClockAndTimekeepingCommandTypeContainer _val :
        ClockAndTimekeepingCommandTypeContainer.values()) {
      if (_val.getNumBytes() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public ClockAndTimekeepingCommandType getCommandType() {
    return commandType;
  }

  public static ClockAndTimekeepingCommandTypeContainer firstEnumForFieldCommandType(
      ClockAndTimekeepingCommandType fieldValue) {
    for (ClockAndTimekeepingCommandTypeContainer _val :
        ClockAndTimekeepingCommandTypeContainer.values()) {
      if (_val.getCommandType() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<ClockAndTimekeepingCommandTypeContainer> enumsForFieldCommandType(
      ClockAndTimekeepingCommandType fieldValue) {
    List<ClockAndTimekeepingCommandTypeContainer> _values = new ArrayList<>();
    for (ClockAndTimekeepingCommandTypeContainer _val :
        ClockAndTimekeepingCommandTypeContainer.values()) {
      if (_val.getCommandType() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public static ClockAndTimekeepingCommandTypeContainer enumForValue(short value) {
    return map.get(value);
  }

  public static Boolean isDefined(short value) {
    return map.containsKey(value);
  }
}
