/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.bridges.frameworks;

import java.util.StringTokenizer;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import org.apache.portals.bridges.frameworks.model.PortletApplicationModel;

public class Forwarder {
    PortletApplicationModel model;
    RenderRequest request;
    RenderResponse response;

    public Forwarder(PortletApplicationModel model, RenderRequest request, RenderResponse response) {
        this.model = model;
        this.request = request;
        this.response = response;
    }

    public String toString() {
        return this.response.createRenderURL().toString();
    }

    private Forwarder() {
    }

    public PortletURL getView(String viewName) {
        PortletURL url = this.response.createRenderURL();
        this.buildLink(viewName, url);
        return url;
    }

    public PortletURL getLink(String actionForward) {
        String forwardName = this.model.getForward(actionForward);
        PortletURL url = this.response.createRenderURL();
        this.buildLink(forwardName, url);
        return url;
    }

    public PortletURL getLink(String forward, String action) {
        String actionForward = this.model.getForward(forward, action);
        PortletURL url = this.response.createRenderURL();
        this.buildLink(actionForward, url);
        return url;
    }

    private void buildLink(String actionForward, PortletURL url) {
        if (actionForward == null) {
            return;
        }
        PortletMode mode = null;
        StringTokenizer tokenizer = new StringTokenizer(actionForward, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.startsWith("mode:")) {
                mode = this.setPortletMode(token.substring("mode:".length()), url);
                continue;
            }
            if (token.startsWith("state:")) {
                this.setWindowState(token.substring("state:".length()), url);
                continue;
            }
            if (mode == null) {
                mode = this.request.getPortletMode();
            }
            if (mode.equals((Object)PortletMode.VIEW)) {
                url.setParameter("bridges.view.view", token);
                continue;
            }
            if (mode.equals((Object)PortletMode.EDIT)) {
                url.setParameter("bridges.view.edit", token);
                continue;
            }
            if (!mode.equals((Object)PortletMode.HELP)) continue;
            url.setParameter("bridges.view.help", token);
        }
    }

    private void setWindowState(String forward, PortletURL url) {
        try {
            if (forward.equals("maximized")) {
                url.setWindowState(WindowState.MAXIMIZED);
            } else if (forward.equals("minimized")) {
                url.setWindowState(WindowState.MINIMIZED);
            } else if (forward.equals("normal")) {
                url.setWindowState(WindowState.NORMAL);
            }
        }
        catch (WindowStateException windowStateException) {
            // empty catch block
        }
    }

    private PortletMode setPortletMode(String forward, PortletURL url) {
        PortletMode mode = null;
        try {
            if (forward.equals("view")) {
                url.setPortletMode(PortletMode.VIEW);
                mode = PortletMode.VIEW;
            } else if (forward.equals("edit")) {
                url.setPortletMode(PortletMode.EDIT);
                mode = PortletMode.EDIT;
            } else if (forward.equals("help")) {
                url.setPortletMode(PortletMode.HELP);
                mode = PortletMode.HELP;
            }
        }
        catch (PortletModeException e) {
            // empty catch block
        }
        return mode;
    }
}

