/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ResourceBundle;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.CheckboxInput;
import org.tp23.antinstaller.input.InputField;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;

public class CheckboxInputRenderer
implements TextOutputFieldRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.text.Res");
    protected InstallerContext ctx;

    public void setContext(InstallerContext ctx) {
        this.ctx = ctx;
    }

    public void renderOutput(OutputField field, BufferedReader reader, PrintStream out) throws IOException {
        CheckboxInput iField = (CheckboxInput)field;
        out.print(iField.getDisplayText());
        out.print("   [");
        out.print(res.getString("_default_"));
        out.print(":");
        out.print(iField.getDefaultValue());
        out.print("]");
        if (InputField.isTrue(iField.getForce())) {
            out.println(res.getString("_required_"));
            iField.setValue(iField.getDefaultValue());
            return;
        }
        out.println();
        String input = reader.readLine();
        out.println();
        if (input == null || input.trim().equals("")) {
            input = iField.getDefaultValue();
        }
        if (InputField.isTrue(input)) {
            iField.setValue("true");
        } else {
            iField.setValue("false");
        }
    }

    public boolean isAbort() {
        return false;
    }

    public void renderError(OutputField field, BufferedReader reader, PrintStream out) {
    }
}

