/* 
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jetspeed.security.impl;

import org.apache.jetspeed.security.GroupPrincipal;

/**
 * <p>{@link GroupPrincipal} interface implementation.</p>
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: GroupPrincipalImpl.java 592149 2007-11-05 21:05:25Z taylor $
 */
public class GroupPrincipalImpl extends BasePrincipalImpl implements GroupPrincipal
{

    /** The serial version uid. */
    private static final long serialVersionUID = 6061115481776568899L;

    private static boolean hiearchicalNames = true;

    public static final Object useHierarchicalNames(boolean hierarchicalNames)
    {
        GroupPrincipalImpl.hiearchicalNames = hierarchicalNames;
        return null;
    }
    
    /**
     * <p>The group principal constructor.</p>
     * @param groupName The group principal name.
     */
    public GroupPrincipalImpl(String groupName)
    {
        super(groupName, PREFS_GROUP_ROOT, hiearchicalNames);
    }

    public GroupPrincipalImpl(String groupName, boolean isEnabled, boolean isMapping)
    {
        super(groupName, PREFS_GROUP_ROOT, hiearchicalNames, isEnabled, isMapping);
    }
    
    /**
     * <p>Compares this principal to the specified object.  Returns true
     * if the object passed in matches the principal represented by
     * the implementation of this interface.</p>
     * @param another Principal to compare with.
     * @return True if the principal passed in is the same as that
     * encapsulated by this principal, and false otherwise.

     */
    public boolean equals(Object another)
    {
        if (!(another instanceof GroupPrincipalImpl))
            return false;
        GroupPrincipalImpl principal = (GroupPrincipalImpl)another;
        return this.getName().equals(principal.getName());
    }

    /**
     * <p>Gets the principal implementation full path from the principal name.</p>
     * <p>Prepends PREFS_GROUP_ROOT if not prepended.</p>        
     * @param name The principal name.
     * @return The preferences full path / principal name.
     */
    public static String getFullPathFromPrincipalName(String name)
    {
        return BasePrincipalImpl.getFullPathFromPrincipalName(name, PREFS_GROUP_ROOT, hiearchicalNames);
    }

    /**
     * <p>Gets the principal name from the principal implementation full path.</p>
     * <p>Remove prepended PREFS_GROUP_ROOT if present.</p>        
     * @param fullPath The principal full path.
     * @return The principal name.
     */
    public static String getPrincipalNameFromFullPath(String fullPath)
    {
        return BasePrincipalImpl.getPrincipalNameFromFullPath(fullPath, PREFS_GROUP_ROOT, hiearchicalNames);
    }

    public static String getFullPathFromPrincipalName(String name, String prefsRoot)    
    {
        return BasePrincipalImpl.getFullPathFromPrincipalName(name, prefsRoot, hiearchicalNames);
    }
    
}
