/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jetspeed.om;

// Jetspeed imports
import org.apache.jetspeed.om.SecurityReference;

/**
 * BaseSecurityReference
 *
 * @author <a href="paulsp@apache.org">Paul Spencer</a>
 * @version $Id: BaseSecurityReference.java 516448 2007-03-09 16:25:47Z ate $
 */
public class BaseSecurityReference implements SecurityReference
{
    
    /** Holds value of property parent. */
    private String parent;
    
    /** Creates new BaseSecurityReference */
    public BaseSecurityReference()
    {
    }
    
    /** Getter for property parent.
     * @return Value of property parent.
     */
    public String getParent()
    {
        return parent;
    }
    
    /** Setter for property parent.
     * @param parent New value of property parent.
     */
    public void setParent(String parent)
    {
        this.parent = parent;
    }
    
    /**
     * Create a clone of this object
     */
    public Object clone()
        throws java.lang.CloneNotSupportedException
    {
        BaseSecurityReference cloned = new BaseSecurityReference();
        cloned.parent = this.parent;
        
        return cloned;

    }   // clone
}
